## Integer#bit

    require 'facets/integer/bitmask'

    0.bit(0).assert == 1
    0.bit(1).assert == 2
    0.bit(2).assert == 4
    0.bit(3).assert == 8

Negate

    1.bit(~0).assert == 0
    2.bit(~1).assert == 0
    4.bit(~2).assert == 0
    8.bit(~3).assert == 0

## Integer#bit?

    a = 8
    assert(! a.bit?(0))
    assert(! a.bit?(1))
    assert(! a.bit?(2))
    assert(  a.bit?(3))
    assert(! a.bit?(4))
    assert(! a.bit?(5))

## Integer#bit_clear

    1.bit_clear(0).assert == 0
    2.bit_clear(1).assert == 0
    4.bit_clear(2).assert == 0
    8.bit_clear(3).assert == 0

## Integer#bitmask

    a =  1
    m = Bit(4)
    a = a.bitmask(m)
    a.assert == 17
    assert( a.bitmask?(m) )

## Kernel#Bit

    n = Bit(4)
    n.assert == 16

