\name{NaryAddImageFilter}
\alias{NaryAddImageFilter}
\title{NaryAddImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Pixel-wise addition of N images.
NaryAddImageFilter}
\details{
This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
The pixel type of the input images must have a valid definition of the
operator+ with each other. This condition is required because
internally this filter will perform the operation
Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.
The total operation over one pixel will be
For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.
WARNING:
No numeric overflow checking is performed in this filter.
See:
NaryAdd for the procedural interface
NaryAddImageFilter}
%C++ includes: sitkNaryAddImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ NaryAddImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NaryAddImageFilter():}{
Destructor
}
}
}
