''' MathML Escape Codes '''
# Thanks to https://www.radford.edu/ibarland/Info/mathml-table-pre.html
# for tabulating. Converted to dictionary here.

ESCAPES = {
'&aacute;': 'á',
'&Aacute;': 'Á',
'&abreve;': 'ă',
'&Abreve;': 'Ă',
'&ac;': '∾',
'&acd;': '∿',
'&acE;': '∾',
'&acirc;': 'â',
'&Acirc;': 'Â',
'&acute;': '´',
'&acy;': 'а',
'&Acy;': 'А',
'&aelig;': 'æ',
'&AElig;': 'Æ',
'&af;': '⁡',
'&afr;': '𝔞',
'&Afr;': '𝔄',
'&agrave;': 'à',
'&Agrave;': 'À',
'&aleph;': 'ℵ',
'&alpha;': 'α',
'&amacr;': 'ā',
'&Amacr;': 'Ā',
'&amalg;': '⨿',
'&and;': '∧',
'&And;': '⩓',
'&andand;': '⩕',
'&andd;': '⩜',
'&andslope;': '⩘',
'&andv;': '⩚',
'&ang;': '∠',
'&ange;': '⦤',
'&angle;': '∠',
'&angmsd;': '∡',
'&angmsdaa;': '⦨',
'&angmsdab;': '⦩',
'&angmsdac;': '⦪',
'&angmsdad;': '⦫',
'&angmsdae;': '⦬',
'&angmsdaf;': '⦭',
'&angmsdag;': '⦮',
'&angmsdah;': '⦯',
'&angrt;': '∟',
'&angrtvb;': '⊾',
'&angrtvbd;': '⦝',
'&angsph;': '∢',
'&angst;': 'Å',
'&angzarr;': '⍼',
'&aogon;': 'ą',
'&Aogon;': 'Ą',
'&aopf;': '𝕒',
'&Aopf;': '𝔸',
'&ap;': '≈',
'&apacir;': '⩯',
'&ape;': '≊',
'&apE;': '⩰',
'&apid;': '≋',
"&apos;": "'",
'&ApplyFunction;': '⁡',
'&approx;': '≈',
'&approxeq;': '≊',
'&aring;': 'å',
'&Aring;': 'Å',
'&ascr;': '𝒶',
'&Ascr;': '𝒜',
'&Assign;': '≔',
'&ast;': '*',
'&asymp;': '≈',
'&atilde;': 'ã',
'&Atilde;': 'Ã',
'&auml;': 'ä',
'&Auml;': 'Ä',
'&awconint;': '∳',
'&awint;': '⨑',
'&backcong;': '≌',
'&backepsilon;': '϶',
'&backprime;': '‵',
'&backsim;': '∽',
'&backsimeq;': '⋍',
'&Backslash;': '∖',
'&Barv;': '⫧',
'&barvee;': '⊽',
'&barwed;': '⌅',
'&Barwed;': '⌆',
'&barwedge;': '⌅',
'&bbrk;': '⎵',
'&bcong;': '≌',
'&bcy;': 'б',
'&Bcy;': 'Б',
'&becaus;': '∵',
'&because;': '∵',
'&Because;': '∵',
'&bemptyv;': '⦰',
'&bepsi;': '϶',
'&bernou;': 'ℬ',
'&Bernoullis;': 'ℬ',
'&beta;': 'β',
'&beth;': 'ℶ',
'&between;': '≬',
'&bfr;': '𝔟',
'&Bfr;': '𝔅',
'&bigcap;': '⋂',
'&bigcirc;': '◯',
'&bigcup;': '⋃',
'&bigodot;': '⨀',
'&bigoplus;': '⨁',
'&bigotimes;': '⨂',
'&bigsqcup;': '⨆',
'&bigstar;': '★',
'&bigtriangledown;': '▽',
'&bigtriangleup;': '△',
'&biguplus;': '⨄',
'&bigvee;': '⋁',
'&bigwedge;': '⋀',
'&bkarow;': '⤍',
'&blacklozenge;': '⧫',
'&blacksquare;': '▪',
'&blacktriangle;': '▴',
'&blacktriangledown;': '▾',
'&blacktriangleleft;': '◂',
'&blacktriangleright;': '▸',
'&blank;': '␣',
'&blk12;': '▒',
'&blk14;': '░',
'&blk34;': '▓',
'&block;': '█',
'&bne;': '=',
'&bnequiv;': '≡',
'&bnot;': '⌐',
'&bNot;': '⫭',
'&bopf;': '𝕓',
'&Bopf;': '𝔹',
'&bot;': '⊥',
'&bottom;': '⊥',
'&bowtie;': '⋈',
'&boxbox;': '⧉',
'&boxdl;': '┐',
'&boxdL;': '╕',
'&boxDl;': '╖',
'&boxDL;': '╗',
'&boxdr;': '┌',
'&boxdR;': '╒',
'&boxDr;': '╓',
'&boxDR;': '╔',
'&boxh;': '─',
'&boxH;': '═',
'&boxhd;': '┬',
'&boxhD;': '╥',
'&boxHd;': '╤',
'&boxHD;': '╦',
'&boxhu;': '┴',
'&boxhU;': '╨',
'&boxHu;': '╧',
'&boxHU;': '╩',
'&boxminus;': '⊟',
'&boxplus;': '⊞',
'&boxtimes;': '⊠',
'&boxul;': '┘',
'&boxuL;': '╛',
'&boxUl;': '╜',
'&boxUL;': '╝',
'&boxur;': '└',
'&boxuR;': '╘',
'&boxUr;': '╙',
'&boxUR;': '╚',
'&boxv;': '│',
'&boxV;': '║',
'&boxvh;': '┼',
'&boxvH;': '╪',
'&boxVh;': '╫',
'&boxVH;': '╬',
'&boxvl;': '┤',
'&boxvL;': '╡',
'&boxVl;': '╢',
'&boxVL;': '╣',
'&boxvr;': '├',
'&boxvR;': '╞',
'&boxVr;': '╟',
'&boxVR;': '╠',
'&bprime;': '‵',
'&breve;': '˘',
'&Breve;': '˘',
'&brvbar;': '¦',
'&bscr;': '𝒷',
'&Bscr;': 'ℬ',
'&bsemi;': '⁏',
'&bsim;': '∽',
'&bsime;': '⋍',
'&bsol;': '\\',
'&bsolb;': '⧅',
'&bsolhsub;': '⟈',
'&bull;': '•',
'&bullet;': '•',
'&bump;': '≎',
'&bumpe;': '≏',
'&bumpE;': '⪮',
'&bumpeq;': '≏',
'&Bumpeq;': '≎',
'&cacute;': 'ć',
'&Cacute;': 'Ć',
'&cap;': '∩',
'&Cap;': '⋒',
'&capand;': '⩄',
'&capbrcup;': '⩉',
'&capcap;': '⩋',
'&capcup;': '⩇',
'&capdot;': '⩀',
'&CapitalDifferentialD;': 'ⅅ',
'&caps;': '∩',
'&caret;': '⁁',
'&caron;': 'ˇ',
'&Cayleys;': 'ℭ',
'&ccaps;': '⩍',
'&ccaron;': 'č',
'&Ccaron;': 'Č',
'&ccedil;': 'ç',
'&Ccedil;': 'Ç',
'&ccirc;': 'ĉ',
'&Ccirc;': 'Ĉ',
'&Cconint;': '∰',
'&ccups;': '⩌',
'&ccupssm;': '⩐',
'&cdot;': 'ċ',
'&Cdot;': 'Ċ',
'&cedil;': '¸',
'&Cedilla;': '¸',
'&cemptyv;': '⦲',
'&cent;': '¢',
'&centerdot;': '·',
'&CenterDot;': '·',
'&cfr;': '𝔠',
'&Cfr;': 'ℭ',
'&chcy;': 'ч',
'&CHcy;': 'Ч',
'&check;': '✓',
'&checkmark;': '✓',
'&chi;': 'χ',
'&cir;': '○',
'&circ;': 'ˆ',
'&circeq;': '≗',
'&circlearrowleft;': '↺',
'&circlearrowright;': '↻',
'&circledast;': '⊛',
'&circledcirc;': '⊚',
'&circleddash;': '⊝',
'&CircleDot;': '⊙',
'&circledR;': '®',
'&circledS;': 'Ⓢ',
'&CircleMinus;': '⊖',
'&CirclePlus;': '⊕',
'&CircleTimes;': '⊗',
'&cire;': '≗',
'&cirE;': '⧃',
'&cirfnint;': '⨐',
'&cirmid;': '⫯',
'&cirscir;': '⧂',
'&ClockwiseContourIntegral;': '∲',
'&CloseCurlyDoubleQuote;': '”',
'&CloseCurlyQuote;': '’',
'&clubs;': '♣',
'&clubsuit;': '♣',
'&colon;': ':',
'&Colon;': '∷',
'&colone;': '≔',
'&Colone;': '⩴',
'&coloneq;': '≔',
'&comma;': ',',
'&commat;': '@',
'&comp;': '∁',
'&compfn;': '∘',
'&complement;': '∁',
'&complexes;': 'ℂ',
'&cong;': '≅',
'&congdot;': '⩭',
'&Congruent;': '≡',
'&conint;': '∮',
'&Conint;': '∯',
'&ContourIntegral;': '∮',
'&copf;': '𝕔',
'&Copf;': 'ℂ',
'&coprod;': '∐',
'&Coproduct;': '∐',
'&copy;': '©',
'&copysr;': '℗',
'&CounterClockwiseContourIntegral;': '∳',
'&cross;': '✗',
'&Cross;': '⨯',
'&cscr;': '𝒸',
'&Cscr;': '𝒞',
'&csub;': '⫏',
'&csube;': '⫑',
'&csup;': '⫐',
'&csupe;': '⫒',
'&ctdot;': '⋯',
'&cudarrl;': '⤸',
'&cudarrr;': '⤵',
'&cuepr;': '⋞',
'&cuesc;': '⋟',
'&cularr;': '↶',
'&cularrp;': '⤽',
'&cup;': '∪',
'&Cup;': '⋓',
'&cupbrcap;': '⩈',
'&cupcap;': '⩆',
'&CupCap;': '≍',
'&cupcup;': '⩊',
'&cupdot;': '⊍',
'&cupor;': '⩅',
'&cups;': '∪',
'&curarr;': '↷',
'&curarrm;': '⤼',
'&curlyeqprec;': '⋞',
'&curlyeqsucc;': '⋟',
'&curlyvee;': '⋎',
'&curlywedge;': '⋏',
'&curren;': '¤',
'&curvearrowleft;': '↶',
'&curvearrowright;': '↷',
'&cuvee;': '⋎',
'&cuwed;': '⋏',
'&cwconint;': '∲',
'&cwint;': '∱',
'&cylcty;': '⌭',
'&dagger;': '†',
'&Dagger;': '‡',
'&daleth;': 'ℸ',
'&darr;': '↓',
'&dArr;': '⇓',
'&Darr;': '↡',
'&dash;': '‐',
'&dashv;': '⊣',
'&Dashv;': '⫤',
'&dbkarow;': '⤏',
'&dblac;': '˝',
'&dcaron;': 'ď',
'&Dcaron;': 'Ď',
'&dcy;': 'д',
'&Dcy;': 'Д',
'&dd;': 'ⅆ',
'&DD;': 'ⅅ',
'&ddagger;': '‡',
'&ddarr;': '⇊',
'&DDotrahd;': '⤑',
'&ddotseq;': '⩷',
'&deg;': '°',
'&Del;': '∇',
'&delta;': 'δ',
'&Delta;': 'Δ',
'&demptyv;': '⦱',
'&dfisht;': '⥿',
'&dfr;': '𝔡',
'&Dfr;': '𝔇',
'&dHar;': '⥥',
'&dharl;': '⇃',
'&dharr;': '⇂',
'&DiacriticalAcute;': '´',
'&DiacriticalDot;': '˙',
'&DiacriticalDoubleAcute;': '˝',
'&DiacriticalGrave;': '`',
'&DiacriticalTilde;': '˜',
'&diam;': '⋄',
'&diamond;': '⋄',
'&Diamond;': '⋄',
'&diamondsuit;': '♦',
'&diams;': '♦',
'&die;': '¨',
'&DifferentialD;': 'ⅆ',
'&digamma;': 'ϝ',
'&disin;': '⋲',
'&div;': '÷',
'&divide;': '÷',
'&divideontimes;': '⋇',
'&divonx;': '⋇',
'&djcy;': 'ђ',
'&DJcy;': 'Ђ',
'&dlcorn;': '⌞',
'&dlcrop;': '⌍',
'&dollar;': '$',
'&dopf;': '𝕕',
'&Dopf;': '𝔻',
'&dot;': '˙',
'&Dot;': '¨',
'&DotDot;': '⃜',
'&doteq;': '≐',
'&doteqdot;': '≑',
'&DotEqual;': '≐',
'&dotminus;': '∸',
'&dotplus;': '∔',
'&dotsquare;': '⊡',
'&doublebarwedge;': '⌆',
'&DoubleContourIntegral;': '∯',
'&DoubleDot;': '¨',
'&DoubleDownArrow;': '⇓',
'&DoubleLeftArrow;': '⇐',
'&DoubleLeftRightArrow;': '⇔',
'&DoubleLeftTee;': '⫤',
'&DoubleLongLeftArrow;': '⟸',
'&DoubleLongLeftRightArrow;': '⟺',
'&DoubleLongRightArrow;': '⟹',
'&DoubleRightArrow;': '⇒',
'&DoubleRightTee;': '⊨',
'&DoubleUpArrow;': '⇑',
'&DoubleUpDownArrow;': '⇕',
'&DoubleVerticalBar;': '∥',
'&downarrow;': '↓',
'&Downarrow;': '⇓',
'&DownArrow;': '↓',
'&DownArrowBar;': '⤓',
'&DownArrowUpArrow;': '⇵',
'&DownBreve;': '̑',
'&downdownarrows;': '⇊',
'&downharpoonleft;': '⇃',
'&downharpoonright;': '⇂',
'&DownLeftRightVector;': '⥐',
'&DownLeftTeeVector;': '⥞',
'&DownLeftVector;': '↽',
'&DownLeftVectorBar;': '⥖',
'&DownRightTeeVector;': '⥟',
'&DownRightVector;': '⇁',
'&DownRightVectorBar;': '⥗',
'&DownTee;': '⊤',
'&DownTeeArrow;': '↧',
'&drbkarow;': '⤐',
'&drcorn;': '⌟',
'&drcrop;': '⌌',
'&dscr;': '𝒹',
'&Dscr;': '𝒟',
'&dscy;': 'ѕ',
'&DScy;': 'Ѕ',
'&dsol;': '⧶',
'&dstrok;': 'đ',
'&Dstrok;': 'Đ',
'&dtdot;': '⋱',
'&dtri;': '▿',
'&dtrif;': '▾',
'&duarr;': '⇵',
'&duhar;': '⥯',
'&dwangle;': '⦦',
'&dzcy;': 'џ',
'&DZcy;': 'Џ',
'&dzigrarr;': '⟿',
'&eacute;': 'é',
'&Eacute;': 'É',
'&easter;': '⩮',
'&ecaron;': 'ě',
'&Ecaron;': 'Ě',
'&ecir;': '≖',
'&ecirc;': 'ê',
'&Ecirc;': 'Ê',
'&ecolon;': '≕',
'&ecy;': 'э',
'&Ecy;': 'Э',
'&eDDot;': '⩷',
'&edot;': 'ė',
'&eDot;': '≑',
'&Edot;': 'Ė',
'&ee;': 'ⅇ',
'&efDot;': '≒',
'&efr;': '𝔢',
'&Efr;': '𝔈',
'&eg;': '⪚',
'&egrave;': 'è',
'&Egrave;': 'È',
'&egs;': '⪖',
'&egsdot;': '⪘',
'&el;': '⪙',
'&Element;': '∈',
'&ell;': 'ℓ',
'&els;': '⪕',
'&elsdot;': '⪗',
'&emacr;': 'ē',
'&Emacr;': 'Ē',
'&empty;': '∅',
'&emptyset;': '∅',
'&EmptySmallSquare;': '◻',
'&emptyv;': '∅',
'&EmptyVerySmallSquare;': '▫',
'&emsp;': ' ',
'&emsp13;': ' ',
'&emsp14;': ' ',
'&eng;': 'ŋ',
'&ENG;': 'Ŋ',
'&ensp;': ' ',
'&eogon;': 'ę',
'&Eogon;': 'Ę',
'&eopf;': '𝕖',
'&Eopf;': '𝔼',
'&epar;': '⋕',
'&eparsl;': '⧣',
'&eplus;': '⩱',
'&epsi;': 'ε',
'&epsiv;': 'ϵ',
'&eqcirc;': '≖',
'&eqcolon;': '≕',
'&eqsim;': '≂',
'&epsilon;': 'ε',
'&Epsilon;': 'Ε',
'&eqslantgtr;': '⪖',
'&eqslantless;': '⪕',
'&Equal;': '⩵',
'&equals;': '=',
'&EqualTilde;': '≂',
'&equest;': '≟',
'&Equilibrium;': '⇌',
'&equiv;': '≡',
'&equivDD;': '⩸',
'&eqvparsl;': '⧥',
'&erarr;': '⥱',
'&erDot;': '≓',
'&escr;': 'ℯ',
'&Escr;': 'ℰ',
'&esdot;': '≐',
'&esim;': '≂',
'&Esim;': '⩳',
'&eta;': 'η',
'&eth;': 'ð',
'&ETH;': 'Ð',
'&euml;': 'ë',
'&Euml;': 'Ë',
'&excl;': '!',
'&exist;': '∃',
'&Exists;': '∃',
'&expectation;': 'ℰ',
'&exponentiale;': 'ⅇ',
'&ExponentialE;': 'ⅇ',
'&fallingdotseq;': '≒',
'&fcy;': 'ф',
'&Fcy;': 'Ф',
'&female;': '♀',
'&ffilig;': 'ﬃ',
'&fflig;': 'ﬀ',
'&ffllig;': 'ﬄ',
'&ffr;': '𝔣',
'&Ffr;': '𝔉',
'&filig;': 'ﬁ',
'&FilledSmallSquare;': '◼',
'&FilledVerySmallSquare;': '▪',
'&flat;': '♭',
'&fllig;': 'ﬂ',
'&fnof;': 'ƒ',
'&fopf;': '𝕗',
'&Fopf;': '𝔽',
'&forall;': '∀',
'&ForAll;': '∀',
'&fork;': '⋔',
'&forkv;': '⫙',
'&Fouriertrf;': 'ℱ',
'&fpartint;': '⨍',
'&frac12;': '½',
'&frac13;': '⅓',
'&frac14;': '¼',
'&frac15;': '⅕',
'&frac16;': '⅙',
'&frac18;': '⅛',
'&frac23;': '⅔',
'&frac25;': '⅖',
'&frac34;': '¾',
'&frac35;': '⅗',
'&frac38;': '⅜',
'&frac45;': '⅘',
'&frac56;': '⅚',
'&frac58;': '⅝',
'&frac78;': '⅞',
'&frown;': '⌢',
'&fscr;': '𝒻',
'&Fscr;': 'ℱ',
'&gacute;': 'ǵ',
'&gamma;': 'γ',
'&Gamma;': 'Γ',
'&gammad;': 'ϝ',
'&Gammad;': 'Ϝ',
'&gap;': '⪆',
'&gbreve;': 'ğ',
'&Gbreve;': 'Ğ',
'&Gcedil;': 'Ģ',
'&gcirc;': 'ĝ',
'&Gcirc;': 'Ĝ',
'&gcy;': 'г',
'&Gcy;': 'Г',
'&gdot;': 'ġ',
'&Gdot;': 'Ġ',
'&ge;': '≥',
'&gE;': '≧',
'&gel;': '⋛',
'&gEl;': '⪌',
'&geq;': '≥',
'&geqq;': '≧',
'&geqslant;': '⩾',
'&ges;': '⩾',
'&gescc;': '⪩',
'&gesdot;': '⪀',
'&gesdoto;': '⪂',
'&gesdotol;': '⪄',
'&gesl;': '⋛',
'&gesles;': '⪔',
'&gfr;': '𝔤',
'&Gfr;': '𝔊',
'&gg;': '≫',
'&Gg;': '⋙',
'&ggg;': '⋙',
'&gimel;': 'ℷ',
'&gjcy;': 'ѓ',
'&GJcy;': 'Ѓ',
'&gl;': '≷',
'&gla;': '⪥',
'&glE;': '⪒',
'&glj;': '⪤',
'&gnap;': '⪊',
'&gnapprox;': '⪊',
'&gne;': '⪈',
'&gnE;': '≩',
'&gneq;': '⪈',
'&gneqq;': '≩',
'&gnsim;': '⋧',
'&gopf;': '𝕘',
'&Gopf;': '𝔾',
'&grave;': '`',
'&GreaterEqual;': '≥',
'&GreaterEqualLess;': '⋛',
'&GreaterFullEqual;': '≧',
'&GreaterGreater;': '⪢',
'&GreaterLess;': '≷',
'&GreaterSlantEqual;': '⩾',
'&GreaterTilde;': '≳',
'&gscr;': 'ℊ',
'&Gscr;': '𝒢',
'&gsim;': '≳',
'&gsime;': '⪎',
'&gsiml;': '⪐',
'&Gt;': '≫',
'&gtcc;': '⪧',
'&gtcir;': '⩺',
'&gtdot;': '⋗',
'&gtlPar;': '⦕',
'&gtquest;': '⩼',
'&gtrapprox;': '⪆',
'&gtrarr;': '⥸',
'&gtrdot;': '⋗',
'&gtreqless;': '⋛',
'&gtreqqless;': '⪌',
'&gtrless;': '≷',
'&gtrsim;': '≳',
'&gvertneqq;': '≩',
'&gvnE;': '≩',
'&Hacek;': 'ˇ',
'&hairsp;': ' ',
'&half;': '½',
'&hamilt;': 'ℋ',
'&hardcy;': 'ъ',
'&HARDcy;': 'Ъ',
'&harr;': '↔',
'&hArr;': '⇔',
'&harrcir;': '⥈',
'&harrw;': '↭',
'&Hat;': 'ˆ',
'&hbar;': 'ℏ',
'&hcirc;': 'ĥ',
'&Hcirc;': 'Ĥ',
'&heartsuit;': '♥',
'&hellip;': '…',
'&hercon;': '⊹',
'&hfr;': '𝔥',
'&Hfr;': 'ℌ',
'&HilbertSpace;': 'ℋ',
'&hksearow;': '⤥',
'&hkswarow;': '⤦',
'&hoarr;': '⇿',
'&homtht;': '∻',
'&hookleftarrow;': '↩',
'&hookrightarrow;': '↪',
'&hopf;': '𝕙',
'&Hopf;': 'ℍ',
'&horbar;': '―',
'&HorizontalLine;': '─',
'&hscr;': '𝒽',
'&Hscr;': 'ℋ',
'&hslash;': 'ℏ',
'&hstrok;': 'ħ',
'&Hstrok;': 'Ħ',
'&HumpDownHump;': '≎',
'&HumpEqual;': '≏',
'&hybull;': '⁃',
'&hyphen;': '‐',
'&iacute;': 'í',
'&Iacute;': 'Í',
'&ic;': '⁣',
'&icirc;': 'î',
'&Icirc;': 'Î',
'&icy;': 'и',
'&Icy;': 'И',
'&Idot;': 'İ',
'&iecy;': 'е',
'&IEcy;': 'Е',
'&iexcl;': '¡',
'&iff;': '⇔',
'&ifr;': '𝔦',
'&Ifr;': 'ℑ',
'&igrave;': 'ì',
'&Igrave;': 'Ì',
'&ii;': 'ⅈ',
'&iiiint;': '⨌',
'&iiint;': '∭',
'&iinfin;': '⧜',
'&iiota;': '℩',
'&ijlig;': 'ĳ',
'&IJlig;': 'Ĳ',
'&Im;': 'ℑ',
'&imacr;': 'ī',
'&Imacr;': 'Ī',
'&image;': 'ℑ',
'&ImaginaryI;': 'ⅈ',
'&imagline;': 'ℐ',
'&imagpart;': 'ℑ',
'&imath;': 'ı',
'&imof;': '⊷',
'&imped;': 'Ƶ',
'&Implies;': '⇒',
'&in;': '∈',
'&incare;': '℅',
'&infin;': '∞',
'&inodot;': 'ı',
'&int;': '∫',
'&Int;': '∬',
'&intcal;': '⊺',
'&integers;': 'ℤ',
'&Integral;': '∫',
'&intercal;': '⊺',
'&Intersection;': '⋂',
'&intlarhk;': '⨗',
'&intprod;': '⨼',
'&InvisibleComma;': '⁣',
'&InvisibleTimes;': '⁢',
'&iocy;': 'ё',
'&IOcy;': 'Ё',
'&iogon;': 'į',
'&Iogon;': 'Į',
'&iopf;': '𝕚',
'&Iopf;': '𝕀',
'&iota;': 'ι',
'&iprod;': '⨼',
'&iquest;': '¿',
'&iscr;': '𝒾',
'&Iscr;': 'ℐ',
'&isin;': '∈',
'&isindot;': '⋵',
'&isinE;': '⋹',
'&isins;': '⋴',
'&isinsv;': '⋳',
'&isinv;': '∈',
'&it;': '⁢',
'&itilde;': 'ĩ',
'&Itilde;': 'Ĩ',
'&iukcy;': 'і',
'&Iukcy;': 'І',
'&iuml;': 'ï',
'&Iuml;': 'Ï',
'&jcirc;': 'ĵ',
'&Jcirc;': 'Ĵ',
'&jcy;': 'й',
'&Jcy;': 'Й',
'&jfr;': '𝔧',
'&Jfr;': '𝔍',
'&jmath;': 'ȷ',
'&jopf;': '𝕛',
'&Jopf;': '𝕁',
'&jscr;': '𝒿',
'&Jscr;': '𝒥',
'&jsercy;': 'ј',
'&Jsercy;': 'Ј',
'&jukcy;': 'є',
'&Jukcy;': 'Є',
'&kappa;': 'κ',
'&kappav;': 'ϰ',
'&kcedil;': 'ķ',
'&Kcedil;': 'Ķ',
'&kcy;': 'к',
'&Kcy;': 'К',
'&kfr;': '𝔨',
'&Kfr;': '𝔎',
'&kgreen;': 'ĸ',
'&khcy;': 'х',
'&KHcy;': 'Х',
'&kjcy;': 'ќ',
'&KJcy;': 'Ќ',
'&kopf;': '𝕜',
'&Kopf;': '𝕂',
'&kscr;': '𝓀',
'&Kscr;': '𝒦',
'&lAarr;': '⇚',
'&lacute;': 'ĺ',
'&Lacute;': 'Ĺ',
'&laemptyv;': '⦴',
'&lagran;': 'ℒ',
'&lambda;': 'λ',
'&Lambda;': 'Λ',
'&lang;': '⟨',
'&Lang;': '⟪',
'&langd;': '⦑',
'&langle;': '⟨',
'&lap;': '⪅',
'&Laplacetrf;': 'ℒ',
'&laquo;': '«',
'&larr;': '←',
'&lArr;': '⇐',
'&Larr;': '↞',
'&larrb;': '⇤',
'&larrbfs;': '⤟',
'&larrfs;': '⤝',
'&larrhk;': '↩',
'&larrlp;': '↫',
'&larrpl;': '⤹',
'&larrsim;': '⥳',
'&larrtl;': '↢',
'&lat;': '⪫',
'&latail;': '⤙',
'&lAtail;': '⤛',
'&late;': '⪭',
'&lates;': '⪭',
'&lbarr;': '⤌',
'&lBarr;': '⤎',
'&lbbrk;': '❲',
'&lbrace;': '{',
'&lbrack;': '[',
'&lbrke;': '⦋',
'&lbrksld;': '⦏',
'&lbrkslu;': '⦍',
'&lcaron;': 'ľ',
'&Lcaron;': 'Ľ',
'&lcedil;': 'ļ',
'&Lcedil;': 'Ļ',
'&lceil;': '⌈',
'&lcub;': '{',
'&lcy;': 'л',
'&Lcy;': 'Л',
'&ldca;': '⤶',
'&ldquo;': '“',
'&ldquor;': '„',
'&ldrdhar;': '⥧',
'&ldrushar;': '⥋',
'&ldsh;': '↲',
'&le;': '≤',
'&lE;': '≦',
'&LeftAngleBracket;': '⟨',
'&leftarrow;': '←',
'&Leftarrow;': '⇐',
'&LeftArrow;': '←',
'&LeftArrowBar;': '⇤',
'&LeftArrowRightArrow;': '⇆',
'&leftarrowtail;': '↢',
'&LeftCeiling;': '⌈',
'&LeftDoubleBracket;': '⟦',
'&LeftDownTeeVector;': '⥡',
'&LeftDownVector;': '⇃',
'&LeftDownVectorBar;': '⥙',
'&LeftFloor;': '⌊',
'&leftharpoondown;': '↽',
'&leftharpoonup;': '↼',
'&leftleftarrows;': '⇇',
'&leftrightarrow;': '↔',
'&Leftrightarrow;': '⇔',
'&LeftRightArrow;': '↔',
'&leftrightarrows;': '⇆',
'&leftrightharpoons;': '⇋',
'&leftrightsquigarrow;': '↭',
'&LeftRightVector;': '⥎',
'&LeftTee;': '⊣',
'&LeftTeeArrow;': '↤',
'&LeftTeeVector;': '⥚',
'&leftthreetimes;': '⋋',
'&LeftTriangle;': '⊲',
'&LeftTriangleBar;': '⧏',
'&LeftTriangleEqual;': '⊴',
'&LeftUpDownVector;': '⥑',
'&LeftUpTeeVector;': '⥠',
'&LeftUpVector;': '↿',
'&LeftUpVectorBar;': '⥘',
'&LeftVector;': '↼',
'&LeftVectorBar;': '⥒',
'&leg;': '⋚',
'&lEg;': '⪋',
'&leq;': '≤',
'&leqq;': '≦',
'&leqslant;': '⩽',
'&les;': '⩽',
'&lescc;': '⪨',
'&lesdot;': '⩿',
'&lesdoto;': '⪁',
'&lesdotor;': '⪃',
'&lesg;': '⋚',
'&lesges;': '⪓',
'&lessapprox;': '⪅',
'&lessdot;': '⋖',
'&lesseqgtr;': '⋚',
'&lesseqqgtr;': '⪋',
'&LessEqualGreater;': '⋚',
'&LessFullEqual;': '≦',
'&LessGreater;': '≶',
'&lessgtr;': '≶',
'&LessLess;': '⪡',
'&lesssim;': '≲',
'&LessSlantEqual;': '⩽',
'&LessTilde;': '≲',
'&lfisht;': '⥼',
'&lfloor;': '⌊',
'&lfr;': '𝔩',
'&Lfr;': '𝔏',
'&lg;': '≶',
'&lgE;': '⪑',
'&lHar;': '⥢',
'&lhard;': '↽',
'&lharu;': '↼',
'&lharul;': '⥪',
'&lhblk;': '▄',
'&ljcy;': 'љ',
'&LJcy;': 'Љ',
'&ll;': '≪',
'&Ll;': '⋘',
'&llarr;': '⇇',
'&llcorner;': '⌞',
'&Lleftarrow;': '⇚',
'&llhard;': '⥫',
'&lltri;': '◺',
'&lmidot;': 'ŀ',
'&Lmidot;': 'Ŀ',
'&lmoust;': '⎰',
'&lmoustache;': '⎰',
'&lnap;': '⪉',
'&lnapprox;': '⪉',
'&lne;': '⪇',
'&lnE;': '≨',
'&lneq;': '⪇',
'&lneqq;': '≨',
'&lnsim;': '⋦',
'&loang;': '⟬',
'&loarr;': '⇽',
'&lobrk;': '⟦',
'&longleftarrow;': '⟵',
'&Longleftarrow;': '⟸',
'&LongLeftArrow;': '⟵',
'&longleftrightarrow;': '⟷',
'&Longleftrightarrow;': '⟺',
'&LongLeftRightArrow;': '⟷',
'&longmapsto;': '⟼',
'&longrightarrow;': '⟶',
'&Longrightarrow;': '⟹',
'&LongRightArrow;': '⟶',
'&looparrowleft;': '↫',
'&looparrowright;': '↬',
'&lopar;': '⦅',
'&lopf;': '𝕝',
'&Lopf;': '𝕃',
'&loplus;': '⨭',
'&lotimes;': '⨴',
'&lowast;': '∗',
'&lowbar;': '_',
'&LowerLeftArrow;': '↙',
'&LowerRightArrow;': '↘',
'&loz;': '◊',
'&lozenge;': '◊',
'&lozf;': '⧫',
'&lpar;': '(',
'&lparlt;': '⦓',
'&lrarr;': '⇆',
'&lrcorner;': '⌟',
'&lrhar;': '⇋',
'&lrhard;': '⥭',
'&lrtri;': '⊿',
'&lscr;': '𝓁',
'&Lscr;': 'ℒ',
'&lsh;': '↰',
'&Lsh;': '↰',
'&lsim;': '≲',
'&lsime;': '⪍',
'&lsimg;': '⪏',
'&lsqb;': '[',
'&lsquo;': '‘',
'&lsquor;': '‚',
'&lstrok;': 'ł',
'&Lstrok;': 'Ł',
'&Lt;': '≪',
'&ltcc;': '⪦',
'&ltcir;': '⩹',
'&ltdot;': '⋖',
'&lthree;': '⋋',
'&ltimes;': '⋉',
'&ltlarr;': '⥶',
'&ltquest;': '⩻',
'&ltri;': '◃',
'&ltrie;': '⊴',
'&ltrif;': '◂',
'&ltrPar;': '⦖',
'&lurdshar;': '⥊',
'&luruhar;': '⥦',
'&lvertneqq;': '≨',
'&lvnE;': '≨',
'&macr;': '¯',
'&male;': '♂',
'&malt;': '✠',
'&maltese;': '✠',
'&map;': '↦',
'&Map;': '⤅',
'&mapsto;': '↦',
'&mapstodown;': '↧',
'&mapstoleft;': '↤',
'&mapstoup;': '↥',
'&marker;': '▮',
'&mcomma;': '⨩',
'&mcy;': 'м',
'&Mcy;': 'М',
'&mdash;': '—',
'&mDDot;': '∺',
'&measuredangle;': '∡',
'&MediumSpace;': ' ',
'&Mellintrf;': 'ℳ',
'&mfr;': '𝔪',
'&Mfr;': '𝔐',
'&mho;': '℧',
'&micro;': 'µ',
'&mid;': '∣',
'&midast;': '*',
'&midcir;': '⫰',
'&middot;': '·',
'&minus;': '−',
'&minusb;': '⊟',
'&minusd;': '∸',
'&minusdu;': '⨪',
'&MinusPlus;': '∓',
'&mlcp;': '⫛',
'&mldr;': '…',
'&mnplus;': '∓',
'&models;': '⊧',
'&mopf;': '𝕞',
'&Mopf;': '𝕄',
'&mp;': '∓',
'&mscr;': '𝓂',
'&Mscr;': 'ℳ',
'&mstpos;': '∾',
'&mu;': 'μ',
'&multimap;': '⊸',
'&mumap;': '⊸',
'&nabla;': '∇',
'&nacute;': 'ń',
'&Nacute;': 'Ń',
'&nang;': '∠',
'&nap;': '≉',
'&napE;': '⩰',
'&napid;': '≋',
'&napos;': 'ŉ',
'&napprox;': '≉',
'&natur;': '♮',
'&natural;': '♮',
'&naturals;': 'ℕ',
'&nbsp;': ' ',
'&nbump;': '≎',
'&nbumpe;': '≏',
'&ncap;': '⩃',
'&ncaron;': 'ň',
'&Ncaron;': 'Ň',
'&ncedil;': 'ņ',
'&Ncedil;': 'Ņ',
'&ncong;': '≇',
'&ncongdot;': '⩭',
'&ncup;': '⩂',
'&ncy;': 'н',
'&Ncy;': 'Н',
'&ndash;': '–',
'&ne;': '≠',
'&nearhk;': '⤤',
'&nearr;': '↗',
'&neArr;': '⇗',
'&nearrow;': '↗',
'&nedot;': '≐',
'&NegativeMediumSpace;': '​',
'&NegativeThickSpace;': '​',
'&NegativeThinSpace;': '​',
'&NegativeVeryThinSpace;': '​',
'&nequiv;': '≢',
'&nesear;': '⤨',
'&nesim;': '≂',
'&NestedGreaterGreater;': '≫',
'&NestedLessLess;': '≪',
'&nexist;': '∄',
'&nexists;': '∄',
'&nfr;': '𝔫',
'&Nfr;': '𝔑',
'&nge;': '≱',
'&ngE;': '≧',
'&ngeq;': '≱',
'&ngeqq;': '≱',
'&ngeqslant;': '≱',
'&nges;': '⩾',
'&nGg;': '⋙',
'&ngsim;': '≵',
'&ngt;': '≯',
'&nGt;': '≫',
'&ngtr;': '≯',
'&nGtv;': '≫',
'&nharr;': '↮',
'&nhArr;': '⇎',
'&nhpar;': '⫲',
'&ni;': '∋',
'&nis;': '⋼',
'&nisd;': '⋺',
'&niv;': '∋',
'&njcy;': 'њ',
'&NJcy;': 'Њ',
'&nlarr;': '↚',
'&nlArr;': '⇍',
'&nldr;': '‥',
'&nle;': '≰',
'&nlE;': '≦',
'&nleftarrow;': '↚',
'&nLeftarrow;': '⇍',
'&nleftrightarrow;': '↮',
'&nLeftrightarrow;': '⇎',
'&nleq;': '≰',
'&nleqq;': '≦',
'&nleqslant;': '⩽',
'&nles;': '⩽',
'&nless;': '≮',
'&nLl;': '⋘',
'&nlsim;': '≴',
'&nlt;': '≮',
'&nLt;': '≪',
'&nltri;': '⋪',
'&nltrie;': '⋬',
'&nLtv;': '≪',
'&nmid;': '∤',
'&NoBreak;': '⁠',
'&NonBreakingSpace;': ' ',
'&nopf;': '𝕟',
'&Nopf;': 'ℕ',
'&not;': '¬',
'&Not;': '⫬',
'&NotCongruent;': '≢',
'&NotCupCap;': '≭',
'&NotDoubleVerticalBar;': '∦',
'&NotElement;': '∉',
'&NotEqual;': '≠',
'&NotEqualTilde;': '≂',
'&NotExists;': '∄',
'&NotGreater;': '≯',
'&NotGreaterEqual;': '≱',
'&NotGreaterFullEqual;': '≧',
'&NotGreaterGreater;': '≫',
'&NotGreaterLess;': '≹',
'&NotGreaterSlantEqual;': '⩾',
'&NotGreaterTilde;': '≵',
'&NotHumpDownHump;': '≎',
'&NotHumpEqual;': '≏',
'&notin;': '∉',
'&notindot;': '⋵',
'&notinva;': '∉',
'&notinvb;': '⋷',
'&notinvc;': '⋶',
'&NotLeftTriangle;': '⋪',
'&NotLeftTriangleBar;': '⧏',
'&NotLeftTriangleEqual;': '⋬',
'&NotLess;': '≮',
'&NotLessEqual;': '≰',
'&NotLessGreater;': '≸',
'&NotLessLess;': '≪',
'&NotLessSlantEqual;': '⩽',
'&NotLessTilde;': '≴',
'&NotNestedGreaterGreater;': '⪢',
'&NotNestedLessLess;': '⪡',
'&notni;': '∌',
'&notniva;': '∌',
'&notnivb;': '⋾',
'&notnivc;': '⋽',
'&NotPrecedes;': '⊀',
'&NotPrecedesEqual;': '⪯',
'&NotPrecedesSlantEqual;': '⋠',
'&NotReverseElement;': '∌',
'&NotRightTriangle;': '⋫',
'&NotRightTriangleBar;': '⧐',
'&NotRightTriangleEqual;': '⋭',
'&NotSquareSubset;': '⊏',
'&NotSquareSubsetEqual;': '⋢',
'&NotSquareSuperset;': '⊐',
'&NotSquareSupersetEqual;': '⋣',
'&NotSubset;': '⊂',
'&NotSubsetEqual;': '⊈',
'&NotSucceeds;': '⊁',
'&NotSucceedsEqual;': '⪰',
'&NotSucceedsSlantEqual;': '⋡',
'&NotSucceedsTilde;': '≿',
'&NotSuperset;': '⊃',
'&NotSupersetEqual;': '⊉',
'&NotTilde;': '≁',
'&NotTildeEqual;': '≄',
'&NotTildeFullEqual;': '≇',
'&NotTildeTilde;': '≉',
'&NotVerticalBar;': '∤',
'&npar;': '∦',
'&nparallel;': '∦',
'&nparsl;': '⫽',
'&npart;': '∂',
'&npolint;': '⨔',
'&npr;': '⊀',
'&nprcue;': '⋠',
'&npre;': '⪯',
'&nprec;': '⊀',
'&npreceq;': '⪯',
'&nrarr;': '↛',
'&nrArr;': '⇏',
'&nrarrc;': '⤳',
'&nrarrw;': '↝',
'&nrightarrow;': '↛',
'&nRightarrow;': '⇏',
'&nrtri;': '⋫',
'&nrtrie;': '⋭',
'&nsc;': '⊁',
'&nsccue;': '⋡',
'&nsce;': '⪰',
'&nscr;': '𝓃',
'&Nscr;': '𝒩',
'&nshortmid;': '∤',
'&nshortparallel;': '∦',
'&nsim;': '≁',
'&nsime;': '≄',
'&nsimeq;': '≄',
'&nsmid;': '∤',
'&nspar;': '∦',
'&nsqsube;': '⋢',
'&nsqsupe;': '⋣',
'&nsub;': '⊄',
'&nsube;': '⊈',
'&nsubE;': '⫋',
'&nsubset;': '⊄',
'&nsubseteq;': '⊈',
'&nsubseteqq;': '⫋',
'&nsucc;': '⊁',
'&nsucceq;': '⋡',
'&nsup;': '⊅',
'&nsupe;': '⊉',
'&nsupE;': '⫌',
'&nsupset;': '⊅',
'&nsupseteq;': '⊉',
'&nsupseteqq;': '⫌',
'&ntgl;': '≹',
'&ntilde;': 'ñ',
'&Ntilde;': 'Ñ',
'&ntlg;': '≸',
'&ntriangleleft;': '⋪',
'&ntrianglelefteq;': '⋬',
'&ntriangleright;': '⋫',
'&ntrianglerighteq;': '⋭',
'&nu;': 'ν',
'&num;': '#',
'&numero;': '№',
'&numsp;': ' ',
'&nvap;': '≍',
'&nvdash;': '⊬',
'&nvDash;': '⊭',
'&nVdash;': '⊮',
'&nVDash;': '⊯',
'&nvge;': '≥',
'&nvgt;': '>',
'&nvHarr;': '⤄',
'&nvinfin;': '⧞',
'&nvlArr;': '⤂',
'&nvle;': '≤',
'&nvlt;': '<',
'&nvltrie;': '⊴',
'&nvrArr;': '⤃',
'&nvrtrie;': '⊵',
'&nvsim;': '∼',
'&nwarhk;': '⤣',
'&nwarr;': '↖',
'&nwArr;': '⇖',
'&nwarrow;': '↖',
'&nwnear;': '⤧',
'&oacute;': 'ó',
'&Oacute;': 'Ó',
'&oast;': '⊛',
'&ocir;': '⊚',
'&ocirc;': 'ô',
'&Ocirc;': 'Ô',
'&ocy;': 'о',
'&Ocy;': 'О',
'&odash;': '⊝',
'&odblac;': 'ő',
'&Odblac;': 'Ő',
'&odiv;': '⨸',
'&odot;': '⊙',
'&odsold;': '⦼',
'&oelig;': 'œ',
'&OElig;': 'Œ',
'&ofcir;': '⦿',
'&ofr;': '𝔬',
'&Ofr;': '𝔒',
'&ogon;': '˛',
'&ograve;': 'ò',
'&Ograve;': 'Ò',
'&ogt;': '⧁',
'&ohbar;': '⦵',
'&ohm;': 'Ω',
'&oint;': '∮',
'&olarr;': '↺',
'&olcir;': '⦾',
'&olcross;': '⦻',
'&olt;': '⧀',
'&omacr;': 'ō',
'&Omacr;': 'Ō',
'&omicron;': 'ο',
'&Omicron;': 'Ο',
'&omega;': 'ω',
'&Omega;': 'Ω',
'&omid;': '⦶',
'&ominus;': '⊖',
'&oopf;': '𝕠',
'&Oopf;': '𝕆',
'&opar;': '⦷',
'&OpenCurlyDoubleQuote;': '“',
'&OpenCurlyQuote;': '‘',
'&operp;': '⦹',
'&oplus;': '⊕',
'&or;': '∨',
'&Or;': '⩔',
'&orarr;': '↻',
'&ord;': '⩝',
'&order;': 'ℴ',
'&orderof;': 'ℴ',
'&ordf;': 'ª',
'&ordm;': 'º',
'&origof;': '⊶',
'&oror;': '⩖',
'&orslope;': '⩗',
'&orv;': '⩛',
'&oS;': 'Ⓢ',
'&oscr;': 'ℴ',
'&Oscr;': '𝒪',
'&oslash;': 'ø',
'&Oslash;': 'Ø',
'&osol;': '⊘',
'&otilde;': 'õ',
'&Otilde;': 'Õ',
'&otimes;': '⊗',
'&Otimes;': '⨷',
'&otimesas;': '⨶',
'&ouml;': 'ö',
'&Ouml;': 'Ö',
'&ovbar;': '⌽',
'&OverBar;': '‾',
'&OverBrace;': '⏞',
'&OverBracket;': '⎴',
'&OverParenthesis;': '⏜',
'&par;': '∥',
'&para;': '¶',
'&parallel;': '∥',
'&parsim;': '⫳',
'&parsl;': '⫽',
'&part;': '∂',
'&PartialD;': '∂',
'&pcy;': 'п',
'&Pcy;': 'П',
'&percnt;': '%',
'&period;': '.',
'&permil;': '‰',
'&perp;': '⊥',
'&pertenk;': '‱',
'&pfr;': '𝔭',
'&Pfr;': '𝔓',
'&phi;': 'φ',
'&Phi;': 'Φ',
'&phiv;': 'ϕ',
'&phmmat;': 'ℳ',
'&phone;': '☎',
'&pi;': 'π',
'&Pi;': 'Π',
'&pitchfork;': '⋔',
'&piv;': 'ϖ',
'&planck;': 'ℏ',
'&planckh;': 'ℎ',
'&plankv;': 'ℏ',
'&plus;': '+',
'&plusacir;': '⨣',
'&plusb;': '⊞',
'&pluscir;': '⨢',
'&plusdo;': '∔',
'&plusdu;': '⨥',
'&pluse;': '⩲',
'&PlusMinus;': '±',
'&plusmn;': '±',
'&plussim;': '⨦',
'&plustwo;': '⨧',
'&pm;': '±',
'&Poincareplane;': 'ℌ',
'&pointint;': '⨕',
'&popf;': '𝕡',
'&Popf;': 'ℙ',
'&pound;': '£',
'&pr;': '≺',
'&Pr;': '⪻',
'&prap;': '⪷',
'&prcue;': '≼',
'&pre;': '⪯',
'&prE;': '⪳',
'&prec;': '≺',
'&precapprox;': '⪷',
'&preccurlyeq;': '≼',
'&Precedes;': '≺',
'&PrecedesEqual;': '⪯',
'&PrecedesSlantEqual;': '≼',
'&PrecedesTilde;': '≾',
'&preceq;': '⪯',
'&precnapprox;': '⪹',
'&precneqq;': '⪵',
'&precnsim;': '⋨',
'&precsim;': '≾',
'&prime;': '′',
'&Prime;': '″',
'&primes;': 'ℙ',
'&prnap;': '⪹',
'&prnE;': '⪵',
'&prnsim;': '⋨',
'&prod;': '∏',
'&Product;': '∏',
'&profalar;': '⌮',
'&profline;': '⌒',
'&profsurf;': '⌓',
'&prop;': '∝',
'&Proportion;': '∷',
'&Proportional;': '∝',
'&propto;': '∝',
'&prsim;': '≾',
'&prurel;': '⊰',
'&pscr;': '𝓅',
'&Pscr;': '𝒫',
'&psi;': 'ψ',
'&Psi;': 'Ψ',
'&puncsp;': ' ',
'&qfr;': '𝔮',
'&Qfr;': '𝔔',
'&qint;': '⨌',
'&qopf;': '𝕢',
'&Qopf;': 'ℚ',
'&qprime;': '⁗',
'&qscr;': '𝓆',
'&Qscr;': '𝒬',
'&quaternions;': 'ℍ',
'&quatint;': '⨖',
'&quest;': '?',
'&questeq;': '≟',
'&quot;': '"',
'&rAarr;': '⇛',
'&race;': '∽',
'&racute;': 'ŕ',
'&Racute;': 'Ŕ',
'&radic;': '√',
'&raemptyv;': '⦳',
'&rang;': '⟩',
'&Rang;': '⟫',
'&rangd;': '⦒',
'&range;': '⦥',
'&rangle;': '⟩',
'&raquo;': '»',
'&rarr;': '→',
'&rArr;': '⇒',
'&Rarr;': '↠',
'&rarrap;': '⥵',
'&rarrb;': '⇥',
'&rarrbfs;': '⤠',
'&rarrc;': '⤳',
'&rarrfs;': '⤞',
'&rarrhk;': '↪',
'&rarrlp;': '↬',
'&rarrpl;': '⥅',
'&rarrsim;': '⥴',
'&rarrtl;': '↣',
'&Rarrtl;': '⤖',
'&rarrw;': '↝',
'&ratail;': '⤚',
'&rAtail;': '⤜',
'&ratio;': '∶',
'&rationals;': 'ℚ',
'&rbarr;': '⤍',
'&rBarr;': '⤏',
'&RBarr;': '⤐',
'&rbbrk;': '❳',
'&rbrace;': '}',
'&rbrack;': ']',
'&rbrke;': '⦌',
'&rbrksld;': '⦎',
'&rbrkslu;': '⦐',
'&rcaron;': 'ř',
'&Rcaron;': 'Ř',
'&rcedil;': 'ŗ',
'&Rcedil;': 'Ŗ',
'&rceil;': '⌉',
'&rcub;': '}',
'&rcy;': 'р',
'&Rcy;': 'Р',
'&rdca;': '⤷',
'&rdldhar;': '⥩',
'&rdquo;': '”',
'&rdquor;': '”',
'&rdsh;': '↳',
'&Re;': 'ℜ',
'&real;': 'ℜ',
'&realine;': 'ℛ',
'&realpart;': 'ℜ',
'&reals;': 'ℝ',
'&rect;': '▭',
'&reg;': '®',
'&ReverseElement;': '∋',
'&ReverseEquilibrium;': '⇋',
'&ReverseUpEquilibrium;': '⥯',
'&rfisht;': '⥽',
'&rfloor;': '⌋',
'&rfr;': '𝔯',
'&Rfr;': 'ℜ',
'&rHar;': '⥤',
'&rhard;': '⇁',
'&rharu;': '⇀',
'&rharul;': '⥬',
'&rho;': 'ρ',
'&rhov;': 'ϱ',
'&RightAngleBracket;': '⟩',
'&rightarrow;': '→',
'&Rightarrow;': '⇒',
'&RightArrow;': '→',
'&RightArrowBar;': '⇥',
'&RightArrowLeftArrow;': '⇄',
'&rightarrowtail;': '↣',
'&RightCeiling;': '⌉',
'&RightDoubleBracket;': '⟧',
'&RightDownTeeVector;': '⥝',
'&RightDownVector;': '⇂',
'&RightDownVectorBar;': '⥕',
'&RightFloor;': '⌋',
'&rightharpoondown;': '⇁',
'&rightharpoonup;': '⇀',
'&rightleftarrows;': '⇄',
'&rightleftharpoons;': '⇌',
'&rightrightarrows;': '⇉',
'&rightsquigarrow;': '↝',
'&RightTee;': '⊢',
'&RightTeeArrow;': '↦',
'&RightTeeVector;': '⥛',
'&rightthreetimes;': '⋌',
'&RightTriangle;': '⊳',
'&RightTriangleBar;': '⧐',
'&RightTriangleEqual;': '⊵',
'&RightUpDownVector;': '⥏',
'&RightUpTeeVector;': '⥜',
'&RightUpVector;': '↾',
'&RightUpVectorBar;': '⥔',
'&RightVector;': '⇀',
'&RightVectorBar;': '⥓',
'&ring;': '˚',
'&risingdotseq;': '≓',
'&rlarr;': '⇄',
'&rlhar;': '⇌',
'&rmoust;': '⎱',
'&rmoustache;': '⎱',
'&rnmid;': '⫮',
'&roang;': '⟭',
'&roarr;': '⇾',
'&robrk;': '⟧',
'&ropar;': '⦆',
'&ropf;': '𝕣',
'&Ropf;': 'ℝ',
'&roplus;': '⨮',
'&rotimes;': '⨵',
'&RoundImplies;': '⥰',
'&rpar;': ')',
'&rpargt;': '⦔',
'&rppolint;': '⨒',
'&rrarr;': '⇉',
'&Rrightarrow;': '⇛',
'&rscr;': '𝓇',
'&Rscr;': 'ℛ',
'&rsh;': '↱',
'&Rsh;': '↱',
'&rsqb;': ']',
'&rsquo;': '’',
'&rsquor;': '’',
'&rthree;': '⋌',
'&rtimes;': '⋊',
'&rtri;': '▹',
'&rtrie;': '⊵',
'&rtrif;': '▸',
'&rtriltri;': '⧎',
'&RuleDelayed;': '⧴',
'&ruluhar;': '⥨',
'&rx;': '℞',
'&sacute;': 'ś',
'&Sacute;': 'Ś',
'&sc;': '≻',
'&Sc;': '⪼',
'&scap;': '⪸',
'&scaron;': 'š',
'&Scaron;': 'Š',
'&sccue;': '≽',
'&sce;': '⪰',
'&scE;': '⪴',
'&scedil;': 'ş',
'&Scedil;': 'Ş',
'&scirc;': 'ŝ',
'&Scirc;': 'Ŝ',
'&scnap;': '⪺',
'&scnE;': '⪶',
'&scnsim;': '⋩',
'&scpolint;': '⨓',
'&scsim;': '≿',
'&scy;': 'с',
'&Scy;': 'С',
'&sdot;': '⋅',
'&sdotb;': '⊡',
'&sdote;': '⩦',
'&searhk;': '⤥',
'&searr;': '↘',
'&seArr;': '⇘',
'&searrow;': '↘',
'&sect;': '§',
'&semi;': ';',
'&seswar;': '⤩',
'&setminus;': '∖',
'&setmn;': '∖',
'&sext;': '✶',
'&sfr;': '𝔰',
'&Sfr;': '𝔖',
'&sharp;': '♯',
'&shchcy;': 'щ',
'&SHCHcy;': 'Щ',
'&shcy;': 'ш',
'&SHcy;': 'Ш',
'&ShortDownArrow;': '↓',
'&ShortLeftArrow;': '←',
'&shortmid;': '∣',
'&shortparallel;': '∥',
'&ShortRightArrow;': '→',
'&ShortUpArrow;': '↑',
'&shy;': '­',
'&sigma;': 'σ',
'&Sigma;': 'Σ',
'&sigmav;': 'ς',
'&sim;': '∼',
'&simdot;': '⩪',
'&sime;': '≃',
'&simeq;': '≃',
'&simg;': '⪞',
'&simgE;': '⪠',
'&siml;': '⪝',
'&simlE;': '⪟',
'&simne;': '≆',
'&simplus;': '⨤',
'&simrarr;': '⥲',
'&slarr;': '←',
'&SmallCircle;': '∘',
'&smallsetminus;': '∖',
'&smashp;': '⨳',
'&smeparsl;': '⧤',
'&smid;': '∣',
'&smile;': '⌣',
'&smt;': '⪪',
'&smte;': '⪬',
'&smtes;': '⪬',
'&softcy;': 'ь',
'&SOFTcy;': 'Ь',
'&sol;': '/',
'&solb;': '⧄',
'&solbar;': '⌿',
'&sopf;': '𝕤',
'&Sopf;': '𝕊',
'&spades;': '♠',
'&spadesuit;': '♠',
'&spar;': '∥',
'&sqcap;': '⊓',
'&sqcaps;': '⊓',
'&sqcup;': '⊔',
'&sqcups;': '⊔',
'&Sqrt;': '√',
'&sqsub;': '⊏',
'&sqsube;': '⊑',
'&sqsubset;': '⊏',
'&sqsubseteq;': '⊑',
'&sqsup;': '⊐',
'&sqsupe;': '⊒',
'&sqsupset;': '⊐',
'&sqsupseteq;': '⊒',
'&squ;': '□',
'&square;': '□',
'&Square;': '□',
'&SquareIntersection;': '⊓',
'&SquareSubset;': '⊏',
'&SquareSubsetEqual;': '⊑',
'&SquareSuperset;': '⊐',
'&SquareSupersetEqual;': '⊒',
'&SquareUnion;': '⊔',
'&squarf;': '▪',
'&squf;': '▪',
'&srarr;': '→',
'&sscr;': '𝓈',
'&Sscr;': '𝒮',
'&ssetmn;': '∖',
'&sstarf;': '⋆',
'&star;': '☆',
'&Star;': '⋆',
'&starf;': '★',
'&straightepsilon;': 'ϵ',
'&straightphi;': 'ϕ',
'&sub;': '⊂',
'&Sub;': '⋐',
'&subdot;': '⪽',
'&sube;': '⊆',
'&subE;': '⫅',
'&subedot;': '⫃',
'&submult;': '⫁',
'&subne;': '⊊',
'&subnE;': '⫋',
'&subplus;': '⪿',
'&subrarr;': '⥹',
'&subset;': '⊂',
'&Subset;': '⋐',
'&subseteq;': '⊆',
'&subseteqq;': '⫅',
'&SubsetEqual;': '⊆',
'&subsetneq;': '⊊',
'&subsetneqq;': '⫋',
'&subsim;': '⫇',
'&subsub;': '⫕',
'&subsup;': '⫓',
'&succ;': '≻',
'&succapprox;': '⪸',
'&succcurlyeq;': '≽',
'&Succeeds;': '≻',
'&SucceedsEqual;': '⪰',
'&SucceedsSlantEqual;': '≽',
'&SucceedsTilde;': '≿',
'&succeq;': '⪰',
'&succnapprox;': '⪺',
'&succneqq;': '⪶',
'&succnsim;': '⋩',
'&succsim;': '≿',
'&SuchThat;': '∋',
'&sum;': '∑',
'&Sum;': '∑',
'&sung;': '♪',
'&sup;': '⊃',
'&Sup;': '⋑',
'&sup1;': '¹',
'&sup2;': '²',
'&sup3;': '³',
'&supdot;': '⪾',
'&supdsub;': '⫘',
'&supe;': '⊇',
'&supE;': '⫆',
'&supedot;': '⫄',
'&Superset;': '⊃',
'&SupersetEqual;': '⊇',
'&suphsol;': '⟉',
'&suphsub;': '⫗',
'&suplarr;': '⥻',
'&supmult;': '⫂',
'&supne;': '⊋',
'&supnE;': '⫌',
'&supplus;': '⫀',
'&supset;': '⊃',
'&Supset;': '⋑',
'&supseteq;': '⊇',
'&supseteqq;': '⫆',
'&supsetneq;': '⊋',
'&supsetneqq;': '⫌',
'&supsim;': '⫈',
'&supsub;': '⫔',
'&supsup;': '⫖',
'&swarhk;': '⤦',
'&swarr;': '↙',
'&swArr;': '⇙',
'&swarrow;': '↙',
'&swnwar;': '⤪',
'&szlig;': 'ß',
'&Tab;': '	',
'&target;': '⌖',
'&tau;': 'τ',
'&tbrk;': '⎴',
'&tcaron;': 'ť',
'&Tcaron;': 'Ť',
'&tcedil;': 'ţ',
'&Tcedil;': 'Ţ',
'&tcy;': 'т',
'&Tcy;': 'Т',
'&tdot;': '⃛',
'&telrec;': '⌕',
'&tfr;': '𝔱',
'&Tfr;': '𝔗',
'&there4;': '∴',
'&therefore;': '∴',
'&Therefore;': '∴',
'&theta;': 'θ',
'&Theta;': 'Θ',
'&thetav;': 'ϑ',
'&thickapprox;': '≈',
'&thicksim;': '∼',
'&ThickSpace;': ' ',
'&thinsp;': ' ',
'&ThinSpace;': ' ',
'&thkap;': '≈',
'&thksim;': '∼',
'&thorn;': 'þ',
'&THORN;': 'Þ',
'&tilde;': '˜',
'&Tilde;': '∼',
'&TildeEqual;': '≃',
'&TildeFullEqual;': '≅',
'&TildeTilde;': '≈',
'&times;': '×',
'&timesb;': '⊠',
'&timesbar;': '⨱',
'&timesd;': '⨰',
'&tint;': '∭',
'&toea;': '⤨',
'&top;': '⊤',
'&topbot;': '⌶',
'&topcir;': '⫱',
'&topf;': '𝕥',
'&Topf;': '𝕋',
'&topfork;': '⫚',
'&tosa;': '⤩',
'&tprime;': '‴',
'&trade;': '™',
'&triangle;': '▵',
'&triangledown;': '▿',
'&triangleleft;': '◃',
'&trianglelefteq;': '⊴',
'&triangleq;': '≜',
'&triangleright;': '▹',
'&trianglerighteq;': '⊵',
'&tridot;': '◬',
'&trie;': '≜',
'&triminus;': '⨺',
'&TripleDot;': '⃛',
'&triplus;': '⨹',
'&trisb;': '⧍',
'&tritime;': '⨻',
'&tscr;': '𝓉',
'&Tscr;': '𝒯',
'&tscy;': 'ц',
'&TScy;': 'Ц',
'&tshcy;': 'ћ',
'&TSHcy;': 'Ћ',
'&tstrok;': 'ŧ',
'&Tstrok;': 'Ŧ',
'&twixt;': '≬',
'&twoheadleftarrow;': '↞',
'&twoheadrightarrow;': '↠',
'&uacute;': 'ú',
'&Uacute;': 'Ú',
'&uarr;': '↑',
'&uArr;': '⇑',
'&Uarr;': '↟',
'&Uarrocir;': '⥉',
'&ubrcy;': 'ў',
'&Ubrcy;': 'Ў',
'&ubreve;': 'ŭ',
'&Ubreve;': 'Ŭ',
'&ucirc;': 'û',
'&Ucirc;': 'Û',
'&ucy;': 'у',
'&Ucy;': 'У',
'&udarr;': '⇅',
'&udblac;': 'ű',
'&Udblac;': 'Ű',
'&udhar;': '⥮',
'&ufisht;': '⥾',
'&ufr;': '𝔲',
'&Ufr;': '𝔘',
'&ugrave;': 'ù',
'&Ugrave;': 'Ù',
'&uHar;': '⥣',
'&uharl;': '↿',
'&uharr;': '↾',
'&uhblk;': '▀',
'&ulcorn;': '⌜',
'&ulcorner;': '⌜',
'&ulcrop;': '⌏',
'&ultri;': '◸',
'&umacr;': 'ū',
'&Umacr;': 'Ū',
'&uml;': '¨',
'&UnderBar;': '_',
'&UnderBrace;': '⏟',
'&UnderBracket;': '⎵',
'&UnderParenthesis;': '⏝',
'&Union;': '⋃',
'&UnionPlus;': '⊎',
'&uogon;': 'ų',
'&Uogon;': 'Ų',
'&uopf;': '𝕦',
'&Uopf;': '𝕌',
'&uparrow;': '↑',
'&Uparrow;': '⇑',
'&UpArrow;': '↑',
'&UpArrowBar;': '⤒',
'&UpArrowDownArrow;': '⇅',
'&updownarrow;': '↕',
'&Updownarrow;': '⇕',
'&UpDownArrow;': '↕',
'&UpEquilibrium;': '⥮',
'&upharpoonleft;': '↿',
'&upharpoonright;': '↾',
'&uplus;': '⊎',
'&UpperLeftArrow;': '↖',
'&UpperRightArrow;': '↗',
'&upsi;': 'υ',
'&Upsi;': 'ϒ',
'&upsilon;': 'υ',
'&Upsilon;': 'Υ',
'&UpTee;': '⊥',
'&UpTeeArrow;': '↥',
'&upuparrows;': '⇈',
'&urcorn;': '⌝',
'&urcorner;': '⌝',
'&urcrop;': '⌎',
'&uring;': 'ů',
'&Uring;': 'Ů',
'&urtri;': '◹',
'&uscr;': '𝓊',
'&Uscr;': '𝒰',
'&utdot;': '⋰',
'&utilde;': 'ũ',
'&Utilde;': 'Ũ',
'&utri;': '▵',
'&utrif;': '▴',
'&uuarr;': '⇈',
'&uuml;': 'ü',
'&Uuml;': 'Ü',
'&uwangle;': '⦧',
'&vangrt;': '⦜',
'&varepsilon;': 'ϵ',
'&varkappa;': 'ϰ',
'&varnothing;': '∅',
'&varphi;': 'ϕ',
'&varpi;': 'ϖ',
'&varpropto;': '∝',
'&varr;': '↕',
'&vArr;': '⇕',
'&varrho;': 'ϱ',
'&varsigma;': 'ς',
'&varsubsetneq;': '⊊',
'&varsubsetneqq;': '⫋',
'&varsupsetneq;': '⊋',
'&varsupsetneqq;': '⫌',
'&vartheta;': 'ϑ',
'&vartriangleleft;': '⊲',
'&vartriangleright;': '⊳',
'&vBar;': '⫨',
'&Vbar;': '⫫',
'&vBarv;': '⫩',
'&vcy;': 'в',
'&Vcy;': 'В',
'&vdash;': '⊢',
'&vDash;': '⊨',
'&Vdash;': '⊩',
'&VDash;': '⊫',
'&Vdashl;': '⫦',
'&vee;': '∨',
'&Vee;': '⋁',
'&veebar;': '⊻',
'&veeeq;': '≚',
'&vellip;': '⋮',
'&verbar;': '|',
'&Verbar;': '‖',
'&vert;': '|',
'&Vert;': '‖',
'&VerticalBar;': '∣',
'&VerticalLine;': '|',
'&VerticalSeparator;': '❘',
'&VerticalTilde;': '≀',
'&VeryThinSpace;': ' ',
'&vfr;': '𝔳',
'&Vfr;': '𝔙',
'&vltri;': '⊲',
'&vnsub;': '⊂',
'&vnsup;': '⊃',
'&vopf;': '𝕧',
'&Vopf;': '𝕍',
'&vprop;': '∝',
'&vrtri;': '⊳',
'&vscr;': '𝓋',
'&Vscr;': '𝒱',
'&vsubne;': '⊊',
'&vsubnE;': '⫋',
'&vsupne;': '⊋',
'&vsupnE;': '⫌',
'&Vvdash;': '⊪',
'&vzigzag;': '⦚',
'&wcirc;': 'ŵ',
'&Wcirc;': 'Ŵ',
'&wedbar;': '⩟',
'&wedge;': '∧',
'&Wedge;': '⋀',
'&wedgeq;': '≙',
'&weierp;': '℘',
'&wfr;': '𝔴',
'&Wfr;': '𝔚',
'&wopf;': '𝕨',
'&Wopf;': '𝕎',
'&wp;': '℘',
'&wr;': '≀',
'&wreath;': '≀',
'&wscr;': '𝓌',
'&Wscr;': '𝒲',
'&xcap;': '⋂',
'&xcirc;': '◯',
'&xcup;': '⋃',
'&xdtri;': '▽',
'&xfr;': '𝔵',
'&Xfr;': '𝔛',
'&xharr;': '⟷',
'&xhArr;': '⟺',
'&xi;': 'ξ',
'&Xi;': 'Ξ',
'&xlarr;': '⟵',
'&xlArr;': '⟸',
'&xmap;': '⟼',
'&xnis;': '⋻',
'&xodot;': '⨀',
'&xopf;': '𝕩',
'&Xopf;': '𝕏',
'&xoplus;': '⨁',
'&xotime;': '⨂',
'&xrarr;': '⟶',
'&xrArr;': '⟹',
'&xscr;': '𝓍',
'&Xscr;': '𝒳',
'&xsqcup;': '⨆',
'&xuplus;': '⨄',
'&xutri;': '△',
'&xvee;': '⋁',
'&xwedge;': '⋀',
'&yacute;': 'ý',
'&Yacute;': 'Ý',
'&yacy;': 'я',
'&YAcy;': 'Я',
'&ycirc;': 'ŷ',
'&Ycirc;': 'Ŷ',
'&ycy;': 'ы',
'&Ycy;': 'Ы',
'&yen;': '¥',
'&yfr;': '𝔶',
'&Yfr;': '𝔜',
'&yicy;': 'ї',
'&YIcy;': 'Ї',
'&yopf;': '𝕪',
'&Yopf;': '𝕐',
'&yscr;': '𝓎',
'&Yscr;': '𝒴',
'&yucy;': 'ю',
'&YUcy;': 'Ю',
'&yuml;': 'ÿ',
'&Yuml;': 'Ÿ',
'&zacute;': 'ź',
'&Zacute;': 'Ź',
'&zcaron;': 'ž',
'&Zcaron;': 'Ž',
'&zcy;': 'з',
'&Zcy;': 'З',
'&zdot;': 'ż',
'&Zdot;': 'Ż',
'&zeetrf;': 'ℨ',
'&ZeroWidthSpace;': '​',
'&zeta;': 'ζ',
'&zfr;': '𝔷',
'&Zfr;': 'ℨ',
'&zhcy;': 'ж',
'&ZHcy;': 'Ж',
'&zigrarr;': '⇝',
'&zopf;': '𝕫',
'&Zopf;': 'ℤ',
'&zscr;': '𝓏',
'&Zscr;': '𝒵',
}
