/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeAclsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<DescribeAclsResource> resources;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_1), "Each Resource that is referenced in an ACL."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DescribeAclsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeAclsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.resources = new ArrayList<DescribeAclsResource>(0);
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribeAclsResource> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeAclsResource(_readable, _version));
            }
            this.resources = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DescribeAclsResource>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeAclsResource(_readable, _version));
            }
            this.resources = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.resources.size() + 1);
            _stringBytes = this.resources.iterator();
            while (_stringBytes.hasNext()) {
                DescribeAclsResource resourcesElement = (DescribeAclsResource)_stringBytes.next();
                resourcesElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.resources.size());
            _stringBytes = this.resources.iterator();
            while (_stringBytes.hasNext()) {
                DescribeAclsResource resourcesElement = (DescribeAclsResource)_stringBytes.next();
                resourcesElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            if (_version >= 2) {
                _size.addBytes(1);
            } else {
                _size.addBytes(2);
            }
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resources.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DescribeAclsResource resourcesElement : this.resources) {
            resourcesElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsResponseData)) {
            return false;
        }
        DescribeAclsResponseData other = (DescribeAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        return hashCode;
    }

    @Override
    public DescribeAclsResponseData duplicate() {
        DescribeAclsResponseData _duplicate = new DescribeAclsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<DescribeAclsResource> newResources = new ArrayList<DescribeAclsResource>(this.resources.size());
        for (DescribeAclsResource _element : this.resources) {
            newResources.add(_element.duplicate());
        }
        _duplicate.resources = newResources;
        return _duplicate;
    }

    public String toString() {
        return "DescribeAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resources=" + MessageUtil.deepToString(this.resources.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DescribeAclsResource> resources() {
        return this.resources;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeAclsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeAclsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeAclsResponseData setResources(List<DescribeAclsResource> v) {
        this.resources = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new CompactArrayOf(DescribeAclsResource.SCHEMA_2), "Each Resource that is referenced in an ACL."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DescribeAclsResource
    implements Message {
        byte resourceType;
        String resourceName;
        byte patternType;
        List<AclDescription> acls;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_1), "The ACLs."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribeAclsResource(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeAclsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.patternType = (byte)3;
            this.acls = new ArrayList<AclDescription>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int i;
            ArrayList<AclDescription> newCollection;
            int arrayLength;
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeAclsResource");
            }
            this.resourceType = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            this.patternType = _readable.readByte();
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field acls was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AclDescription(_readable, _version));
                }
                this.acls = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field acls was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<AclDescription>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AclDescription(_readable, _version));
                }
                this.acls = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            Object _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeByte(this.patternType);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.acls.size() + 1);
                _stringBytes = this.acls.iterator();
                while (_stringBytes.hasNext()) {
                    AclDescription aclsElement = (AclDescription)_stringBytes.next();
                    aclsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.acls.size());
                _stringBytes = this.acls.iterator();
                while (_stringBytes.hasNext()) {
                    AclDescription aclsElement = (AclDescription)_stringBytes.next();
                    aclsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeAclsResource");
            }
            _size.addBytes(1);
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(1);
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acls.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (AclDescription aclsElement : this.acls) {
                aclsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeAclsResource)) {
                return false;
            }
            DescribeAclsResource other = (DescribeAclsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            if (this.acls == null ? other.acls != null : !this.acls.equals(other.acls)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.acls == null ? 0 : this.acls.hashCode());
            return hashCode;
        }

        @Override
        public DescribeAclsResource duplicate() {
            DescribeAclsResource _duplicate = new DescribeAclsResource();
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            _duplicate.patternType = this.patternType;
            ArrayList<AclDescription> newAcls = new ArrayList<AclDescription>(this.acls.size());
            for (AclDescription _element : this.acls) {
                newAcls.add(_element.duplicate());
            }
            _duplicate.acls = newAcls;
            return _duplicate;
        }

        public String toString() {
            return "DescribeAclsResource(resourceType=" + this.resourceType + ", resourceName=" + (String)(this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", acls=" + MessageUtil.deepToString(this.acls.iterator()) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte patternType() {
            return this.patternType;
        }

        public List<AclDescription> acls() {
            return this.acls;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeAclsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeAclsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeAclsResource setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DescribeAclsResource setAcls(List<AclDescription> v) {
            this.acls = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.COMPACT_STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new CompactArrayOf(AclDescription.SCHEMA_2), "The ACLs."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class AclDescription
    implements Message {
        String principal;
        String host;
        byte operation;
        byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AclDescription(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AclDescription() {
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclDescription");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.principal);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AclDescription");
            }
            byte[] _stringBytes = this.principal.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(1);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AclDescription)) {
                return false;
            }
            AclDescription other = (AclDescription)obj;
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            if (this.permissionType != other.permissionType) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        @Override
        public AclDescription duplicate() {
            AclDescription _duplicate = new AclDescription();
            _duplicate.principal = this.principal;
            _duplicate.host = this.host;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            return _duplicate;
        }

        public String toString() {
            return "AclDescription(principal=" + (String)(this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AclDescription setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public AclDescription setHost(String v) {
            this.host = v;
            return this;
        }

        public AclDescription setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public AclDescription setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("principal", Type.COMPACT_STRING, "The ACL principal."), new Field("host", Type.COMPACT_STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

