/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.common;

import java.util.Iterator;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] array;
    private int position = 0;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.array.length;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.array[this.position++];
    }

    public static class ByteArrayIterator
    implements Iterator<Byte> {
        private final byte[] array;
        private int index = 0;

        public ByteArrayIterator(byte[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public Byte next() {
            if (!this.hasNext()) {
                return null;
            }
            return this.array[this.index++];
        }
    }

    public static class IntArrayIterator
    implements Iterator<Integer> {
        private final int[] array;
        private int index = 0;

        public IntArrayIterator(int[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                return null;
            }
            return this.array[this.index++];
        }
    }
}

