/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum EntityProfileName implements Name
{
    INIT_PROGRESS("init_progress"),
    ENTITY_INFO("entity_info"),
    STATE("state"),
    MODELS("models");

    private String name;

    private EntityProfileName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static EntityProfileName getName(String name) {
        switch (name) {
            case "init_progress": {
                return INIT_PROGRESS;
            }
            case "entity_info": {
                return ENTITY_INFO;
            }
            case "state": {
                return STATE;
            }
            case "models": {
                return MODELS;
            }
        }
        throw new IllegalArgumentException("Unsupported profile types");
    }

    public static Set<EntityProfileName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, EntityProfileName::getName);
    }
}

