/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.util.ParseUtils;

public class ForecastTask
extends TimeSeriesTask {
    public static final String FORECASTER_ID_FIELD = "forecaster_id";
    public static final String FORECASTER_FIELD = "forecaster";
    public static final String DATE_RANGE_FIELD = "date_range";
    private Forecaster forecaster = null;
    private DateRange dateRange = null;

    private ForecastTask() {
    }

    public ForecastTask(StreamInput input) throws IOException {
        this.taskId = input.readOptionalString();
        this.taskType = input.readOptionalString();
        this.configId = input.readOptionalString();
        this.forecaster = input.readBoolean() ? new Forecaster(input) : null;
        this.state = input.readOptionalString();
        this.taskProgress = input.readOptionalFloat();
        this.initProgress = input.readOptionalFloat();
        this.currentPiece = input.readOptionalInstant();
        this.executionStartTime = input.readOptionalInstant();
        this.executionEndTime = input.readOptionalInstant();
        this.isLatest = input.readOptionalBoolean();
        this.error = input.readOptionalString();
        this.checkpointId = input.readOptionalString();
        this.lastUpdateTime = input.readOptionalInstant();
        this.startedBy = input.readOptionalString();
        this.stoppedBy = input.readOptionalString();
        this.coordinatingNode = input.readOptionalString();
        this.workerNode = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        this.dateRange = input.readBoolean() ? new DateRange(input) : null;
        this.entity = input.readBoolean() ? new Entity(input) : null;
        this.parentTaskId = input.readOptionalString();
        this.estimatedMinutesLeft = input.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.taskType);
        out.writeOptionalString(this.configId);
        if (this.forecaster != null) {
            out.writeBoolean(true);
            this.forecaster.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.state);
        out.writeOptionalFloat(this.taskProgress);
        out.writeOptionalFloat(this.initProgress);
        out.writeOptionalInstant(this.currentPiece);
        out.writeOptionalInstant(this.executionStartTime);
        out.writeOptionalInstant(this.executionEndTime);
        out.writeOptionalBoolean(this.isLatest);
        out.writeOptionalString(this.error);
        out.writeOptionalString(this.checkpointId);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.startedBy);
        out.writeOptionalString(this.stoppedBy);
        out.writeOptionalString(this.coordinatingNode);
        out.writeOptionalString(this.workerNode);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.dateRange != null) {
            out.writeBoolean(true);
            this.dateRange.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.entity != null) {
            out.writeBoolean(true);
            this.entity.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.parentTaskId);
        out.writeOptionalInt(this.estimatedMinutesLeft);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isHistoricalEntityTask() {
        return false;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder = super.toXContent(xContentBuilder, params);
        if (this.configId != null) {
            xContentBuilder.field(FORECASTER_ID_FIELD, this.configId);
        }
        if (this.forecaster != null) {
            xContentBuilder.field(FORECASTER_FIELD, (ToXContent)this.forecaster);
        }
        if (this.dateRange != null) {
            xContentBuilder.field(DATE_RANGE_FIELD, (ToXContent)this.dateRange);
        }
        return xContentBuilder.endObject();
    }

    public static ForecastTask parse(XContentParser parser) throws IOException {
        return ForecastTask.parse(parser, null);
    }

    public static ForecastTask parse(XContentParser parser, String taskId) throws IOException {
        Instant lastUpdateTime = null;
        String startedBy = null;
        String stoppedBy = null;
        String error = null;
        String state = null;
        String configId = null;
        Float taskProgress = null;
        Float initProgress = null;
        Instant currentPiece = null;
        Instant executionStartTime = null;
        Instant executionEndTime = null;
        Boolean isLatest = null;
        String taskType = null;
        String checkpointId = null;
        Config forecaster = null;
        String parsedTaskId = taskId;
        String coordinatingNode = null;
        String workerNode = null;
        DateRange dateRange = null;
        Entity entity = null;
        String parentTaskId = null;
        Integer estimatedMinutesLeft = null;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block50: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "started_by": {
                    startedBy = parser.text();
                    continue block50;
                }
                case "stopped_by": {
                    stoppedBy = parser.text();
                    continue block50;
                }
                case "error": {
                    error = parser.text();
                    continue block50;
                }
                case "state": {
                    state = parser.text();
                    continue block50;
                }
                case "forecaster_id": {
                    configId = parser.text();
                    continue block50;
                }
                case "task_progress": {
                    taskProgress = Float.valueOf(parser.floatValue());
                    continue block50;
                }
                case "init_progress": {
                    initProgress = Float.valueOf(parser.floatValue());
                    continue block50;
                }
                case "current_piece": {
                    currentPiece = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "execution_start_time": {
                    executionStartTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "execution_end_time": {
                    executionEndTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "is_latest": {
                    isLatest = parser.booleanValue();
                    continue block50;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block50;
                }
                case "checkpoint_id": {
                    checkpointId = parser.text();
                    continue block50;
                }
                case "forecaster": {
                    forecaster = Forecaster.parse(parser);
                    continue block50;
                }
                case "task_id": {
                    parsedTaskId = parser.text();
                    continue block50;
                }
                case "coordinating_node": {
                    coordinatingNode = parser.text();
                    continue block50;
                }
                case "worker_node": {
                    workerNode = parser.text();
                    continue block50;
                }
                case "date_range": {
                    dateRange = DateRange.parse(parser);
                    continue block50;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block50;
                }
                case "parent_task_id": {
                    parentTaskId = parser.text();
                    continue block50;
                }
                case "estimated_minutes_left": {
                    estimatedMinutesLeft = parser.intValue();
                    continue block50;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block50;
                }
            }
            parser.skipChildren();
        }
        Forecaster copyForecaster = forecaster == null ? null : new Forecaster(configId, forecaster.getVersion(), forecaster.getName(), forecaster.getDescription(), forecaster.getTimeField(), forecaster.getIndices(), forecaster.getFeatureAttributes(), forecaster.getFilterQuery(), forecaster.getInterval(), forecaster.getWindowDelay(), forecaster.getShingleSize(), forecaster.getUiMetadata(), forecaster.getSchemaVersion(), forecaster.getLastUpdateTime(), forecaster.getCategoryFields(), forecaster.getUser(), forecaster.getCustomResultIndexOrAlias(), ((Forecaster)forecaster).getHorizon(), forecaster.getImputationOption(), forecaster.getRecencyEmphasis(), forecaster.getSeasonIntervals(), forecaster.getHistoryIntervals(), forecaster.getCustomResultIndexMinSize(), forecaster.getCustomResultIndexMinAge(), forecaster.getCustomResultIndexTTL(), (Boolean)forecaster.getFlattenResultIndexMapping(), forecaster.getLastBreakingUIChangeTime(), forecaster.getFrequency());
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().taskId(parsedTaskId)).lastUpdateTime(lastUpdateTime)).startedBy(startedBy)).stoppedBy(stoppedBy)).error(error)).state(state)).configId(configId)).taskProgress(taskProgress)).initProgress(initProgress)).currentPiece(currentPiece)).executionStartTime(executionStartTime)).executionEndTime(executionEndTime)).isLatest(isLatest)).taskType(taskType)).checkpointId(checkpointId)).coordinatingNode(coordinatingNode)).workerNode(workerNode)).forecaster(copyForecaster).dateRange(dateRange).entity(entity)).parentTaskId(parentTaskId)).estimatedMinutesLeft(estimatedMinutesLeft)).user(user)).build();
    }

    @Override
    @Generated
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ForecastTask that = (ForecastTask)other;
        return super.equals(that) && Objects.equal((Object)this.getForecaster(), (Object)that.getForecaster()) && Objects.equal((Object)this.getDateRange(), (Object)that.getDateRange());
    }

    @Override
    @Generated
    public int hashCode() {
        int superHashCode = super.hashCode();
        int hash = Objects.hashCode((Object[])new Object[]{this.configId, this.forecaster, this.dateRange});
        return hash += 89 * superHashCode;
    }

    public Forecaster getForecaster() {
        return this.forecaster;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public static class Builder
    extends TimeSeriesTask.Builder<Builder> {
        private Forecaster forecaster = null;
        private DateRange dateRange = null;

        public Builder forecaster(Forecaster forecaster) {
            this.forecaster = forecaster;
            return this;
        }

        public Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public ForecastTask build() {
            ForecastTask forecastTask = new ForecastTask();
            forecastTask.taskId = this.taskId;
            forecastTask.lastUpdateTime = this.lastUpdateTime;
            forecastTask.error = this.error;
            forecastTask.state = this.state;
            forecastTask.configId = this.configId;
            forecastTask.taskProgress = this.taskProgress;
            forecastTask.initProgress = this.initProgress;
            forecastTask.currentPiece = this.currentPiece;
            forecastTask.executionStartTime = this.executionStartTime;
            forecastTask.executionEndTime = this.executionEndTime;
            forecastTask.isLatest = this.isLatest;
            forecastTask.taskType = this.taskType;
            forecastTask.checkpointId = this.checkpointId;
            forecastTask.forecaster = this.forecaster;
            forecastTask.startedBy = this.startedBy;
            forecastTask.stoppedBy = this.stoppedBy;
            forecastTask.coordinatingNode = this.coordinatingNode;
            forecastTask.workerNode = this.workerNode;
            forecastTask.dateRange = this.dateRange;
            forecastTask.entity = this.entity;
            forecastTask.parentTaskId = this.parentTaskId;
            forecastTask.estimatedMinutesLeft = this.estimatedMinutesLeft;
            forecastTask.user = this.user;
            return forecastTask;
        }
    }
}

