/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.output;

import io.lettuce.core.dynamic.output.CommandOutputFactory;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.output.CommandOutputResolverSupport;
import io.lettuce.core.dynamic.output.OutputRegistry;
import io.lettuce.core.dynamic.output.OutputSelector;
import io.lettuce.core.dynamic.output.OutputType;
import io.lettuce.core.dynamic.support.ClassTypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OutputRegistryCommandOutputFactoryResolver
extends CommandOutputResolverSupport
implements CommandOutputFactoryResolver {
    private static final ClassTypeInformation<CommandOutput> COMMAND_OUTPUT = ClassTypeInformation.from(CommandOutput.class);
    private final OutputRegistry outputRegistry;

    public OutputRegistryCommandOutputFactoryResolver(OutputRegistry outputRegistry) {
        LettuceAssert.notNull((Object)outputRegistry, "OutputRegistry must not be null");
        this.outputRegistry = outputRegistry;
    }

    @Override
    public CommandOutputFactory resolveCommandOutput(OutputSelector outputSelector) {
        Map<OutputType, CommandOutputFactory> registry = this.outputRegistry.getRegistry();
        List<OutputType> outputTypes = registry.keySet().stream().filter(outputType -> !outputType.isStreaming()).collect(Collectors.toList());
        List<OutputType> candidates = this.getCandidates(outputTypes, outputSelector);
        if (candidates.isEmpty()) {
            return null;
        }
        return registry.get(candidates.get(0));
    }

    @Override
    public CommandOutputFactory resolveStreamingCommandOutput(OutputSelector outputSelector) {
        Map<OutputType, CommandOutputFactory> registry = this.outputRegistry.getRegistry();
        List<OutputType> outputTypes = registry.keySet().stream().filter(OutputType::isStreaming).collect(Collectors.toList());
        List<OutputType> candidates = this.getCandidates(outputTypes, outputSelector);
        if (candidates.isEmpty()) {
            return null;
        }
        return registry.get(candidates.get(0));
    }

    private List<OutputType> getCandidates(Collection<OutputType> outputTypes, OutputSelector outputSelector) {
        return outputTypes.stream().filter(outputType -> {
            if (COMMAND_OUTPUT.getType().isAssignableFrom(outputSelector.getOutputType().getRawClass()) && outputSelector.getOutputType().getRawClass().isAssignableFrom(outputType.getCommandOutputClass())) {
                return true;
            }
            return this.isAssignableFrom(outputSelector, (OutputType)outputType);
        }).collect(Collectors.toList());
    }
}

