/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.view.fantasia.basic.FantasiaTabButton;
import org.jsampler.view.fantasia.basic.FantasiaTabPanel;

public class FantasiaTabbedPane
extends JPanel
implements ItemListener {
    private final FantasiaTabPanel mainPane = new FantasiaTabPanel();
    private final Vector<FantasiaTabButton> buttons = new Vector();
    private final Vector<Component> panes = new Vector();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final Vector<ChangeListener> listeners = new Vector();

    public FantasiaTabbedPane() {
        this.setOpaque(false);
        this.mainPane.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public JPanel getMainPane() {
        return this.mainPane;
    }

    public void addTab(String string, Component component) {
        FantasiaTabButton fantasiaTabButton = new FantasiaTabButton(this, string);
        int n = this.buttons.size();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(fantasiaTabButton, gridBagConstraints);
        this.add(fantasiaTabButton);
        this.remove(this.mainPane);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = n + 1;
        gridBagLayout.setConstraints(this.mainPane, gridBagConstraints);
        this.add(this.mainPane);
        fantasiaTabButton.setIndex(n);
        this.buttonGroup.add(fantasiaTabButton);
        this.buttons.add(fantasiaTabButton);
        fantasiaTabButton.addItemListener(this);
        this.panes.add(component);
        if (n == 0) {
            fantasiaTabButton.doClick(0);
        }
    }

    public int getTabCount() {
        return this.buttons.size();
    }

    public FantasiaTabButton getTabButton(int n) {
        return this.buttons.get(n);
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        if (this.buttons.get(n).isSelected()) {
            return;
        }
        this.buttons.get(n).doClick(0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.buttons.indexOf(itemEvent.getItem());
        if (n == -1) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            this.mainPane.add(this.panes.get(n));
            this.fireChangeEvent();
        } else {
            this.mainPane.remove(this.panes.get(n));
        }
        this.mainPane.revalidate();
        this.mainPane.repaint();
    }

    @Override
    public void removeAll() {
        for (FantasiaTabButton fantasiaTabButton : this.buttons) {
            this.buttonGroup.remove(fantasiaTabButton);
            fantasiaTabButton.removeItemListener(this);
        }
        this.buttons.removeAllElements();
        this.panes.removeAllElements();
        super.removeAll();
    }
}

