/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter performs a pixelwise combination of an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).


The labelings in the images are weighted relative to each other based
on their "performance" as estimated by an expectation-maximization
algorithm. In the process, a ground truth segmentation is estimated,
and the estimated performances of the individual segmentations are
relative to this estimated ground truth.

The algorithm is based on the binary STAPLE algorithm by Warfield et
al. as published originally in

S. Warfield, K. Zou, W. Wells, "Validation of image segmentation and
expert quality with an expectation-maximization algorithm" in MICCAI
2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag,
Heidelberg, Germany, 2002, pp. 298-306

The multi-label algorithm implemented here is described in detail in

T. Rohlfing, D. B. Russakoff, and C. R. Maurer, Jr., "Performance-
based classifier combination in atlas-based image segmentation using
expectation-maximization parameter estimation," IEEE Transactions on
Medical Imaging, vol. 23, pp. 983-994, Aug. 2004.

INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.

The filter can optionally be provided with estimates for the a priori
class probabilities through the SetPriorProbabilities function. If no
estimate is provided, one is automatically generated by analyzing the
relative frequencies of the labels in the input images.

OUTPUTS
The filter produces a single output volume. Each output pixel contains
the label that has the highest probability of being the correct label,
based on the performance models of the individual segmentations. If
the maximum probability is not unique, i.e., if more than one label
have a maximum probability, then an "undecided" label is assigned to
that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.

In addition to the combined image, the estimated confusion matrices
for each of the input segmentations can be obtained through the
GetConfusionMatrix member function.

PARAMETERS
The label used for "undecided" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.
 A termination threshold for the EM iteration can be defined by
calling SetTerminationUpdateThreshold. The iteration terminates once
no single parameter of any confusion matrix changes by less than this
threshold. Alternatively, a maximum number of iterations can be
specified by calling SetMaximumNumberOfIterations. The algorithm may
still terminate after a smaller number of iterations if the
termination threshold criterion is satisfied.

EVENTS
This filter invokes IterationEvent() at each iteration of the E-M
algorithm. Setting the AbortGenerateData() flag will cause the
algorithm to halt after the current iteration and produce results just
as if it had converged. The algorithm makes no attempt to report its
progress since the number of iterations needed cannot be known in
advance.

Torsten Rohlfing, SRI International, Neuroscience Program

See:
 itk::simple::MultiLabelSTAPLE for the procedural interface


C++ includes: sitkMultiLabelSTAPLEImageFilter.h
*/
public class MultiLabelSTAPLEImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MultiLabelSTAPLEImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MultiLabelSTAPLEImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MultiLabelSTAPLEImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MultiLabelSTAPLEImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MultiLabelSTAPLEImageFilter::~MultiLabelSTAPLEImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MultiLabelSTAPLEImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MultiLabelSTAPLEImageFilter::MultiLabelSTAPLEImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MultiLabelSTAPLEImageFilter() {
    this(SimpleITKJNI.new_MultiLabelSTAPLEImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MultiLabelSTAPLEImageFilter::SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels)

Set label value for undecided pixels.

*/
public  void setLabelForUndecidedPixels(java.math.BigInteger LabelForUndecidedPixels) {
    SimpleITKJNI.MultiLabelSTAPLEImageFilter_setLabelForUndecidedPixels(swigCPtr, this, LabelForUndecidedPixels);
  }

  /**
uint64_t itk::simple::MultiLabelSTAPLEImageFilter::GetLabelForUndecidedPixels() const

     Get label value used for undecided pixels.

After updating the filter, this function returns the actual label
value used for undecided pixels in the current output. Note that this
value is overwritten when SetLabelForUndecidedPixels is called and the
new value only becomes effective upon the next filter update.

*/
public  java.math.BigInteger getLabelForUndecidedPixels() {
    return SimpleITKJNI.MultiLabelSTAPLEImageFilter_getLabelForUndecidedPixels(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MultiLabelSTAPLEImageFilter::SetTerminationUpdateThreshold(float TerminationUpdateThreshold)

Set termination threshold based on confusion matrix parameter updates.

*/
public  void setTerminationUpdateThreshold(float TerminationUpdateThreshold) {
    SimpleITKJNI.MultiLabelSTAPLEImageFilter_setTerminationUpdateThreshold(swigCPtr, this, TerminationUpdateThreshold);
  }

  /**
float itk::simple::MultiLabelSTAPLEImageFilter::GetTerminationUpdateThreshold() const

Set termination threshold based on confusion matrix parameter updates.

*/
public  float getTerminationUpdateThreshold() {
    return SimpleITKJNI.MultiLabelSTAPLEImageFilter_getTerminationUpdateThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MultiLabelSTAPLEImageFilter::SetMaximumNumberOfIterations(unsigned int MaximumNumberOfIterations)

Set maximum number of iterations.

*/
public  void setMaximumNumberOfIterations(long MaximumNumberOfIterations) {
    SimpleITKJNI.MultiLabelSTAPLEImageFilter_setMaximumNumberOfIterations(swigCPtr, this, MaximumNumberOfIterations);
  }

  /**
unsigned int itk::simple::MultiLabelSTAPLEImageFilter::GetMaximumNumberOfIterations() const

Set maximum number of iterations.

*/
public  long getMaximumNumberOfIterations() {
    return SimpleITKJNI.MultiLabelSTAPLEImageFilter_getMaximumNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MultiLabelSTAPLEImageFilter::SetPriorProbabilities(std::vector&lt; float &gt; PriorProbabilities)

     Set manual estimates for the a priori class probabilities. The
size of the array must be greater than the value of the largest label. The index into the array corresponds to the label
value in the segmented image for the class.

*/
public  void setPriorProbabilities(VectorFloat PriorProbabilities) {
    SimpleITKJNI.MultiLabelSTAPLEImageFilter_setPriorProbabilities(swigCPtr, this, VectorFloat.getCPtr(PriorProbabilities), PriorProbabilities);
  }

  /**
std::vector&lt;float&gt; itk::simple::MultiLabelSTAPLEImageFilter::GetPriorProbabilities() const

     Get prior class probabilities.

After updating the filter, this function returns the actual prior
class probabilities. If these were not previously set by a call to
SetPriorProbabilities, then they are estimated from the input
segmentations and the result is available through this function.

*/
public  VectorFloat getPriorProbabilities() {
    return new VectorFloat(SimpleITKJNI.MultiLabelSTAPLEImageFilter_getPriorProbabilities(swigCPtr, this), true);
  }

  /**
std::vector&lt;float&gt; itk::simple::MultiLabelSTAPLEImageFilter::GetConfusionMatrix(unsigned int input) const

Get confusion matrix for the i-th input segmentation.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorFloat getConfusionMatrix(long input) {
    return new VectorFloat(SimpleITKJNI.MultiLabelSTAPLEImageFilter_getConfusionMatrix(swigCPtr, this, input), true);
  }

  /**
std::string itk::simple::MultiLabelSTAPLEImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MultiLabelSTAPLEImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MultiLabelSTAPLEImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MultiLabelSTAPLEImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.MultiLabelSTAPLEImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
