/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.BaseLineFilter;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinTryFinallyLineFilter
extends BaseLineFilter {
    private final Set<Label> myTryBlockStartLabels = new HashSet<Label>();
    private State myState = State.INITIAL;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinUtils.isKotlinClass(context);
    }

    protected boolean shouldRemoveLine() {
        return this.myState == State.NOP;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        void var1_1;
        void var3_3;
        void var2_2;
        super.visitTryCatchBlock(start, (Label)var2_2, (Label)var3_3, type);
        this.myTryBlockStartLabels.add((Label)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        super.visitLabel(label);
        if (this.myTryBlockStartLabels.contains(var1_1)) {
            if (this.myState == State.INITIAL) {
                this.myState = State.TRY_START;
                return;
            }
            this.myState = State.INITIAL;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        this.mv.visitInsn(opcode);
        if (var1_1 == false && this.myState == State.TRY_START) {
            this.myState = State.NOP;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        if (this.myState != State.TRY_START) {
            this.myState = State.INITIAL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        TRY_START,
        NOP;

    }
}

