/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;

public class JavaFxBuiltInAttributeDescriptor
extends JavaFxPropertyAttributeDescriptor {
    private static final Logger LOG = Logger.getInstance(JavaFxBuiltInAttributeDescriptor.class);
    private final String myParentTagName;

    private JavaFxBuiltInAttributeDescriptor(String name, PsiClass psiClass) {
        super(name, psiClass);
        this.myParentTagName = null;
    }

    private JavaFxBuiltInAttributeDescriptor(String name, String parentTagName) {
        super(name, null);
        this.myParentTagName = parentTagName;
    }

    public static JavaFxBuiltInAttributeDescriptor create(String name, PsiClass psiClass) {
        if ("fx:id".equals(name)) {
            return new FxIdAttributeDescriptor(psiClass);
        }
        if ("fx:value".equals(name)) {
            return new FxValueAttributeDescriptor(psiClass);
        }
        if ("fx:constant".equals(name)) {
            return new FxConstantAttributeDescriptor(psiClass);
        }
        return new JavaFxBuiltInAttributeDescriptor(name, psiClass);
    }

    public static JavaFxBuiltInAttributeDescriptor create(String name, String parentTagName) {
        if ("fx:id".equals(name)) {
            return new FxIdAttributeDescriptor(parentTagName);
        }
        if ("fx:value".equals(name)) {
            return new FxValueAttributeDescriptor(parentTagName);
        }
        if ("fx:constant".equals(name)) {
            return new FxConstantAttributeDescriptor(parentTagName);
        }
        return new JavaFxBuiltInAttributeDescriptor(name, parentTagName);
    }

    @Override
    public boolean isEnumerated() {
        return false;
    }

    @Override
    public boolean isRequired() {
        if (this.myParentTagName == null) {
            return super.isRequired();
        }
        List<String> requiredAttrs = FxmlConstants.FX_BUILT_IN_TAG_REQUIRED_ATTRIBUTES.get(this.myParentTagName);
        return requiredAttrs != null && requiredAttrs.contains(this.getName());
    }

    @Override
    public String toString() {
        return this.myParentTagName != null ? this.myParentTagName + "#" + this.getName() : super.toString();
    }

    private static final class FxIdAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxIdAttributeDescriptor(PsiClass psiClass) {
            super("fx:id", psiClass);
        }

        private FxIdAttributeDescriptor(String parentTagName) {
            super("fx:id", parentTagName);
        }

        @Override
        public boolean hasIdType() {
            return true;
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            PsiField field;
            PsiClass tagClass;
            PsiClass controllerClass;
            if (xmlAttributeValue == null) {
                FxIdAttributeDescriptor.$$$reportNull$$$0(0);
            }
            if (value == null) {
                FxIdAttributeDescriptor.$$$reportNull$$$0(1);
            }
            if ((controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttributeValue.getContainingFile())) != null && (tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue)) != null && (field = controllerClass.findFieldByName(value, true)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)tagClass, (PsiClass)PsiUtil.resolveClassInType((PsiType)field.getType()), (boolean)true)) {
                return JavaFXBundle.message("cannot.class.name.to.field.name", tagClass.getQualifiedName(), field.getName());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlAttributeValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxIdAttributeDescriptor";
            objectArray[2] = "validateAttributeValue";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FxValueAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxValueAttributeDescriptor(PsiClass psiClass) {
            super("fx:value", psiClass);
        }

        private FxValueAttributeDescriptor(String parentTagName) {
            super("fx:value", parentTagName);
        }

        @Override
        public boolean isEnumerated() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass != null && psiClass.isEnum();
        }

        @Override
        protected PsiClass getEnum() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass.isEnum() ? psiClass : null;
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            PsiClass tagClass;
            if (xmlAttributeValue == null) {
                FxValueAttributeDescriptor.$$$reportNull$$$0(0);
            }
            if (value == null) {
                FxValueAttributeDescriptor.$$$reportNull$$$0(1);
            }
            if ((tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue)) != null) {
                if (tagClass.isEnum()) {
                    return JavaFxPsiUtil.validateEnumConstant(tagClass, value);
                }
                PsiMethod method = JavaFxPsiUtil.findValueOfMethod(tagClass);
                if (method == null) {
                    return JavaFXBundle.message("unable.to.coerce.error", value, tagClass.getQualifiedName());
                }
            }
            return FxValueAttributeDescriptor.validateLiteral(xmlAttributeValue, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlAttributeValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxValueAttributeDescriptor";
            objectArray[2] = "validateAttributeValue";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FxConstantAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxConstantAttributeDescriptor(PsiClass psiClass) {
            super("fx:constant", psiClass);
        }

        private FxConstantAttributeDescriptor(String parentTagName) {
            super("fx:constant", parentTagName);
        }

        @Override
        public boolean isEnumerated() {
            return this.getPsiClass() != null;
        }

        @Override
        protected PsiClass getEnum() {
            return this.getPsiClass();
        }

        @Override
        protected boolean isConstant(PsiField field) {
            return field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public");
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            PsiField constField;
            PsiClass tagClass;
            if (xmlAttributeValue == null) {
                FxConstantAttributeDescriptor.$$$reportNull$$$0(0);
            }
            if (value == null) {
                FxConstantAttributeDescriptor.$$$reportNull$$$0(1);
            }
            if (!((tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue)) == null || (constField = tagClass.findFieldByName(value, true)) != null && this.isConstant(constField))) {
                return JavaFXBundle.message("constant.not.found", value);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlAttributeValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxConstantAttributeDescriptor";
            objectArray[2] = "validateAttributeValue";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

