/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.GTaskManager;
import ghidra.framework.task.gui.GTaskResultPanel;
import ghidra.framework.task.gui.taskview.TaskViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class GTaskManagerPanel
extends JPanel {
    private GTaskManager taskManager;
    private TaskViewer taskViewer;
    private JSplitPane mainPanel;
    private GTaskResultPanel resultPanel;
    private float lastDividerLocation = 0.67f;

    public GTaskManagerPanel(GTaskManager taskMgr) {
        this.taskManager = taskMgr;
        this.setLayout(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 0, 5);
        this.taskViewer = new TaskViewer(taskMgr);
        this.resultPanel = new GTaskResultPanel(taskMgr);
        this.resultPanel.setBorder(BorderFactory.createTitledBorder(emptyBorder, "Task Results"));
        this.mainPanel = new JSplitPane();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        JComponent taskViewerComponent = this.taskViewer.getComponent();
        taskViewerComponent.setBorder(BorderFactory.createTitledBorder(emptyBorder, "Scheduled Tasks"));
        this.mainPanel.setLeftComponent(taskViewerComponent);
        this.mainPanel.setRightComponent(this.resultPanel);
        this.mainPanel.remove(this.resultPanel);
        this.mainPanel.setResizeWeight(0.55);
        this.add((Component)this.mainPanel, "Center");
        this.add(this.buildControlPanel(), "South");
    }

    public void setUseAnimations(boolean b) {
        this.taskViewer.setUseAnimations(b);
    }

    public void showResultPanel(boolean b) {
        if (b) {
            this.mainPanel.setRightComponent(this.resultPanel);
            this.mainPanel.setDividerLocation(this.lastDividerLocation);
            this.mainPanel.invalidate();
        } else {
            int dividerLocation = this.mainPanel.getDividerLocation();
            Dimension size = this.mainPanel.getSize();
            int width = Math.max(1, size.width);
            this.lastDividerLocation = (float)dividerLocation / (float)width;
            this.mainPanel.remove(this.resultPanel);
        }
        this.validate();
    }

    private Component buildControlPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton pauseButton = new JButton("Pause");
        JButton resumeButton = new JButton("Resume");
        JButton stepButton = new JButton("Step");
        JButton clearButton = new JButton("Clear All");
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTaskManagerPanel.this.pause();
            }
        });
        resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTaskManagerPanel.this.resume();
            }
        });
        stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTaskManagerPanel.this.step();
            }
        });
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTaskManagerPanel.this.clear();
            }
        });
        panel.add(pauseButton);
        panel.add(stepButton);
        panel.add(resumeButton);
        panel.add(clearButton);
        return panel;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension resultSize = this.resultPanel.getPreferredSize();
        return new Dimension(preferredSize.width + resultSize.width, preferredSize.height);
    }

    private void clear() {
        this.taskManager.cancelAll();
    }

    private void step() {
        this.taskManager.runNextTaskEvenWhenSuspended();
    }

    private void resume() {
        this.taskManager.setSuspended(false);
    }

    private void pause() {
        this.taskManager.setSuspended(true);
    }
}

