/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.widgets.indexedscrollpane.IndexedScrollPane;
import ghidra.app.util.viewer.format.FieldHeader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class ScrollpaneAlignedHorizontalLayout
implements LayoutManager {
    private final IndexedScrollPane scroller;

    public ScrollpaneAlignedHorizontalLayout(IndexedScrollPane scroller) {
        this.scroller = scroller;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Rectangle viewportBorderBounds = this.scroller.getViewportBorderBounds();
        int n = parent.getComponentCount();
        Insets insets = parent.getInsets();
        int height = viewportBorderBounds.height;
        int x = insets.left;
        int y = viewportBorderBounds.y + this.getFieldHeaderOffset();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            int width = c.getPreferredSize().width;
            if (i == n - 1) {
                width = Math.max(width, parent.getWidth() - insets.right - x);
            }
            c.setBounds(x, y, width, height);
            x += width;
        }
    }

    private int getFieldHeaderOffset() {
        Object comp = this.scroller;
        Container parent = this.scroller.getParent();
        while (parent != null) {
            if (parent instanceof FieldHeader) {
                Rectangle bounds = ((Component)comp).getBounds();
                return bounds.y;
            }
            comp = parent;
            parent = ((Component)comp).getParent();
        }
        return 0;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        int height = 0;
        int width = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            width += d.width;
            height = Math.max(height, d.height);
        }
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }
}

