/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.task;

import ghidra.app.plugin.core.progmgr.ProgramLocator;
import ghidra.app.util.task.OpenProgramRequest;
import ghidra.app.util.task.ProgramOpener;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.listing.Program;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OpenProgramTask
extends Task {
    private List<ProgramLocator> programsToOpen = new ArrayList<ProgramLocator>();
    private List<OpenProgramRequest> openedPrograms = new ArrayList<OpenProgramRequest>();
    private ProgramOpener programOpener;
    private final Object consumer;

    public OpenProgramTask(List<ProgramLocator> programLocatorList, Object consumer) {
        super("Open Program(s)", true, false, true);
        this.consumer = consumer;
        this.programOpener = new ProgramOpener(consumer);
        this.programsToOpen.addAll(programLocatorList);
    }

    public OpenProgramTask(ProgramLocator locator, Object consumer) {
        this(Arrays.asList(locator), consumer);
    }

    public OpenProgramTask(DomainFile domainFile, int version, Object consumer) {
        this(new ProgramLocator(domainFile, version), consumer);
    }

    public OpenProgramTask(DomainFile domainFile, Object consumer) {
        this(new ProgramLocator(domainFile), consumer);
    }

    public OpenProgramTask(URL ghidraURL, Object consumer) {
        this(new ProgramLocator(ghidraURL), consumer);
    }

    public void setOpenPromptText(String text) {
        this.programOpener.setPromptText(text);
    }

    public void setSilent() {
        this.programOpener.setSilent();
    }

    public void setNoCheckout() {
        this.programOpener.setNoCheckout();
    }

    public List<OpenProgramRequest> getOpenPrograms() {
        return Collections.unmodifiableList(this.openedPrograms);
    }

    public OpenProgramRequest getOpenProgram() {
        if (this.openedPrograms.isEmpty()) {
            return null;
        }
        return this.openedPrograms.get(0);
    }

    public void run(TaskMonitor monitor) {
        this.taskMonitor.initialize((long)this.programsToOpen.size());
        for (ProgramLocator locator : this.programsToOpen) {
            if (this.taskMonitor.isCancelled()) {
                return;
            }
            Program program = this.programOpener.openProgram(locator, monitor);
            if (program != null) {
                this.openedPrograms.add(new OpenProgramRequest(program, locator, this.consumer));
            }
            this.taskMonitor.incrementProgress(1L);
        }
    }
}

