/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ExportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class ExportDataDirectory
extends DataDirectory
implements StructConverter {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_EXPORT";
    public static final int IMAGE_SIZEOF_EXPORT_DIRECTORY = 40;
    private int characteristics;
    private int timeDateStamp;
    private short majorVersion;
    private short minorVersion;
    private int name;
    private int base;
    private int numberOfFunctions;
    private int numberOfNames;
    private int addressOfFunctions;
    private int addressOfNames;
    private int addressOfNameOrdinals;
    private int exportsStartRVA;
    private int exportsEndRVA;
    private ExportInfo[] exports;
    private String exportName;

    ExportDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.exports == null) {
            this.exports = new ExportInfo[0];
        }
    }

    public ExportInfo[] getExports() {
        return this.exports;
    }

    public int getAddressOfFunctions() {
        return this.addressOfFunctions;
    }

    public int getAddressOfNames() {
        return this.addressOfNames;
    }

    public int getAddressOfNameOrdinals() {
        return this.addressOfNameOrdinals;
    }

    public int getNumberOfFunctions() {
        return this.numberOfFunctions;
    }

    public int getNumberOfNames() {
        return this.numberOfNames;
    }

    public int getName() {
        return this.name;
    }

    public int getBase() {
        return this.base;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public String getExportName() {
        return this.exportName;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        Reference[] refs;
        Data data;
        Address address;
        int i;
        monitor.setMessage("[" + program.getName() + "]: exports...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        ReferenceManager referenceManager = program.getReferenceManager();
        PeUtils.createData(program, addr, this.toDataType(), log);
        int ptrToName = this.getName();
        if (ptrToName > 0) {
            Address strAddr = space.getAddress(this.va(ptrToName, isBinary));
            this.createTerminatedString(program, strAddr, false, log);
            this.setPlateComment(program, strAddr, "Export Library Name");
        }
        long funcAddr = this.va(this.getAddressOfFunctions(), isBinary);
        long nameAddr = this.va(this.getAddressOfNames(), isBinary);
        long ordinalAddr = this.va(this.getAddressOfNameOrdinals(), isBinary);
        for (i = 0; i < this.getNumberOfFunctions() && !monitor.isCancelled(); ++i) {
            address = space.getAddress(funcAddr);
            if (i == 0) {
                this.setPlateComment(program, address, "Export Function Pointers");
            }
            PeUtils.createData(program, address, IBO32, log);
            data = program.getListing().getDataAt(address);
            if (data == null || !(data.getValue() instanceof Address)) {
                Msg.warn((Object)this, (Object)("Invalid or missing function at " + String.valueOf(address)));
                break;
            }
            Address refAddr = (Address)data.getValue();
            data.addOperandReference(0, refAddr, RefType.DATA, SourceType.IMPORTED);
            for (Reference ref : refs = data.getOperandReferences(0)) {
                referenceManager.setPrimary(ref, false);
            }
            funcAddr += 4L;
        }
        for (i = 0; i < this.getNumberOfNames() && !monitor.isCancelled(); ++i) {
            address = space.getAddress(ordinalAddr);
            if (i == 0) {
                this.setPlateComment(program, address, "Export Ordinal Values");
            }
            PeUtils.createData(program, address, WORD, log);
            ordinalAddr += 2L;
        }
        for (i = 0; i < this.getNumberOfNames() && !monitor.isCancelled(); ++i) {
            address = space.getAddress(nameAddr);
            if (i == 0) {
                this.setPlateComment(program, address, "Export Name Pointers");
            }
            PeUtils.createData(program, address, IBO32, log);
            data = program.getListing().getDataAt(address);
            if (data == null || !(data.getDataType() instanceof IBO32DataType)) {
                Msg.warn((Object)this, (Object)("Invalid or missing data at " + String.valueOf(address)));
                break;
            }
            Address strAddr = (Address)data.getValue();
            data.addOperandReference(0, strAddr, RefType.DATA, SourceType.IMPORTED);
            for (Reference ref : refs = data.getOperandReferences(0)) {
                referenceManager.setPrimary(ref, false);
            }
            this.createTerminatedString(program, strAddr, true, log);
            nameAddr += 4L;
        }
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parse() throws IOException {
        long oldIndex = this.reader.getPointerIndex();
        try {
            int ptr = this.getPointer();
            if (ptr < 0) {
                boolean bl = false;
                return bl;
            }
            this.reader.setPointerIndex(ptr);
            this.characteristics = this.reader.readNextInt();
            this.timeDateStamp = this.reader.readNextInt();
            this.majorVersion = this.reader.readNextShort();
            this.minorVersion = this.reader.readNextShort();
            this.name = this.reader.readNextInt();
            ptr = this.ntHeader.rvaToPointer(this.name);
            this.base = this.reader.readNextInt();
            this.numberOfFunctions = this.reader.readNextInt();
            this.numberOfNames = this.reader.readNextInt();
            this.addressOfFunctions = this.reader.readNextInt();
            this.addressOfNames = this.reader.readNextInt();
            this.addressOfNameOrdinals = this.reader.readNextInt();
            this.exportsStartRVA = this.getVirtualAddress();
            this.exportsEndRVA = this.exportsStartRVA + this.getSize();
            this.exportName = ptr > 0 ? this.reader.readAsciiString(ptr) : "";
            int pointerToFunctions = this.ntHeader.rvaToPointer(this.addressOfFunctions);
            if (this.numberOfFunctions > 0 && pointerToFunctions < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(this.addressOfFunctions)));
                this.numberOfFunctions = 0;
            }
            if (this.numberOfFunctions > 65536) {
                Msg.error((Object)this, (Object)("Large number of functions " + Integer.toHexString(this.numberOfFunctions)));
                this.numberOfFunctions = 0;
            }
            int pointerToNames = this.ntHeader.rvaToPointer(this.addressOfNames);
            if (this.numberOfNames > 0 && pointerToNames < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(this.addressOfNames)));
                this.numberOfNames = 0;
            }
            int pointerToOrdinals = this.ntHeader.rvaToPointer(this.addressOfNameOrdinals);
            if (this.numberOfNames > 0 && pointerToOrdinals < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(this.addressOfNameOrdinals)));
                this.numberOfNames = 0;
            }
            if (this.numberOfNames > 65536) {
                Msg.error((Object)this, (Object)("Large number of names " + Integer.toHexString(this.numberOfNames)));
                this.numberOfNames = 0;
            }
            ArrayList<ExportInfo> exportList = new ArrayList<ExportInfo>();
            for (int i = 0; i < this.numberOfFunctions; ++i) {
                int jthNamePtr;
                int entryPointRVA = this.reader.readInt(pointerToFunctions);
                pointerToFunctions += 4;
                if (entryPointRVA == 0) continue;
                long addr = Integer.toUnsignedLong(entryPointRVA) + this.ntHeader.getOptionalHeader().getImageBase();
                if (!this.ntHeader.getOptionalHeader().is64bit()) {
                    addr &= 0xFFFFFFFFL;
                }
                String lname = "";
                for (int j = 0; j < this.numberOfNames; ++j) {
                    short jthOrdinalVal = this.reader.readShort(pointerToOrdinals + j * 2);
                    if (jthOrdinalVal != i) continue;
                    int jthNameRVA = this.reader.readInt(pointerToNames + j * 4);
                    jthNamePtr = this.ntHeader.rvaToPointer(jthNameRVA);
                    if (jthNamePtr < 0) {
                        Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(jthNameRVA)));
                        boolean bl = false;
                        return bl;
                    }
                    lname = this.reader.readAsciiString(jthNamePtr);
                    break;
                }
                String cmt = "0x" + Integer.toHexString(entryPointRVA) + "  " + Integer.toString(i + this.base) + "  " + lname;
                boolean forwarded = false;
                if (entryPointRVA >= this.exportsStartRVA && entryPointRVA < this.exportsEndRVA) {
                    int entryPointPtr = this.ntHeader.rvaToPointer(entryPointRVA);
                    if (entryPointPtr < 0) {
                        Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(entryPointRVA)));
                        jthNamePtr = 0;
                        return jthNamePtr != 0;
                    }
                    String forwarder = this.reader.readAsciiString(entryPointPtr);
                    cmt = cmt + "  ";
                    cmt = cmt + "(forwarder -> " + forwarder + ")";
                    forwarded = true;
                }
                exportList.add(new ExportInfo(addr, i + this.base, lname, cmt, forwarded));
            }
            this.exports = new ExportInfo[exportList.size()];
            exportList.toArray(this.exports);
        }
        finally {
            this.reader.setPointerIndex(oldIndex);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\t\tExport Directory: [" + super.toString() + "]\n");
        for (ExportInfo info : this.exports) {
            buff.append("\t\t\t0x" + Long.toHexString(info.getAddress()) + "  " + info.getOrdinal() + "  " + info.getName() + "\n");
        }
        return buff.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "Characteristics", null);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "MajorVersion", null);
        struct.add(WORD, "MinorVersion", null);
        struct.add(IBO32, "Name", null);
        struct.add(DWORD, "Base", null);
        struct.add(DWORD, "NumberOfFunctions", null);
        struct.add(DWORD, "NumberOfNames", null);
        struct.add(IBO32, "AddressOfFunctions", null);
        struct.add(IBO32, "AddressOfNames", null);
        struct.add(IBO32, "AddressOfNameOrdinals", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

