/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DynamicLibraryReference
implements StructConverter {
    private int isym;
    private int flags;

    DynamicLibraryReference(BinaryReader reader) throws IOException {
        int value = reader.readNextInt();
        if (reader.isLittleEndian()) {
            this.isym = value & 0xFFFFFF;
            this.flags = (value & 0xFF000000) >> 24;
        } else {
            this.isym = (value & 0xFFFFFF00) >> 8;
            this.flags = value & 0xFF;
        }
    }

    public int getSymbolIndex() {
        return this.isym;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dylib_reference", 0);
        struct.add(DWORD, "isym_flags", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

