/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.sectionprovider;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.dwarf.external.DWARFExternalDebugFilesPlugin;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugFilesService;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationRegistry;
import ghidra.app.util.bin.format.dwarf.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;

public class ExternalDebugFileSectionProvider
extends BaseSectionProvider {
    public static final String PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE = "DWARF External Debug File";
    private final FSRL externalDebugFileLocation;

    /*
     * Enabled aggressive exception aggregation
     */
    public static DWARFSectionProvider createExternalSectionProviderFor(Program program, TaskMonitor monitor) {
        try {
            ExternalDebugInfo extDebugInfo = ExternalDebugInfo.fromProgram(program);
            if (extDebugInfo == null) {
                return null;
            }
            Msg.info(ExternalDebugFileSectionProvider.class, (Object)("DWARF external debug information found: " + String.valueOf(extDebugInfo)));
            ExternalDebugFilesService edfs = DWARFExternalDebugFilesPlugin.getExternalDebugFilesService(SearchLocationRegistry.getInstance().newContext(program));
            FSRL extDebugFile = edfs.findDebugFile(extDebugInfo, monitor);
            if (extDebugFile == null) {
                return null;
            }
            Msg.info(ExternalDebugFileSectionProvider.class, (Object)("DWARF External Debug File: found: " + String.valueOf(extDebugFile)));
            FileSystemService fsService = FileSystemService.getInstance();
            try (RefdFile refdDebugFile = fsService.getRefdFile(extDebugFile, monitor);){
                ExternalDebugFileSectionProvider externalDebugFileSectionProvider;
                block20: {
                    LoadSpec origLoadSpec;
                    Language lang;
                    Object consumer;
                    ByteProvider debugFileByteProvider;
                    block18: {
                        DWARFSectionProvider dWARFSectionProvider;
                        block19: {
                            debugFileByteProvider = fsService.getByteProvider(refdDebugFile.file.getFSRL(), false, monitor);
                            try {
                                consumer = new Object();
                                lang = program.getLanguage();
                                origLoadSpec = ImporterUtilities.getLoadSpec(program);
                                if (origLoadSpec != null) break block18;
                                dWARFSectionProvider = null;
                                if (debugFileByteProvider == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (debugFileByteProvider != null) {
                                    try {
                                        debugFileByteProvider.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            debugFileByteProvider.close();
                        }
                        return dWARFSectionProvider;
                    }
                    CompilerSpec compSpec = origLoadSpec.getLanguageCompilerSpec().getCompilerSpec();
                    ProgramDB debugProgram = new ProgramDB("temp external debug info for " + program.getName(), lang, compSpec, consumer);
                    Loader origLoader = origLoadSpec.getLoader();
                    List<Option> defaultOptions = origLoader.getDefaultOptions(debugFileByteProvider, origLoadSpec, (DomainObject)debugProgram, false);
                    ElfLoader elfLoader = new ElfLoader();
                    elfLoader.load(debugFileByteProvider, null, defaultOptions, (Program)debugProgram, monitor, new MessageLog());
                    ExternalDebugFileSectionProvider result = new ExternalDebugFileSectionProvider((Program)debugProgram, debugFileByteProvider.getFSRL());
                    debugProgram.release(consumer);
                    externalDebugFileSectionProvider = result;
                    if (debugFileByteProvider == null) break block20;
                    debugFileByteProvider.close();
                }
                return externalDebugFileSectionProvider;
            }
        }
        catch (CancelledException | IOException throwable) {
            return null;
        }
    }

    ExternalDebugFileSectionProvider(Program program, FSRL externalDebugFileLocation) {
        super(program);
        this.externalDebugFileLocation = externalDebugFileLocation;
        program.addConsumer((Object)this);
    }

    @Override
    public void close() {
        if (this.program != null) {
            this.program.release((Object)this);
        }
        super.close();
        this.program = null;
    }

    public Program getExternalProgram() {
        return this.program;
    }

    @Override
    public void updateProgramInfo(Program program) {
        Options options = program.getOptions("Program Information");
        options.setString(PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE, this.externalDebugFileLocation.toString());
    }

    public static FSRL getExternalDebugFileLocation(Program program) {
        Options options = program.getOptions("Program Information");
        String fsrlStr = options.getString(PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE, null);
        try {
            return fsrlStr != null ? FSRL.fromString(fsrlStr) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

