/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharacterScriptUtils {
    public static final List<Character.UnicodeScript> IGNORED_SCRIPTS = List.of(Character.UnicodeScript.INHERITED, Character.UnicodeScript.UNKNOWN);
    public static final Character.UnicodeScript ANY_SCRIPT_ALIAS = Character.UnicodeScript.UNKNOWN;
    static Map<Character.UnicodeScript, String> PREMADE_EXAMPLES = Map.of(Character.UnicodeScript.COMMON, "0-9,!?", Character.UnicodeScript.ARABIC, "\u062d\u064e\u0648\u0651\u0627\u0645\u062a\u064a \u0645\u064f\u0645\u0652\u062a\u0650\u0644\u0626\u0629 \u0628\u0650\u0623\u064e\u0646\u0652\u0642\u064e\u0644\u064e\u064a\u0652\u0633\u0648\u0646", Character.UnicodeScript.CYRILLIC, "\u041c\u043e\u0451 \u0441\u0443\u0434\u043d\u043e \u043d\u0430 \u0432\u043e\u0437\u0434\u0443", Character.UnicodeScript.HAN, "\u6211\u7684\u6c23\u588a\u8239\u88dd\u6eff\u4e86\u9c3b\u9b5a", Character.UnicodeScript.HANGUL, "\uc81c \ud638\ubc84\ud06c\ub798\ud504\ud2b8\uac00 \uc7a5\uc5b4\ub85c \uac00\ub4dd\ud574\uc694", Character.UnicodeScript.KATAKANA, "\u79c1\u306e\u30db\u30d0\u30fc\u30af\u30e9\u30d5\u30c8\u306f\u9c3b\u3067\u3044\u3063\u3071\u3044\u3067\u3059");

    public static Map<Character.UnicodeScript, String> getDisplayableScriptExamples(Font f, int maxExampleLen) {
        HashMap<Character.UnicodeScript, String> result = new HashMap<Character.UnicodeScript, String>();
        for (int i = 0; i < 0x10FFFF; ++i) {
            Character.UnicodeScript us;
            String s;
            if (Character.isISOControl(i) || (s = result.getOrDefault((Object)(us = Character.UnicodeScript.of(i)), "")).length() >= maxExampleLen || !f.canDisplay(i)) continue;
            String premade = PREMADE_EXAMPLES.get((Object)us);
            s = premade == null ? s + Character.toString(i) : premade;
            result.put(us, s);
        }
        return result;
    }
}

