/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.util.bin.InvalidDataException;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;

class MinGWPseudoRelocList {
    static final String PSEUDO_RELOC_LIST_START_NAME = "__RUNTIME_PSEUDO_RELOC_LIST__";
    static final String PSEUDO_RELOC_LIST_END_NAME = "__RUNTIME_PSEUDO_RELOC_LIST_END__";
    private Program program;
    private Address pdwListStartAddr;
    private Address pdwListEndAddr;
    private boolean listLabelsFound;

    MinGWPseudoRelocList(Program program) throws InvalidDataException {
        this.program = program;
        if (!this.findLabeledPseudoRelocList()) {
            if (program.getDefaultPointerSize() == 8) {
                this.findUnlabeledPseudoRelocList64Bit();
            } else {
                this.findUnlabeledPseudoRelocList32Bit();
            }
        }
        if (this.getDataBlock(this.pdwListStartAddr) != this.getDataBlock(this.pdwListEndAddr)) {
            throw new InvalidDataException("Mismatched MinGW relocation list start/end: " + String.valueOf(this.pdwListStartAddr) + " / " + String.valueOf(this.pdwListEndAddr));
        }
    }

    private MemoryBlock getDataBlock(Address addr) throws InvalidDataException {
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        if (block == null || !block.isInitialized()) {
            throw new InvalidDataException("Invalid MinGW relocation list location: " + String.valueOf(addr));
        }
        return block;
    }

    boolean listLabelsFound() {
        return this.listLabelsFound;
    }

    private void findUnlabeledPseudoRelocList64Bit() throws InvalidDataException {
        throw new InvalidDataException("MinGW pseudo-relocation list not found");
    }

    private void findUnlabeledPseudoRelocList32Bit() throws InvalidDataException {
        throw new InvalidDataException("MinGW pseudo-relocation list not found");
    }

    private boolean findLabeledPseudoRelocList() throws InvalidDataException {
        Symbol pdwListStart = MinGWPseudoRelocList.getLabel(this.program, PSEUDO_RELOC_LIST_START_NAME);
        if (pdwListStart == null) {
            return false;
        }
        Symbol pdwListEnd = MinGWPseudoRelocList.getLabel(this.program, PSEUDO_RELOC_LIST_END_NAME);
        if (pdwListEnd != null) {
            this.listLabelsFound = true;
            this.pdwListStartAddr = pdwListStart.getAddress();
            this.pdwListEndAddr = pdwListEnd.getAddress();
            return true;
        }
        throw new InvalidDataException("Missing MinGW __RUNTIME_PSEUDO_RELOC_LIST_END__ symbol");
    }

    private static Symbol getLabel(Program program, String name) {
        return SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)program, (String)name, m -> {});
    }

    Address getListStartAddress() {
        return this.pdwListStartAddr;
    }

    Address getListEndAddress() {
        return this.pdwListEndAddr;
    }
}

