/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import com.google.common.base.Splitter;
import ghidra.graph.viewer.popup.ToolTipInfo;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.util.HTMLUtilities;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AttributedToolTipInfo
extends ToolTipInfo<Attributed> {
    AttributedToolTipInfo(Attributed graphObject, MouseEvent event) {
        super(event, (Object)graphObject);
    }

    public JComponent createToolTipComponent() {
        if (this.graphObject == null) {
            return null;
        }
        String toolTip = this.getToolTipText();
        if (StringUtils.isBlank((CharSequence)toolTip)) {
            return null;
        }
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(toolTip);
        return jToolTip;
    }

    protected void emphasize() {
    }

    protected void deEmphasize() {
    }

    public String getToolTipText() {
        String tooltipText = ((Attributed)this.graphObject).getDescription();
        if (tooltipText != null) {
            return tooltipText;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        if (this.graphObject instanceof AttributedVertex) {
            this.addToolTipTextForVertex(buf, (AttributedVertex)this.graphObject);
        } else if (this.graphObject instanceof AttributedEdge) {
            this.addToolTipTextForEdge(buf, (AttributedEdge)this.graphObject);
        }
        return buf.toString();
    }

    private void addToolTipTextForVertex(StringBuilder buf, AttributedVertex vertex) {
        String vertexType = vertex.getVertexType();
        buf.append("<H3>");
        String escapedText = HTMLUtilities.toLiteralHTML((String)vertex.getName(), (int)80);
        buf.append(escapedText);
        buf.append("</H3><TABLE>");
        if (vertexType != null) {
            this.appendAttribute(buf, "Type", vertexType);
        }
        this.addAttributes(buf, "Name", "VertexType");
        this.appendAttribute(buf, "Id", vertex.getId());
        buf.append("</TABLE>");
    }

    private void addToolTipTextForEdge(StringBuilder buf, AttributedEdge edge) {
        String edgeType = edge.getEdgeType();
        buf.append("<TABLE>");
        if (edgeType != null) {
            this.appendAttribute(buf, "Type", edgeType);
        }
        this.addAttributes(buf, "EdgeType");
        this.appendAttribute(buf, "Id", edge.getId());
        buf.append("</TABLE>");
    }

    private void addAttributes(StringBuilder buf, String ... excludedKeys) {
        Set entries = ((Attributed)this.graphObject).entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (ArrayUtils.contains((Object[])excludedKeys, (Object)key)) continue;
            this.appendAttribute(buf, key, (String)entry.getValue());
        }
    }

    private void appendAttribute(StringBuilder buf, String key, String value) {
        buf.append("<TR><TD>");
        buf.append(key);
        buf.append(":</TD><TD>");
        String escapedText = HTMLUtilities.toLiteralHTML((String)value, (int)80);
        String split = String.join((CharSequence)"<BR>", Splitter.on((char)'\n').split((CharSequence)escapedText));
        split = split.replaceAll("\\s", "&nbsp;");
        buf.append(split);
        buf.append("</TD></TR>");
    }
}

