/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraphExporter;
import ghidra.service.graph.AttributedVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;

public abstract class AbstractAttributedGraphExporter
implements AttributedGraphExporter {
    protected Function<AttributedEdge, String> edgeIdProvider = AttributedEdge::getId;
    protected Function<AttributedVertex, String> vertexIdProvider = AttributedVertex::getId;
    protected Supplier<String> graphIdProvider = () -> "Ghidra";

    protected Map<String, Attribute> getAttributes(Attributed attributed) {
        HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
        for (Map.Entry entry : attributed.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            attributeMap.put(key, (Attribute)new DefaultAttribute((Object)value, AttributeType.STRING));
        }
        return attributeMap;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAttributedGraphExporter other = (AbstractAttributedGraphExporter)obj;
        return this.getName().equals(other.getName());
    }
}

