/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.comments;

import com.google.gson.JsonElement;
import generic.stl.Pair;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.comments.ExtComment;
import sarif.managers.CommentsSarifMgr;

public class SarifCommentWriter
extends AbstractExtWriter {
    private List<Pair<CodeUnit, Pair<String, String>>> comments0;
    private List<Pair<Address, Pair<String, String>>> comments1;

    public SarifCommentWriter(List<Pair<CodeUnit, Pair<String, String>>> target, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.comments0 = target;
    }

    public SarifCommentWriter(Writer baseWriter, List<Pair<Address, Pair<String, String>>> target) throws IOException {
        super(baseWriter);
        this.comments1 = target;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genComments0(monitor);
        this.genComments1(monitor);
        this.root.add("comments", (JsonElement)this.objects);
    }

    private void genComments0(TaskMonitor monitor) throws CancelledException, IOException {
        if (this.comments0 == null) {
            return;
        }
        monitor.initialize((long)this.comments0.size());
        for (Pair<CodeUnit, Pair<String, String>> pair : this.comments0) {
            CodeUnit cu = (CodeUnit)pair.first;
            ExtComment isf = new ExtComment((Pair<String, String>)((Pair)pair.second), true);
            SarifObject sarif = new SarifObject(CommentsSarifMgr.SUBKEY, CommentsSarifMgr.KEY, this.getTree(isf), cu.getMinAddress(), cu.getMaxAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }

    private void genComments1(TaskMonitor monitor) throws CancelledException, IOException {
        if (this.comments1 == null) {
            return;
        }
        monitor.initialize((long)this.comments1.size());
        for (Pair<Address, Pair<String, String>> pair : this.comments1) {
            Address addr = (Address)pair.first;
            ExtComment isf = new ExtComment((Pair<String, String>)((Pair)pair.second), false);
            SarifObject sarif = new SarifObject(CommentsSarifMgr.SUBKEY, CommentsSarifMgr.KEY, this.getTree(isf), addr, addr);
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

