/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sevenzip.SevenZipFileSystemFactory;
import ghidra.file.formats.zip.ZipFileSystem;
import ghidra.file.formats.zip.ZipFileSystemBuiltin;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class ZipFileSystemFactory
implements GFileSystemFactoryByteProvider<ZipFileSystem>,
GFileSystemProbeBytesOnly {
    private static boolean USE_BUILTIN_ZIP_SUPPORT = Boolean.getBoolean("ghidra.file.formats.zip.ZipFileSystemFactory.USE_BUILTIN_ZIP_SUPPORT");
    private static final int START_BYTES_REQUIRED = 2;

    public static void setUseBuiltinZipSupport(boolean b) {
        USE_BUILTIN_ZIP_SUPPORT = b;
    }

    public int getBytesRequired() {
        return 2;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return startBytes[0] == 80 && startBytes[1] == 75;
    }

    public GFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (!USE_BUILTIN_ZIP_SUPPORT && SevenZipFileSystemFactory.initNativeLibraries()) {
            ZipFileSystem fs = new ZipFileSystem(targetFSRL, fsService);
            try {
                fs.mount(byteProvider, monitor);
                return fs;
            }
            catch (IOException ioe) {
                fs.close();
                throw ioe;
            }
        }
        File zipFile = fsService.getFileIfAvailable(byteProvider);
        boolean deleteZipFileWhenDone = false;
        if (zipFile == null) {
            zipFile = fsService.createPlaintextTempFile(byteProvider, "ghidra_tmp_zipfile", monitor);
            deleteZipFileWhenDone = true;
        }
        FSUtilities.uncheckedClose((AutoCloseable)byteProvider, null);
        ZipFileSystemBuiltin fs = new ZipFileSystemBuiltin(targetFSRL, fsService);
        try {
            fs.mount(zipFile, deleteZipFileWhenDone, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }
}

