/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PublicSymbolInformation
extends AbstractSymbolInformation {
    public static final int PUB_HEADER_SIZE = 28;
    private int addressMapLength;
    private int numThunks;
    private int thunkSize;
    private int iSectionThunkTable;
    private int offsetThunkTable;
    private int numSections;
    private int thunkMapLength;
    private int thunkTableLength;
    private int sectionMapLength;
    private int addressMapOffset;
    private int thunkMapOffset;
    private int sectionMapOffset;

    public PublicSymbolInformation(AbstractPdb pdbIn, int streamNumber) {
        super(pdbIn, streamNumber);
    }

    public int getNumThunks() {
        return this.numThunks;
    }

    public int getThunkTableSection() {
        return this.iSectionThunkTable;
    }

    public int getThunkTableOffset() {
        return this.offsetThunkTable;
    }

    public int getThunkSize() {
        return this.thunkSize;
    }

    public int getThunkTableLength() {
        return this.thunkTableLength;
    }

    public int getNumSections() {
        return this.numSections;
    }

    public List<Long> getAddressMapSymbolOffsets() throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.addressMapOffset, this.addressMapLength);
            return this.deserializeAddressMap(reader);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)String.format("PDB: Error creating address map symbol offsets while reading stream %d at offset %d and length %d", this.streamNumber, this.addressMapOffset, this.addressMapLength));
            return new ArrayList<Long>();
        }
    }

    public Map<Integer, Integer> getThunkTargetOffsetsByTableOffset() throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.thunkMapOffset, this.thunkMapLength);
            return this.deserializeThunkMap(reader);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)String.format("PDB: Error creating thunk target offsets by table offset while reading stream %d offset %d and length %d", this.streamNumber, this.thunkMapOffset, this.thunkMapLength));
            return new HashMap<Integer, Integer>();
        }
    }

    public Map<Integer, Integer> getAbsoluteOffsetsBySectionNumber() throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.sectionMapOffset, this.sectionMapLength);
            return this.deserializeSectionMap(reader);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)String.format("PDB: Error creating absolute offsets by section number while reading stream %d offset %d and length %d", this.streamNumber, this.sectionMapOffset, this.sectionMapLength));
            return new HashMap<Integer, Integer>();
        }
    }

    @Override
    void initialize() throws IOException, PdbException, CancelledException {
        this.initializeValues();
        this.deserializePubHeader();
        this.deserializeHashHeader();
    }

    @Override
    void dump(Writer writer) throws IOException, CancelledException, PdbException {
        PdbReaderUtils.dumpHead(writer, this);
        this.dumpPubHeader(writer);
        this.dumpHashHeader(writer);
        this.dumpHashBasics(writer);
        this.dumpHashRecords(writer);
        this.dumpAddressMap(writer);
        this.dumpThunkMap(writer);
        this.dumpSectionMap(writer);
        writer.write("\n");
        PdbReaderUtils.dumpTail(writer, this);
    }

    private List<Long> deserializeAddressMap(PdbByteReader reader) throws PdbException, CancelledException {
        ArrayList<Long> myAddressMapSymbolOffsets = new ArrayList<Long>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            myAddressMapSymbolOffsets.add(Long.valueOf(reader.parseInt()));
        }
        return myAddressMapSymbolOffsets;
    }

    private void dumpAddressMap(Writer writer) throws CancelledException, IOException, PdbException {
        writer.write("AddressMapSymbolOffsets-------------------------------------\n");
        List<Long> myAddressMapSymbolOffsets = this.getAddressMapSymbolOffsets();
        writer.write("numAddressMapSymbolOffsets: " + myAddressMapSymbolOffsets.size() + "\n");
        int num = 0;
        for (Long val : myAddressMapSymbolOffsets) {
            this.pdb.checkCancelled();
            writer.write(String.format("0X%08X: 0X%012X\n", num++, val));
        }
        writer.write("\nEnd AddressMapSymbolOffsets---------------------------------\n");
    }

    private Map<Integer, Integer> deserializeThunkMap(PdbByteReader reader) throws PdbException, CancelledException {
        int count = 0;
        HashMap<Integer, Integer> myThunkTargetOffsetsByTableOffset = new HashMap<Integer, Integer>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int targetOffset = reader.parseInt();
            int mapTableOffset = count * this.thunkSize + this.offsetThunkTable;
            myThunkTargetOffsetsByTableOffset.put(mapTableOffset, targetOffset);
        }
        return myThunkTargetOffsetsByTableOffset;
    }

    private void dumpThunkMap(Writer writer) throws CancelledException, IOException, PdbException {
        Map<Integer, Integer> myThunkTargetOffsetsByTableOffset = this.getThunkTargetOffsetsByTableOffset();
        writer.write("ThunkMap----------------------------------------------------\n");
        writer.write("numThunkTargetOffsetsByTableOffset: " + myThunkTargetOffsetsByTableOffset.size() + "\n");
        for (Map.Entry<Integer, Integer> entry : myThunkTargetOffsetsByTableOffset.entrySet()) {
            this.pdb.checkCancelled();
            writer.write(String.format("0X%08X  0X%08X\n", entry.getKey(), entry.getValue()));
        }
        writer.write("\nEnd ThunkMap------------------------------------------------\n");
    }

    private Map<Integer, Integer> deserializeSectionMap(PdbByteReader reader) throws PdbException, CancelledException {
        HashMap<Integer, Integer> myAbsoluteOffsetsBySectionNumber = new HashMap<Integer, Integer>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int offset = reader.parseInt();
            int section = reader.parseUnsignedShortVal();
            reader.skip(2);
            myAbsoluteOffsetsBySectionNumber.put(section, offset);
        }
        return myAbsoluteOffsetsBySectionNumber;
    }

    private void dumpSectionMap(Writer writer) throws CancelledException, IOException, PdbException {
        Map<Integer, Integer> myAbsoluteOffsetsBySectionNumber = this.getAbsoluteOffsetsBySectionNumber();
        writer.write("SectionMap--------------------------------------------------\n");
        writer.write("numAbsoluteOffsetsBySectionNumber: " + myAbsoluteOffsetsBySectionNumber.size() + "\n");
        for (Map.Entry<Integer, Integer> entry : myAbsoluteOffsetsBySectionNumber.entrySet()) {
            this.pdb.checkCancelled();
            writer.write(String.format("0X%08X  0X%08X\n", entry.getKey(), entry.getValue()));
        }
        writer.write("\nEnd SectionMap----------------------------------------------\n");
    }

    private void dumpPubHeader(Writer writer) throws IOException {
        writer.write("PublicSymbolInformationHeader-------------------------------\n");
        writer.write("symbolHashLength: " + this.symbolHashLength);
        writer.write("\naddressMapLength: " + this.addressMapLength);
        writer.write("\nnumThunks: " + this.numThunks);
        writer.write("\nthunkSize: " + this.thunkSize);
        writer.write("\niSectionThunkTable: " + this.iSectionThunkTable);
        writer.write("\noffsetThunkTable: " + this.offsetThunkTable);
        writer.write("\nnumSections: " + this.numSections);
        writer.write("\nthunkMapLength: " + this.thunkMapLength);
        writer.write("\nthunkTableLength: " + this.thunkTableLength);
        writer.write("\nEnd PublicSymbolInformationHeader---------------------------\n");
    }

    void deserializePubHeader() throws PdbException, CancelledException, IOException {
        MsfStream stream = this.pdb.getMsf().getStream(this.streamNumber);
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, 0, 28);
        this.deserializePubHeader(reader, stream.getLength());
    }

    private void deserializePubHeader(PdbByteReader reader, int streamLength) throws PdbException {
        this.symbolHashLength = reader.parseInt();
        this.addressMapLength = reader.parseInt();
        long val = reader.parseUnsignedIntVal();
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer num thunks");
        }
        this.numThunks = (int)val;
        this.thunkSize = reader.parseInt();
        this.iSectionThunkTable = reader.parseUnsignedShortVal();
        reader.skip(2);
        this.offsetThunkTable = reader.parseInt();
        val = reader.parseUnsignedIntVal();
        this.numSections = (int)val;
        val = 4 * this.numThunks;
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer for thunk map length");
        }
        this.thunkMapLength = (int)val;
        val = this.thunkSize * this.numThunks;
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer for thunk table length");
        }
        this.thunkTableLength = (int)val;
        this.symbolHashOffset = 28;
        this.addressMapOffset = this.symbolHashOffset + this.symbolHashLength;
        this.thunkMapOffset = this.addressMapOffset + this.addressMapLength;
        this.sectionMapOffset = this.thunkMapOffset + this.thunkMapLength;
        this.sectionMapLength = streamLength - this.sectionMapOffset;
        if (this.sectionMapLength % 8 != 0) {
            throw new PdbException("sectionMapLength size not multiple of 8");
        }
        this.numSections = this.sectionMapLength / 8;
    }
}

