/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.references.MemReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;

class ShiftedReferenceDB
extends MemReferenceDB
implements ShiftedReference {
    public ShiftedReferenceDB(Program program, Address from, Address to, RefType refType, byte opIndex, SourceType sourceType, boolean isPrimary, long symbolID, int shift) {
        super(program, from, to, refType, opIndex, sourceType, isPrimary, symbolID, false, true, shift);
    }

    @Override
    public int getShift() {
        return (int)this.offsetOrShift;
    }

    @Override
    public long getValue() {
        return this.toAddr.getOffset() >> (int)this.offsetOrShift;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ShiftedReference)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ShiftedReference ref = (ShiftedReference)obj;
        return this.offsetOrShift == (long)ref.getShift();
    }

    @Override
    public String toString() {
        return super.toString() + " Shift: 0x" + Long.toHexString(this.offsetOrShift);
    }
}

