/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import generic.theme.Gui;
import ghidra.bitpatterns.gui.ClosedPatternRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;

public class ClosedPatternTableModel
extends ThreadedTableModelStub<ClosedPatternRowObject> {
    private List<ClosedPatternRowObject> rowObjects;
    private static final String MODEL_NAME = "Closed Patterns";
    protected static final String FONT_ID = "font.bytepatterns.table";
    protected GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component component = super.getTableCellRendererComponent(data);
            component.setFont(Gui.getFont((String)ClosedPatternTableModel.FONT_ID));
            return component;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public ClosedPatternTableModel(List<ClosedPatternRowObject> rowObjects, ServiceProvider serviceProvider) {
        super(MODEL_NAME, serviceProvider);
        this.rowObjects = rowObjects;
    }

    protected void doLoad(Accumulator<ClosedPatternRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll(this.rowObjects);
        }
    }

    protected TableColumnDescriptor<ClosedPatternRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternFixedBitsTableColumn(this), 0, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternNumOccurrencesTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternPercentageTableColumn(this));
        return descriptor;
    }

    class ClosedPatternTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, String, Object> {
        ClosedPatternTableColumn() {
        }

        public String getColumnName() {
            return "Byte Sequence";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return ClosedPatternTableModel.this.monospacedRenderer;
        }

        public String getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getDittedString();
        }
    }

    class ClosedPatternFixedBitsTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Integer, Object> {
        ClosedPatternFixedBitsTableColumn(ClosedPatternTableModel this$0) {
        }

        public String getColumnName() {
            return "Fixed Bits";
        }

        public Integer getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getNumFixedBits();
        }
    }

    class ClosedPatternNumOccurrencesTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Integer, Object> {
        ClosedPatternNumOccurrencesTableColumn(ClosedPatternTableModel this$0) {
        }

        public String getColumnName() {
            return "Number of Occurrences";
        }

        public Integer getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getNumOccurrences();
        }
    }

    class ClosedPatternPercentageTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Double, Object> {
        ClosedPatternPercentageTableColumn(ClosedPatternTableModel this$0) {
        }

        public String getColumnName() {
            return "Percentage";
        }

        public Double getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getPercentage();
        }
    }
}

