/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.address.Address;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;

public class CachedBytePage {
    private static final int PAGE_SIZE = 4096;
    private static final int CACHE_SIZE = 4;
    private final SequencedMap<CacheKey, CacheEntry> map = new LinkedHashMap<CacheKey, CacheEntry>();

    private static boolean coordsEqualForMemory(DebuggerCoordinates c1, DebuggerCoordinates c2) {
        return c1.getTrace() == c2.getTrace() && c1.getViewSnap() == c2.getViewSnap();
    }

    public byte getByte(DebuggerCoordinates coordinates, Address address) {
        int offset;
        for (Map.Entry ent : this.map.entrySet()) {
            offset = ((CacheKey)ent.getKey()).computeOffset(coordinates, address);
            if (offset == -1) continue;
            this.map.remove(ent.getKey());
            this.map.put((CacheKey)ent.getKey(), (CacheEntry)ent.getValue());
            return ((CacheEntry)ent.getValue()).page[offset];
        }
        CacheEntry entry = this.map.size() >= 4 ? this.map.pollFirstEntry().getValue() : new CacheEntry();
        CacheKey key = entry.refresh(coordinates, address);
        offset = key.computeOffset(coordinates, address);
        assert (offset != -1);
        this.map.put(key, entry);
        return entry.page[offset];
    }

    public void invalidate() {
        this.map.clear();
    }

    record CacheKey(DebuggerCoordinates coordinates, Address start) {
        int computeOffset(DebuggerCoordinates coordinates, Address address) {
            long offset;
            if (CachedBytePage.coordsEqualForMemory(this.coordinates, coordinates) && 0L <= (offset = address.subtract(this.start)) && offset < 4096L) {
                return (int)offset;
            }
            return -1;
        }
    }

    record CacheEntry(byte[] page, ByteBuffer buf) {
        public CacheEntry(byte[] page) {
            this(page, ByteBuffer.wrap(page));
        }

        public CacheEntry() {
            this(new byte[4096]);
        }

        CacheKey refresh(DebuggerCoordinates coordinates, Address address) {
            this.buf.clear();
            Address min = address.getAddressSpace().getMinAddress();
            Address start = address.subtractWrap((long)(this.page.length / 2));
            if (start.compareTo((Object)min) < 0 || start.compareTo((Object)address) > 0) {
                start = min;
            }
            coordinates.getTrace().getMemoryManager().getViewBytes(coordinates.getViewSnap(), start, this.buf);
            return new CacheKey(coordinates, start);
        }
    }
}

