/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.op.JitBinOp;
import org.objectweb.asm.MethodVisitor;

public interface BinOpGen<T extends JitBinOp>
extends OpGen<T> {
    default public JitType afterLeft(JitCodeGenerator gen, T op, JitType lType, JitType rType, MethodVisitor rv) {
        return lType;
    }

    public JitType generateBinOpRunCode(JitCodeGenerator var1, T var2, JitControlFlowModel.JitBlock var3, JitType var4, JitType var5, MethodVisitor var6);

    @Override
    default public void generateRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitType lType = gen.generateValReadCode(op.l(), op.lType());
        JitType rType = op.rType().resolve(gen.getTypeModel().typeOf(op.r()));
        lType = this.afterLeft(gen, op, lType, rType, rv);
        JitType checkRType = gen.generateValReadCode(op.r(), op.rType());
        if (!1.$assertionsDisabled && checkRType != rType) {
            throw new AssertionError();
        }
        JitType outType = this.generateBinOpRunCode(gen, op, block, lType, rType, rv);
        gen.generateVarWriteCode(op.out(), outType);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

