/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.timing;

import io.sf.carte.echosvg.anim.timing.InstanceTime;
import io.sf.carte.echosvg.anim.timing.Interval;
import io.sf.carte.echosvg.anim.timing.OffsetTimingSpecifier;
import io.sf.carte.echosvg.anim.timing.TimedElement;
import java.util.HashMap;

public class SyncbaseTimingSpecifier
extends OffsetTimingSpecifier {
    protected String syncbaseID;
    protected TimedElement syncbaseElement;
    protected boolean syncBegin;
    protected HashMap<Interval, InstanceTime> instances = new HashMap();

    public SyncbaseTimingSpecifier(TimedElement timedElement, boolean bl, float f, String string, boolean bl2) {
        super(timedElement, bl, f);
        this.syncbaseID = string;
        this.syncBegin = bl2;
        this.syncbaseElement = timedElement.getTimedElementById(string);
        this.syncbaseElement.addDependent(this, bl2);
    }

    @Override
    public String toString() {
        return this.syncbaseID + "." + (this.syncBegin ? "begin" : "end") + (this.offset != 0.0f ? super.toString() : "");
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isEventCondition() {
        return false;
    }

    @Override
    float newInterval(Interval interval) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        InstanceTime instanceTime = new InstanceTime(this, (this.syncBegin ? interval.getBegin() : interval.getEnd()) + this.offset, true);
        this.instances.put(interval, instanceTime);
        interval.addDependent(instanceTime, this.syncBegin);
        return this.owner.addInstanceTime(instanceTime, this.isBegin);
    }

    @Override
    float removeInterval(Interval interval) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        InstanceTime instanceTime = this.instances.get(interval);
        interval.removeDependent(instanceTime, this.syncBegin);
        return this.owner.removeInstanceTime(instanceTime, this.isBegin);
    }

    @Override
    float handleTimebaseUpdate(InstanceTime instanceTime, float f) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        return this.owner.instanceTimeChanged(instanceTime, this.isBegin);
    }
}

