/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.a11y.brlapi.ExitException;
import org.a11y.brlapi.ExternalException;
import org.a11y.brlapi.KeywordMap;
import org.a11y.brlapi.ProgramComponent;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.SemanticException;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;
import org.a11y.brlapi.TooManyParametersException;

public abstract class Program
extends ProgramComponent
implements Runnable {
    private String programName = null;
    private final String[] programArguments;
    private final KeywordMap<Option> programOptions = new KeywordMap();
    private List<String> requiredParameters = null;
    private List<String> optionalParameters = null;
    private boolean haveRepeatingParameter = false;
    public static final char USAGE_OPTIONAL_BEGIN = '[';
    public static final char USAGE_OPTIONAL_END = ']';
    public static final String USAGE_REPEATING_INDICATOR = "...";

    protected abstract void runProgram() throws ProgramException;

    public final boolean isClient() {
        return Program.isClient(this);
    }

    public final String getProgramName() {
        if (this.programName == null) {
            return this.getObjectName();
        }
        return this.programName;
    }

    public final Program setProgramName(String string) {
        this.programName = string;
        return this;
    }

    protected final void writeProgramMessage(String string, Object ... objectArray) {
        System.err.println(this.getObjectName() + ": " + String.format(string, objectArray));
    }

    protected final void addOption(String string, Option.Handler handler, String ... stringArray) {
        this.programOptions.put(string, new Option(string, handler, stringArray));
    }

    protected final void addRequiredParameters(String ... stringArray) {
        if (this.optionalParameters != null) {
            throw new IllegalStateException("optional parameters already added");
        }
        if (this.requiredParameters == null) {
            this.requiredParameters = new ArrayList<String>();
        }
        for (String string : stringArray) {
            this.requiredParameters.add(string);
        }
    }

    protected final void addOptionalParameters(String ... stringArray) {
        if (this.haveRepeatingParameter) {
            throw new IllegalStateException("repeating parameter already added");
        }
        if (this.optionalParameters == null) {
            this.optionalParameters = new ArrayList<String>();
        }
        for (String string : stringArray) {
            this.optionalParameters.add(string);
        }
    }

    protected final void addRepeatingParameter(String string) {
        this.addOptionalParameters(string);
        this.haveRepeatingParameter = true;
    }

    public String getPurpose() {
        return null;
    }

    protected void extendUsageSummary(StringBuilder stringBuilder) {
    }

    /*
     * WARNING - void declaration
     */
    public final String getUsageSummary() {
        String[] stringArray;
        void var6_19;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = !this.programOptions.isEmpty();
        String string = "^(.*)(\\p{Upper}.*)$";
        Object object2 = this.getObjectName();
        Matcher object32 = Strings.getMatcher(string, (String)object2);
        if (object32.matches()) {
            object2 = object32.group(1);
            String string2 = "the " + (String)object2 + " " + object32.group(2);
        } else {
            String string3 = object2;
        }
        stringBuilder.append("Usage Summary for ").append((String)var6_19);
        stringBuilder.append("\nSyntax: ").append(this.getProgramName());
        int n = stringBuilder.length();
        if (bl) {
            stringBuilder.append(' ').append('[').append('-').append("option").append(' ').append(USAGE_REPEATING_INDICATOR).append(']');
        }
        if (this.requiredParameters != null) {
            for (String string4 : this.requiredParameters) {
                stringBuilder.append(' ').append(Program.toOperandName(string4));
            }
        }
        if (this.optionalParameters != null) {
            for (String string5 : this.optionalParameters) {
                stringBuilder.append(' ').append('[').append(Program.toOperandName(string5));
            }
            if (this.haveRepeatingParameter) {
                stringBuilder.append(' ').append(USAGE_REPEATING_INDICATOR);
            }
            for (int i = this.optionalParameters.size(); i > 0; --i) {
                stringBuilder.append(']');
            }
        }
        if (stringBuilder.length() == n) {
            stringBuilder.append(" (no arguments)");
        }
        if ((stringArray = this.getPurpose()) != null && !stringArray.isEmpty()) {
            stringBuilder.append("\n\n").append((String)stringArray);
        }
        if (bl) {
            void var5_16;
            stringBuilder.append("\n\nThese options may be specified:");
            stringArray = this.programOptions.getKeywords();
            int n2 = stringArray.length;
            boolean bl2 = false;
            while (var5_16 < n2) {
                String string6 = stringArray[var5_16];
                Option option = this.programOptions.get(string6);
                stringBuilder.append("\n  ").append('-').append(string6);
                for (String string7 : option.getOperands()) {
                    stringBuilder.append(' ').append(Program.toOperandName(string7));
                }
                ++var5_16;
            }
        }
        stringArray = new StringBuilder();
        this.extendUsageSummary((StringBuilder)stringArray);
        String string3 = Strings.formatParagraphs(stringArray.toString());
        if (!string3.isEmpty()) {
            stringBuilder.append("\n\n").append(string3);
        }
        return stringBuilder.toString();
    }

    protected Program(String ... stringArray2) {
        this.programArguments = stringArray2;
        this.addOption("help", stringArray -> {
            Program.printf("%s\n", this.getUsageSummary());
            throw new ExitException(0);
        }, new String[0]);
    }

    protected void processParameters(String[] stringArray) throws SyntaxException {
        if (stringArray.length > 0) {
            throw new TooManyParametersException(stringArray);
        }
    }

    private final void processArguments(String[] stringArray) throws SyntaxException {
        Object object;
        String string;
        int n;
        int n2;
        int n3 = stringArray.length;
        for (n = 0; n < n3 && !(string = stringArray[n]).isEmpty() && string.charAt(0) == '-'; n += 1 + n2) {
            if (string.length() == 1) {
                ++n;
                break;
            }
            object = string.substring(1).toLowerCase();
            Option option = this.programOptions.get((String)object);
            if (option == null) {
                throw new SyntaxException("unknown option: %s", string);
            }
            int n4 = n3 - n - 1;
            String[] stringArray2 = option.getOperands();
            n2 = stringArray2.length;
            if (n4 < n2) {
                throw new SyntaxException("missing %s: %c%s", stringArray2[n4], Character.valueOf('-'), option.getName());
            }
            String[] stringArray3 = new String[n2];
            System.arraycopy(stringArray, n + 1, stringArray3, 0, n2);
            option.getHandler().handleOption(stringArray3);
        }
        int n5 = n3 - n;
        object = new String[n5];
        System.arraycopy(stringArray, n, object, 0, n5);
        this.processParameters((String[])object);
    }

    protected void onProgramException(ProgramException programException) {
        this.writeProgramMessage("%s", programException.getMessage());
        int n = programException instanceof SyntaxException ? 2 : (programException instanceof SemanticException ? 3 : (programException instanceof ExternalException ? 8 : 9));
        throw new ExitException(n);
    }

    @Override
    public final void run() {
        try {
            this.processArguments(this.programArguments);
            this.runProgram();
        }
        catch (ProgramException programException) {
            this.onProgramException(programException);
        }
    }

    protected static class Option {
        public static final char PREFIX_CHARACTER = '-';
        private final String optionName;
        private final Handler optionHandler;
        private final String[] operandDescriptions;

        public Option(String string, Handler handler, String ... stringArray) {
            this.optionName = string;
            this.optionHandler = handler;
            this.operandDescriptions = stringArray;
        }

        public final String getName() {
            return this.optionName;
        }

        public final Handler getHandler() {
            return this.optionHandler;
        }

        public final String[] getOperands() {
            int n = this.operandDescriptions.length;
            String[] stringArray = new String[n];
            System.arraycopy(this.operandDescriptions, 0, stringArray, 0, n);
            return stringArray;
        }

        public static interface Handler {
            public void handleOption(String[] var1) throws SyntaxException;
        }
    }
}

