/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.GammaIntegerCodec;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;

public final class GammaIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;

    GammaIntegerEncoding(int offset) {
        super(EncodingID.GAMMA);
        this.offset = offset;
    }

    public static GammaIntegerEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        int offset = ITF8.readUnsignedITF8(serializedParams);
        return new GammaIntegerEncoding(offset);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new GammaIntegerCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.offset);
    }

    public String toString() {
        return String.format("Offset: %d", this.offset);
    }
}

