/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

import java.util.Objects;

public final class CRAMVersion
implements Comparable<CRAMVersion> {
    private final int major;
    private final int minor;

    public CRAMVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public CRAMVersion(String version) {
        String[] numbers = version.split("[\\.\\-b]");
        this.major = Integer.parseInt(numbers[0]);
        this.minor = Integer.parseInt(numbers[1]);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public int compareTo(CRAMVersion o) {
        if (o == null) {
            return -1;
        }
        if (this.major - o.major != 0) {
            return this.major - o.major;
        }
        return this.minor - o.minor;
    }

    public boolean compatibleWith(CRAMVersion cramVersion) {
        return this.compareTo(cramVersion) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRAMVersion cramVersion = (CRAMVersion)o;
        return this.major == cramVersion.major && this.minor == cramVersion.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }
}

