/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.ant;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.PropertyStringParser;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.ant.ParameterConfiguration;
import com.martiansoftware.jsap.ant.ParserProperty;
import java.io.PrintStream;
import java.util.Vector;

public abstract class OptionConfiguration
extends ParameterConfiguration {
    private boolean required = false;
    private Vector parserProperties = null;
    private boolean isList = false;
    private char listSeparator = JSAP.DEFAULT_LISTSEPARATOR;
    private boolean declaredListSeparator = false;
    private String stringParser = null;

    public OptionConfiguration() {
        this.parserProperties = new Vector();
    }

    public void setStringparser(String stringParser) {
        this.stringParser = stringParser;
    }

    public String getStringparser() {
        String result = null;
        if (this.stringParser != null) {
            result = this.stringParser.indexOf(".") == -1 ? "com.martiansoftware.jsap.stringparsers." + this.stringParser : this.stringParser;
        }
        return result;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setIslist(boolean isList) {
        this.isList = isList;
    }

    public boolean getIslist() {
        return this.isList;
    }

    public void setListseparator(char listSeparator) {
        this.declaredListSeparator = true;
        this.listSeparator = listSeparator;
    }

    public char getListseparator() {
        return this.listSeparator;
    }

    public boolean declaredListSeparator() {
        return this.declaredListSeparator;
    }

    public void addConfiguredProperty(ParserProperty p) {
        this.parserProperties.add(p);
    }

    public ParserProperty[] getParserProperties() {
        ParserProperty[] result = null;
        if (this.parserProperties.size() > 0) {
            result = this.parserProperties.toArray(new ParserProperty[0]);
        }
        return result;
    }

    @Override
    public boolean hasProperties() {
        ParserProperty[] props = this.getParserProperties();
        return props != null && props.length > 0;
    }

    protected void setupStringParser(Option option) {
        if (this.getStringparser() != null) {
            try {
                StringParser sp = (StringParser)Class.forName(this.getStringparser()).newInstance();
                if (option instanceof FlaggedOption) {
                    ((FlaggedOption)option).setStringParser(sp);
                } else {
                    ((UnflaggedOption)option).setStringParser(sp);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate \"" + this.getStringparser() + "\"");
            }
        }
        if (this.hasProperties()) {
            try {
                PropertyStringParser psp = (PropertyStringParser)option.getStringParser();
                ParserProperty[] props = this.getParserProperties();
                for (int i = 0; i < props.length; ++i) {
                    psp.setProperty(props[i].getName(), props[i].getValue());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Option \"" + option.getID() + "\": " + option.getStringParser().getClass().getName() + " is not an instance of " + "com.martiansoftware.jsap.PropertyParser.");
            }
        }
    }

    @Override
    protected void createParentStatements(String objName, PrintStream out) {
        super.createParentStatements(objName, out);
        out.println("        " + objName + ".setList(" + (this.getIslist() ? "true" : "false") + ");");
        out.println("        " + objName + ".setRequired(" + (this.getRequired() ? "true" : "false") + ");");
        if (this.getStringparser() != null) {
            out.println("        " + objName + ".setStringParser( new " + this.getStringparser() + "() );");
        }
        if (this.hasProperties()) {
            ParserProperty[] props = this.getParserProperties();
            out.println();
            out.println("        PropertyStringParser psp = (PropertyStringParser) " + objName + ".getStringParser();");
            for (int i = 0; i < props.length; ++i) {
                out.println("        psp.setProperty(\"" + props[i].getName() + "\", \"" + props[i].getValue() + "\");");
            }
            out.println();
        }
        if (this.declaredListSeparator()) {
            out.println("        " + objName + ".setListSeparator('" + this.getListseparator() + "');");
        }
    }
}

