/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.gff;

import htsjdk.tribble.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.WrappedIterator;
import org.broad.igv.feature.gff.GFF2Combiner;
import org.broad.igv.feature.gff.GFF3Combiner;
import org.broad.igv.feature.gff.GFFCombiner;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.track.FeatureSource;

public class GFFFeatureSource
implements FeatureSource {
    private static Logger log = Logger.getLogger(GFFFeatureSource.class);
    private GFFCodec.Version gffVersion;
    private FeatureSource wrappedSource;

    public static boolean isGFF(String path) {
        int idx;
        String lowpath = path.toLowerCase();
        if (lowpath.endsWith(".gz")) {
            idx = lowpath.length() - 3;
            lowpath = lowpath.substring(0, idx);
        }
        if (lowpath.endsWith(".txt")) {
            idx = lowpath.length() - 4;
            lowpath = lowpath.substring(0, idx);
        }
        return lowpath.endsWith("gff3") || lowpath.endsWith("gvf") || lowpath.endsWith("gff") || lowpath.endsWith("gtf");
    }

    public static GFFCombiner getCombiner(GFFCodec.Version version) {
        return version == GFFCodec.Version.GFF3 ? new GFF3Combiner() : new GFF2Combiner();
    }

    public GFFFeatureSource(FeatureSource wrappedSource, GFFCodec.Version gffVersion) throws IOException {
        this.gffVersion = gffVersion;
        this.wrappedSource = wrappedSource;
    }

    @Override
    public void dispose() {
        this.wrappedSource.dispose();
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        int expandedStart = Math.max(0, start - 2000000);
        long longEnd = (long)end + 2000000L;
        int expandedEnd = (int)Math.min(Integer.MAX_VALUE, longEnd);
        Iterator<Feature> rawIter = this.wrappedSource.getFeatures(chr, expandedStart, expandedEnd);
        GFFCombiner combiner = GFFFeatureSource.getCombiner(this.gffVersion).addFeatures(rawIter);
        ArrayList<Feature> requestedFeatures = new ArrayList<Feature>();
        for (Feature f : combiner.combineFeatures()) {
            if (f.getEnd() < start) continue;
            if (f.getStart() > end) break;
            requestedFeatures.add(f);
        }
        return new WrappedIterator(requestedFeatures.iterator());
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return this.wrappedSource.getCoverageScores(chr, start, end, zoom);
    }

    @Override
    public int getFeatureWindowSize() {
        return this.wrappedSource.getFeatureWindowSize();
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.wrappedSource.setFeatureWindowSize(size);
    }
}

