/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.lang.MutableString;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.readers.sam.SamComparisonInterface;
import org.campagnelab.goby.util.SamHelper;

public class SamComparison
implements SamComparisonInterface {
    private boolean mappedQualitiesPreserved = false;
    private boolean softClipsPreserved = false;
    private boolean checkMate = false;
    private boolean canonicalMdzForComparison = true;
    private boolean readNamesPreserved;
    private boolean allowSourceNs;
    private int currentComparisonScore;
    protected int readNum;
    protected int comparisonFailureCount;
    protected boolean outputFailedComparisons = true;
    protected boolean countComparisonFailures;
    private final MutableString comparisonErrorDump = new MutableString();
    private final List<String> comparisonFailures = new ArrayList<String>();
    private boolean initialized = false;

    @Override
    public void reset() {
        this.readNum = 0;
        this.comparisonFailureCount = 0;
        this.countComparisonFailures = true;
    }

    @Override
    public boolean isMappedQualitiesPreserved() {
        return this.mappedQualitiesPreserved;
    }

    @Override
    public void setMappedQualitiesPreserved(boolean mappedQualitiesPreserved) {
        this.mappedQualitiesPreserved = mappedQualitiesPreserved;
    }

    @Override
    public boolean isSoftClipsPreserved() {
        return this.softClipsPreserved;
    }

    @Override
    public void setSoftClipsPreserved(boolean softClipsPreserved) {
        this.softClipsPreserved = softClipsPreserved;
    }

    @Override
    public boolean isCheckMate() {
        return this.checkMate;
    }

    @Override
    public void setCheckMate(boolean checkMate) {
        this.checkMate = checkMate;
    }

    @Override
    public boolean isCanonicalMdzForComparison() {
        return this.canonicalMdzForComparison;
    }

    @Override
    public void setCanonicalMdzForComparison(boolean canonicalMdzForComparison) {
        this.canonicalMdzForComparison = canonicalMdzForComparison;
    }

    @Override
    public int getReadNum() {
        return this.readNum;
    }

    @Override
    public int getComparisonFailureCount() {
        return this.comparisonFailureCount;
    }

    public List<String> getComparisonFailures() {
        return this.comparisonFailures;
    }

    public boolean isOutputFailedComparisons() {
        return this.outputFailedComparisons;
    }

    public void setOutputFailedComparisons(boolean outputFailedComparisons) {
        this.outputFailedComparisons = outputFailedComparisons;
    }

    public boolean isCountComparisonFailures() {
        return this.countComparisonFailures;
    }

    public void setCountComparisonFailures(boolean countComparisonFailures) {
        this.countComparisonFailures = countComparisonFailures;
    }

    public int getCurrentComparisonScore() {
        return this.currentComparisonScore;
    }

    @Override
    public boolean isReadNamesPreserved() {
        return this.readNamesPreserved;
    }

    @Override
    public void setReadNamesPreserved(boolean readNamesPreserved) {
        this.readNamesPreserved = readNamesPreserved;
    }

    @Override
    public boolean isAllowSourceNs() {
        return this.allowSourceNs;
    }

    @Override
    public void setAllowSourceNs(boolean allowSourceNs) {
        this.allowSourceNs = allowSourceNs;
    }

    @Override
    public int compare(SAMRecord expectedSamRecord, SAMRecord actualSamRecord, Alignments.AlignmentEntry gobyAlignment) {
        String aMdz;
        String eMdz;
        this.currentComparisonScore = 0;
        if (!this.initialized) {
            this.initialized = true;
            this.reset();
        }
        this.comparisonFailures.clear();
        this.compareField("Positions don't match", expectedSamRecord.getAlignmentStart(), actualSamRecord.getAlignmentStart(), 2);
        this.compareField("Ref Index don't match", expectedSamRecord.getReferenceName(), expectedSamRecord.getReferenceName(), 2);
        if (this.readNamesPreserved) {
            this.compareField("Read name doesn't match", expectedSamRecord.getReadName(), actualSamRecord.getReadName(), 2);
        }
        this.compareField("Flags don't match", expectedSamRecord.getFlags(), actualSamRecord.getFlags(), 1);
        this.compareField("Mapping quality doesn't match", expectedSamRecord.getMappingQuality(), actualSamRecord.getMappingQuality(), 2);
        this.compareField("Read paired flag doesn't match", expectedSamRecord.getReadPairedFlag(), actualSamRecord.getReadPairedFlag(), 1);
        this.compareField("Read length doesn't match", expectedSamRecord.getReadLength(), actualSamRecord.getReadLength(), 2);
        if (this.checkMate && expectedSamRecord.getReadPairedFlag()) {
            this.compareField("Read mate unmapped doesn't match", expectedSamRecord.getMateUnmappedFlag(), actualSamRecord.getMateUnmappedFlag(), 1);
            if (!expectedSamRecord.getMateUnmappedFlag()) {
                this.compareField("Mate alignment start doesn't match", expectedSamRecord.getMateAlignmentStart(), actualSamRecord.getMateAlignmentStart(), 2);
                this.compareField("Mate alignment index doesn't match", expectedSamRecord.getMateReferenceIndex(), actualSamRecord.getMateReferenceIndex(), 2);
                this.compareField("Inferred insert size doesn't match", expectedSamRecord.getInferredInsertSize(), actualSamRecord.getInferredInsertSize(), 2);
            }
        }
        this.compareField("Positive/negative strand doesn't match", expectedSamRecord.getReadNegativeStrandFlag(), actualSamRecord.getReadNegativeStrandFlag(), 2);
        this.compareField("Cigars don't match", expectedSamRecord.getCigarString(), actualSamRecord.getCigarString(), 2);
        if (this.canonicalMdzForComparison) {
            eMdz = SamHelper.canonicalMdz(expectedSamRecord.getStringAttribute("MD"));
            aMdz = SamHelper.canonicalMdz(actualSamRecord.getStringAttribute("MD"));
        } else {
            eMdz = expectedSamRecord.getStringAttribute("MD");
            aMdz = actualSamRecord.getStringAttribute("MD");
        }
        this.compareField("MD:Z doesn't match", eMdz, aMdz, 3);
        String eRead = this.usableReadOf(expectedSamRecord);
        String aRead = this.usableReadOf(actualSamRecord);
        this.compareBasesField("Reads didn't match", eRead, aRead, 3);
        if (this.mappedQualitiesPreserved) {
            this.compareField("Quality didn't match", expectedSamRecord.getBaseQualityString(), actualSamRecord.getBaseQualityString(), 3);
        } else if (gobyAlignment != null) {
            int readLength = expectedSamRecord.getReadLength();
            for (Alignments.SequenceVariation seqvar : gobyAlignment.getSequenceVariationsList()) {
                String to = seqvar.getTo();
                int i = 0;
                for (char toChar : to.toCharArray()) {
                    if (toChar == '-') continue;
                    int checkPosition = expectedSamRecord.getReadNegativeStrandFlag() ? readLength - seqvar.getReadIndex() : seqvar.getReadIndex() + i - 1;
                    try {
                        String eQual = expectedSamRecord.getBaseQualityString();
                        String aQual = actualSamRecord.getBaseQualityString();
                        this.compareField("Quality at location specified by seqvar (" + checkPosition + ") doesn't match " + "e=" + eQual.substring(checkPosition, checkPosition + 1) + " " + "a=" + aQual.substring(checkPosition, checkPosition + 1), eQual.substring(checkPosition, checkPosition + 1), aQual.substring(checkPosition, checkPosition + 1), 2);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.comparisonFailures.add("Quality at " + checkPosition + " index out of bounds.");
                    }
                    ++i;
                }
            }
        }
        ++this.readNum;
        if (!this.comparisonFailures.isEmpty()) {
            if (this.outputFailedComparisons) {
                this.dumpComparison(expectedSamRecord, actualSamRecord, gobyAlignment);
            }
            if (this.countComparisonFailures) {
                ++this.comparisonFailureCount;
            }
        }
        return this.currentComparisonScore;
    }

    @Override
    public int finished() {
        return 0;
    }

    public void dumpComparison(SAMRecord expectedSamRecord, SAMRecord actualSamRecord, Alignments.AlignmentEntry gobyAlignment) {
        this.comparisonErrorDump.setLength(0);
        this.comparisonErrorDump.append("Read Num         : ").append(this.readNum).append('\n');
        this.comparisonErrorDump.append("     ERROR(s)    : ").append(ArrayUtils.toString(this.comparisonFailures)).append('\n');
        if (gobyAlignment != null) {
            this.comparisonErrorDump.append("     g.index     : ").append(gobyAlignment.getQueryIndex()).append('\n');
            this.comparisonErrorDump.append("     g.position  : ").append(gobyAlignment.getPosition()).append('\n');
            this.comparisonErrorDump.append("     g.leftClip  : ").append(gobyAlignment.getSoftClippedBasesLeft()).append('\n');
            this.comparisonErrorDump.append("     g.leftClipQual  : ").append((Object)ByteArrayList.wrap((byte[])gobyAlignment.getSoftClippedQualityLeft().toByteArray())).append('\n');
            this.comparisonErrorDump.append("     g.rightClip : ").append(gobyAlignment.getSoftClippedBasesRight()).append('\n');
            this.comparisonErrorDump.append("     g.rightClipQual : ").append((Object)ByteArrayList.wrap((byte[])gobyAlignment.getSoftClippedQualityRight().toByteArray())).append('\n');
            this.comparisonErrorDump.append("     g.qAlignLen : ").append(gobyAlignment.getQueryAlignedLength()).append('\n');
            this.comparisonErrorDump.append("     g.tAlignLen : ").append(gobyAlignment.getTargetAlignedLength()).append('\n');
        }
        this.comparisonErrorDump.append("     readName (S): ").append(expectedSamRecord.getReadName()).append('\n');
        this.comparisonErrorDump.append("     readName (D): ").append(actualSamRecord.getReadName()).append('\n');
        if (gobyAlignment != null && gobyAlignment.hasReadName()) {
            this.comparisonErrorDump.append("     readName (G): ").append(gobyAlignment.getReadName()).append('\n');
        }
        this.comparisonErrorDump.append("     position (S): ").append(expectedSamRecord.getAlignmentStart()).append('\n');
        this.comparisonErrorDump.append("     position (D): ").append(actualSamRecord.getAlignmentStart()).append('\n');
        this.comparisonErrorDump.append("     refName  (S): ").append(expectedSamRecord.getReferenceName()).append('\n');
        this.comparisonErrorDump.append("     refName  (D): ").append(actualSamRecord.getReferenceName()).append('\n');
        this.comparisonErrorDump.append("     flags    (S): ").append(expectedSamRecord.getFlags()).append('\n');
        this.comparisonErrorDump.append("     flags    (D): ").append(actualSamRecord.getFlags()).append('\n');
        this.comparisonErrorDump.append("     mapQual  (S): ").append(expectedSamRecord.getMappingQuality()).append('\n');
        this.comparisonErrorDump.append("     mapQual  (D): ").append(actualSamRecord.getMappingQuality()).append('\n');
        this.comparisonErrorDump.append("     negStrand(S): ").append(expectedSamRecord.getReadNegativeStrandFlag()).append('\n');
        this.comparisonErrorDump.append("     negStrand(D): ").append(actualSamRecord.getReadNegativeStrandFlag()).append('\n');
        this.comparisonErrorDump.append("     cigar    (S): ").append((Object)expectedSamRecord.getCigar()).append('\n');
        this.comparisonErrorDump.append("     cigar    (D): ").append((Object)actualSamRecord.getCigar()).append('\n');
        this.comparisonErrorDump.append("     mdz      (S): ").append(expectedSamRecord.getStringAttribute("MD")).append('\n');
        this.comparisonErrorDump.append("     mdz      (D): ").append(actualSamRecord.getStringAttribute("MD")).append('\n');
        this.comparisonErrorDump.append("     mdz-c    (S): ").append(SamHelper.canonicalMdz(expectedSamRecord.getStringAttribute("MD"))).append('\n');
        this.comparisonErrorDump.append("     mdz-c    (D): ").append(SamHelper.canonicalMdz(actualSamRecord.getStringAttribute("MD"))).append('\n');
        this.comparisonErrorDump.append("     read     (S): ").append(expectedSamRecord.getReadString()).append('\n');
        this.comparisonErrorDump.append("     read     (D): ").append(actualSamRecord.getReadString()).append('\n');
        this.comparisonErrorDump.append("     qual     (S): ").append(expectedSamRecord.getBaseQualityString()).append('\n');
        this.comparisonErrorDump.append("     qual     (D): ").append(actualSamRecord.getBaseQualityString()).append('\n');
        System.out.println(this.comparisonErrorDump.toString());
    }

    private void compareField(String error, int expected, int actual, int failureScore) {
        if (expected != actual) {
            this.comparisonFailures.add(error);
            this.currentComparisonScore += failureScore;
        }
    }

    private void compareBasesField(String error, String expected, String actual, int failureScore) {
        if (!this.allowSourceNs || expected.length() != actual.length()) {
            this.compareField(error, expected, actual, failureScore);
        } else {
            int length = expected.length();
            boolean same = true;
            for (int i = 0; i < length; ++i) {
                char ebase = expected.charAt(i);
                char abase = actual.charAt(i);
                if (ebase == 'N' || ebase == abase) continue;
                same = false;
                break;
            }
            if (!same) {
                this.comparisonFailures.add(error);
                this.currentComparisonScore += failureScore;
            }
        }
    }

    private void compareField(String error, String expected, String actual, int failureScore) {
        if (!expected.equals(actual)) {
            this.comparisonFailures.add(error);
            this.currentComparisonScore += failureScore;
        }
    }

    private void compareField(String error, boolean expected, boolean actual, int failureScore) {
        if (expected != actual) {
            this.comparisonFailures.add(error);
            this.currentComparisonScore += failureScore;
        }
    }

    public String usableReadOf(SAMRecord samRecord) {
        CigarElement lastCigar;
        CigarElement firstCigar;
        if (this.softClipsPreserved) {
            return samRecord.getReadString();
        }
        int clipLeft = 0;
        int clipRight = 0;
        List eCigarElements = samRecord.getCigar().getCigarElements();
        if (!eCigarElements.isEmpty() && (firstCigar = (CigarElement)eCigarElements.get(0)).getOperator() == CigarOperator.S) {
            clipLeft = firstCigar.getLength();
        }
        if (eCigarElements.size() > 1 && (lastCigar = (CigarElement)eCigarElements.get(eCigarElements.size() - 1)).getOperator() == CigarOperator.S) {
            clipRight = lastCigar.getLength();
        }
        return samRecord.getReadString().substring(clipLeft, samRecord.getReadLength() - clipRight);
    }
}

