require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET_ROUTE_H_)) {
    eval 'sub _NET_ROUTE_H_ () {1;}' unless defined(&_NET_ROUTE_H_);
    require 'sys/queue.ph';
    require 'sys/socket.ph';
    require 'sys/types.ph';
    require 'net/if.ph';
    if(defined(&_KERNEL)) {
	require 'sys/rwlock.ph';
	require 'sys/condvar.ph';
	require 'sys/pserialize.ph';
	require 'sys/percpu.ph';
    }
    require 'sys/psref.ph';
    if(!(defined(&_KERNEL) || defined(&_STANDALONE))) {
	require 'stdbool.ph';
    }
    eval 'sub RTM_RTTUNIT () {1000000;}' unless defined(&RTM_RTTUNIT);
    eval 'sub RTTTOPRHZ {
        my($r) = @_;
	    eval q((($r) / ( &RTM_RTTUNIT /  &PR_SLOWHZ)));
    }' unless defined(&RTTTOPRHZ);
    unless(defined(&RNF_NORMAL)) {
	require 'net/radix.ph';
    }
    eval 'sub rt_mask {
        my($r) = @_;
	    eval q((( &const \'struct sockaddr\' *)(($r)-> ($rt_nodes->{rn_mask}))));
    }' unless defined(&rt_mask);
    if(defined(&_KERNEL)) {
    }
    eval 'sub rt_getkey {
        my($rt) = @_;
	    eval q({  ($rt->{_$rt_key}); });
    }' unless defined(&rt_getkey);
    eval 'sub RTF_UP () {0x1;}' unless defined(&RTF_UP);
    eval 'sub RTF_GATEWAY () {0x2;}' unless defined(&RTF_GATEWAY);
    eval 'sub RTF_HOST () {0x4;}' unless defined(&RTF_HOST);
    eval 'sub RTF_REJECT () {0x8;}' unless defined(&RTF_REJECT);
    eval 'sub RTF_DYNAMIC () {0x10;}' unless defined(&RTF_DYNAMIC);
    eval 'sub RTF_MODIFIED () {0x20;}' unless defined(&RTF_MODIFIED);
    eval 'sub RTF_DONE () {0x40;}' unless defined(&RTF_DONE);
    eval 'sub RTF_MASK () {0x80;}' unless defined(&RTF_MASK);
    eval 'sub RTF_CONNECTED () {0x100;}' unless defined(&RTF_CONNECTED);
    eval 'sub RTF_LLDATA () {0x400;}' unless defined(&RTF_LLDATA);
    eval 'sub RTF_STATIC () {0x800;}' unless defined(&RTF_STATIC);
    eval 'sub RTF_BLACKHOLE () {0x1000;}' unless defined(&RTF_BLACKHOLE);
    eval 'sub RTF_PROTO2 () {0x4000;}' unless defined(&RTF_PROTO2);
    eval 'sub RTF_PROTO1 () {0x8000;}' unless defined(&RTF_PROTO1);
    eval 'sub RTF_SRC () {0x10000;}' unless defined(&RTF_SRC);
    eval 'sub RTF_ANNOUNCE () {0x20000;}' unless defined(&RTF_ANNOUNCE);
    eval 'sub RTF_LOCAL () {0x40000;}' unless defined(&RTF_LOCAL);
    eval 'sub RTF_BROADCAST () {0x80000;}' unless defined(&RTF_BROADCAST);
    eval 'sub RTF_UPDATING () {0x100000;}' unless defined(&RTF_UPDATING);
    eval 'sub RTF_DONTCHANGEIFA () {0x200000;}' unless defined(&RTF_DONTCHANGEIFA);
    eval 'sub RTFBITS () {"\\020\\1UP\\2GATEWAY\\3HOST\\4REJECT\\5DYNAMIC\\6MODIFIED\\7DONE" "\\010MASK_PRESENT\\011CONNECTED\\012XRESOLVE\\013LLINFO\\014STATIC" "\\015BLACKHOLE\\016CLONED\\017PROTO2\\020PROTO1\\021SRC\\022ANNOUNCE" "\\023LOCAL\\024BROADCAST\\025UPDATING";}' unless defined(&RTFBITS);
    if(!defined(&_KERNEL) || !defined(&COMPAT_RTSOCK)) {
	eval 'sub __align64 () { &__aligned($sizeof{ &uint64_t});}' unless defined(&__align64);
    } else {
	eval 'sub __align64 () {1;}' unless defined(&__align64);
    }
    undef(&__align64) if defined(&__align64);
    eval 'sub RTM_VERSION () {4;}' unless defined(&RTM_VERSION);
    eval 'sub RTM_ADD () {0x1;}' unless defined(&RTM_ADD);
    eval 'sub RTM_DELETE () {0x2;}' unless defined(&RTM_DELETE);
    eval 'sub RTM_CHANGE () {0x3;}' unless defined(&RTM_CHANGE);
    eval 'sub RTM_GET () {0x4;}' unless defined(&RTM_GET);
    eval 'sub RTM_LOSING () {0x5;}' unless defined(&RTM_LOSING);
    eval 'sub RTM_REDIRECT () {0x6;}' unless defined(&RTM_REDIRECT);
    eval 'sub RTM_MISS () {0x7;}' unless defined(&RTM_MISS);
    eval 'sub RTM_LOCK () {0x8;}' unless defined(&RTM_LOCK);
    eval 'sub RTM_OLDADD () {0x9;}' unless defined(&RTM_OLDADD);
    eval 'sub RTM_OLDDEL () {0xa;}' unless defined(&RTM_OLDDEL);
    eval 'sub RTM_ONEWADDR () {0xc;}' unless defined(&RTM_ONEWADDR);
    eval 'sub RTM_ODELADDR () {0xd;}' unless defined(&RTM_ODELADDR);
    eval 'sub RTM_OOIFINFO () {0xe;}' unless defined(&RTM_OOIFINFO);
    eval 'sub RTM_OIFINFO () {0xf;}' unless defined(&RTM_OIFINFO);
    eval 'sub RTM_IFANNOUNCE () {0x10;}' unless defined(&RTM_IFANNOUNCE);
    eval 'sub RTM_IEEE80211 () {0x11;}' unless defined(&RTM_IEEE80211);
    eval 'sub RTM_SETGATE () {0x12;}' unless defined(&RTM_SETGATE);
    eval 'sub RTM_LLINFO_UPD () {0x13;}' unless defined(&RTM_LLINFO_UPD);
    eval 'sub RTM_IFINFO () {0x14;}' unless defined(&RTM_IFINFO);
    eval 'sub RTM_OCHGADDR () {0x15;}' unless defined(&RTM_OCHGADDR);
    eval 'sub RTM_NEWADDR () {0x16;}' unless defined(&RTM_NEWADDR);
    eval 'sub RTM_DELADDR () {0x17;}' unless defined(&RTM_DELADDR);
    eval 'sub RTM_CHGADDR () {0x18;}' unless defined(&RTM_CHGADDR);
    eval 'sub RO_MSGFILTER () {1;}' unless defined(&RO_MSGFILTER);
    eval 'sub RTV_MTU () {0x1;}' unless defined(&RTV_MTU);
    eval 'sub RTV_HOPCOUNT () {0x2;}' unless defined(&RTV_HOPCOUNT);
    eval 'sub RTV_EXPIRE () {0x4;}' unless defined(&RTV_EXPIRE);
    eval 'sub RTV_RPIPE () {0x8;}' unless defined(&RTV_RPIPE);
    eval 'sub RTV_SPIPE () {0x10;}' unless defined(&RTV_SPIPE);
    eval 'sub RTV_SSTHRESH () {0x20;}' unless defined(&RTV_SSTHRESH);
    eval 'sub RTV_RTT () {0x40;}' unless defined(&RTV_RTT);
    eval 'sub RTV_RTTVAR () {0x80;}' unless defined(&RTV_RTTVAR);
    eval 'sub RTVBITS () {"\\020\\1MTU\\2HOPCOUNT\\3EXPIRE\\4RECVPIPE\\5SENDPIPE" "\\6SSTHRESH\\7RTT\\010RTTVAR";}' unless defined(&RTVBITS);
    eval 'sub RTA_DST () {0x1;}' unless defined(&RTA_DST);
    eval 'sub RTA_GATEWAY () {0x2;}' unless defined(&RTA_GATEWAY);
    eval 'sub RTA_NETMASK () {0x4;}' unless defined(&RTA_NETMASK);
    eval 'sub RTA_GENMASK () {0x8;}' unless defined(&RTA_GENMASK);
    eval 'sub RTA_IFP () {0x10;}' unless defined(&RTA_IFP);
    eval 'sub RTA_IFA () {0x20;}' unless defined(&RTA_IFA);
    eval 'sub RTA_AUTHOR () {0x40;}' unless defined(&RTA_AUTHOR);
    eval 'sub RTA_BRD () {0x80;}' unless defined(&RTA_BRD);
    eval 'sub RTA_TAG () {0x100;}' unless defined(&RTA_TAG);
    eval 'sub RTABITS () {"\\020\\1DST\\2GATEWAY\\3NETMASK\\4GENMASK\\5IFP\\6IFA\\7AUTHOR" "\\010BRD\\011TAG";}' unless defined(&RTABITS);
    eval 'sub RTAX_DST () {0;}' unless defined(&RTAX_DST);
    eval 'sub RTAX_GATEWAY () {1;}' unless defined(&RTAX_GATEWAY);
    eval 'sub RTAX_NETMASK () {2;}' unless defined(&RTAX_NETMASK);
    eval 'sub RTAX_GENMASK () {3;}' unless defined(&RTAX_GENMASK);
    eval 'sub RTAX_IFP () {4;}' unless defined(&RTAX_IFP);
    eval 'sub RTAX_IFA () {5;}' unless defined(&RTAX_IFA);
    eval 'sub RTAX_AUTHOR () {6;}' unless defined(&RTAX_AUTHOR);
    eval 'sub RTAX_BRD () {7;}' unless defined(&RTAX_BRD);
    eval 'sub RTAX_TAG () {8;}' unless defined(&RTAX_TAG);
    eval 'sub RTAX_MAX () {9;}' unless defined(&RTAX_MAX);
    eval 'sub RT_ROUNDUP2 {
        my($a, $n) = @_;
	    eval q((($a) > 0? (1+ ((($a) - 1) | (($n) - 1))) : ($n)));
    }' unless defined(&RT_ROUNDUP2);
    eval 'sub RT_ROUNDUP {
        my($a) = @_;
	    eval q( &RT_ROUNDUP2(($a), $sizeof{ &uint64_t}));
    }' unless defined(&RT_ROUNDUP);
    eval 'sub RT_ADVANCE {
        my($x, $n) = @_;
	    eval q(($x +=  &RT_ROUNDUP(($n)-> &sa_len)));
    }' unless defined(&RT_ADVANCE);
    if(defined(&_KERNEL)) {
	if(0) {
	    eval 'sub RT_DPRINTF () {( &__fmt, ...)  &do { }  &while ( 0);}' unless defined(&RT_DPRINTF);
	} else {
	    eval 'sub RT_DPRINTF () {( &__fmt, ...);}' unless defined(&RT_DPRINTF);
	}
	eval 'sub rt_assert_referenced {
	    my($rt) = @_;
    	    eval q({  &KASSERT( ($rt->{rt_refcnt}) > 0); });
	}' unless defined(&rt_assert_referenced);
	eval 'sub rtcache_invariants {
	    my($ro) = @_;
    	    eval q({  &KASSERT( ($ro->{ro_sa}) !=  &NULL ||  ($ro->{_$ro_rt}) ==  &NULL); });
	}' unless defined(&rtcache_invariants);
	eval 'sub rtcache_lookup1 {
	    my($ro,$dst,$clone) = @_;
    	    eval q({ \'int\'  &hit;  &rtcache_lookup2($ro, $dst, $clone,  &hit); });
	}' unless defined(&rtcache_lookup1);
	eval 'sub rtcache_lookup {
	    my($ro,$dst) = @_;
    	    eval q({  &rtcache_lookup1($ro, $dst, 1); });
	}' unless defined(&rtcache_lookup);
	eval 'sub rtcache_getdst {
	    my($ro) = @_;
    	    eval q({  &rtcache_invariants($ro);  ($ro->{ro_sa}); });
	}' unless defined(&rtcache_getdst);
	eval 'sub rtcache_percpu_getref {
	    my($pc) = @_;
    	    eval q({ * &percpu_getref($pc); });
	}' unless defined(&rtcache_percpu_getref);
	eval 'sub rtcache_percpu_putref {
	    my($pc) = @_;
    	    eval q({  &percpu_putref($pc); });
	}' unless defined(&rtcache_percpu_putref);
    }
}
1;
