'\"
'\" Generated from file 'pt_pexpression\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt::pe" n 1\&.0\&.1 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt::pe \- Parsing Expression Serialization
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::pe  ?1\&.0\&.1?\fR
.sp
package require \fBchar \fR
.sp
\fB::pt::pe\fR \fBverify\fR \fIserial\fR ?\fIcanonvar\fR?
.sp
\fB::pt::pe\fR \fBverify-as-canonical\fR \fIserial\fR
.sp
\fB::pt::pe\fR \fBcanonicalize\fR \fIserial\fR
.sp
\fB::pt::pe\fR \fBprint\fR \fIserial\fR
.sp
\fB::pt::pe\fR \fBbottomup\fR \fIcmdprefix\fR \fIpe\fR
.sp
\fBcmdprefix\fR \fIpe\fR \fIop\fR \fIarguments\fR
.sp
\fB::pt::pe\fR \fBtopdown\fR \fIcmdprefix\fR \fIpe\fR
.sp
\fB::pt::pe\fR \fBequal\fR \fIseriala\fR \fIserialb\fR
.sp
\fB::pt::pe\fR \fBepsilon\fR
.sp
\fB::pt::pe\fR \fBdot\fR
.sp
\fB::pt::pe\fR \fBalnum\fR
.sp
\fB::pt::pe\fR \fBalpha\fR
.sp
\fB::pt::pe\fR \fBascii\fR
.sp
\fB::pt::pe\fR \fBcontrol\fR
.sp
\fB::pt::pe\fR \fBdigit\fR
.sp
\fB::pt::pe\fR \fBgraph\fR
.sp
\fB::pt::pe\fR \fBlower\fR
.sp
\fB::pt::pe\fR \fBprint\fR
.sp
\fB::pt::pe\fR \fBpunct\fR
.sp
\fB::pt::pe\fR \fBspace\fR
.sp
\fB::pt::pe\fR \fBupper\fR
.sp
\fB::pt::pe\fR \fBwordchar\fR
.sp
\fB::pt::pe\fR \fBxdigit\fR
.sp
\fB::pt::pe\fR \fBddigit\fR
.sp
\fB::pt::pe\fR \fBterminal\fR \fIt\fR
.sp
\fB::pt::pe\fR \fBrange\fR \fIta\fR \fItb\fR
.sp
\fB::pt::pe\fR \fBnonterminal\fR \fInt\fR
.sp
\fB::pt::pe\fR \fBchoice\fR \fIpe\fR\&.\&.\&.
.sp
\fB::pt::pe\fR \fBsequence\fR \fIpe\fR\&.\&.\&.
.sp
\fB::pt::pe\fR \fBrepeat0\fR \fIpe\fR
.sp
\fB::pt::pe\fR \fBrepeat1\fR \fIpe\fR
.sp
\fB::pt::pe\fR \fBoptional\fR \fIpe\fR
.sp
\fB::pt::pe\fR \fBahead\fR \fIpe\fR
.sp
\fB::pt::pe\fR \fBnotahead\fR \fIpe\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package provides commands to work with the serializations of
parsing expressions as managed by the Parser Tools, and specified in
section \fBPE serialization format\fR\&.
.PP
This is a supporting package in the Core Layer of Parser Tools\&.
.PP
IMAGE: arch_core_support
.PP
.SH API
.TP
\fB::pt::pe\fR \fBverify\fR \fIserial\fR ?\fIcanonvar\fR?
This command verifies that the content of \fIserial\fR is a valid
serialization of a parsing expression and will throw an error if that
is not the case\&. The result of the command is the empty string\&.
.sp
If the argument \fIcanonvar\fR is specified it is interpreted as the
name of a variable in the calling context\&. This variable will be
written to if and only if \fIserial\fR is a valid regular
serialization\&. Its value will be a boolean, with \fBTrue\fR
indicating that the serialization is not only valid, but also
\fIcanonical\fR\&. \fBFalse\fR will be written for a valid, but
non-canonical serialization\&.
.sp
For the specification of serializations see the section
\fBPE serialization format\fR\&.
.TP
\fB::pt::pe\fR \fBverify-as-canonical\fR \fIserial\fR
This command verifies that the content of \fIserial\fR is a valid
\fIcanonical\fR serialization of a parsing expression and will throw
an error if that is not the case\&. The result of the command is the
empty string\&.
.sp
For the specification of canonical serializations see the section
\fBPE serialization format\fR\&.
.TP
\fB::pt::pe\fR \fBcanonicalize\fR \fIserial\fR
This command assumes that the content of \fIserial\fR is a valid
\fIregular\fR serialization of a parsing expression and will throw an
error if that is not the case\&.
.sp
It will then convert the input into the \fIcanonical\fR serialization
of this parsing expression and return it as its result\&. If the input
is already canonical it will be returned unchanged\&.
.sp
For the specification of regular and canonical serializations see the
section \fBPE serialization format\fR\&.
.TP
\fB::pt::pe\fR \fBprint\fR \fIserial\fR
This command assumes that the argument \fIserial\fR contains a valid
serialization of a parsing expression and returns a string containing
that PE in a human readable form\&.
.sp
The exact format of this form is not specified and cannot be relied on
for parsing or other machine-based activities\&.
.sp
For the specification of serializations see the section
\fBPE serialization format\fR\&.
.TP
\fB::pt::pe\fR \fBbottomup\fR \fIcmdprefix\fR \fIpe\fR
This command walks the parsing expression \fIpe\fR from the bottom up
to the root, invoking the command prefix \fIcmdprefix\fR for each
partial expression\&. This implies that the children of a parsing
expression PE are handled before PE\&.
.sp
The command prefix has the signature
.RS
.TP
\fBcmdprefix\fR \fIpe\fR \fIop\fR \fIarguments\fR
I\&.e\&. it is invoked with the parsing expression \fIpe\fR the walk is
currently at, the \fIop\fR'erator in the \fIpe\fR, and the operator's
\fIarguments\fR\&.
.sp
The result returned by the command prefix replaces \fIpe\fR in the
parsing expression it was a child of, allowing transformations of the
expression tree\&.
.sp
This also means that for all inner parsing expressions the contents of
\fIarguments\fR are the results of the command prefix invoked for the
children of this inner parsing expression\&.
.RE
.TP
\fB::pt::pe\fR \fBtopdown\fR \fIcmdprefix\fR \fIpe\fR
This command walks the parsing expression \fIpe\fR from the root down
to the leaves, invoking the command prefix \fIcmdprefix\fR for each
partial expression\&. This implies that the children of a parsing
expression PE are handled after PE\&.
.sp
The command prefix has the same signature as for \fBbottomup\fR,
see above\&.
.sp
The result returned by the command prefix is \fIignored\fR\&.
.TP
\fB::pt::pe\fR \fBequal\fR \fIseriala\fR \fIserialb\fR
This command tests the two parsing expressions \fIseriala\fR and
\fIserialb\fR for structural equality\&. The result of the command is a
boolean value\&. It will be set to \fBtrue\fR if the expressions are
identical, and \fBfalse\fR otherwise\&.
.sp
String equality is usable only if we can assume that the two parsing
expressions are pure Tcl lists\&.
.TP
\fB::pt::pe\fR \fBepsilon\fR
This command constructs the atomic parsing expression for epsilon\&.
.TP
\fB::pt::pe\fR \fBdot\fR
This command constructs the atomic parsing expression for dot\&.
.TP
\fB::pt::pe\fR \fBalnum\fR
This command constructs the atomic parsing expression for alnum\&.
.TP
\fB::pt::pe\fR \fBalpha\fR
This command constructs the atomic parsing expression for alpha\&.
.TP
\fB::pt::pe\fR \fBascii\fR
This command constructs the atomic parsing expression for ascii\&.
.TP
\fB::pt::pe\fR \fBcontrol\fR
This command constructs the atomic parsing expression for control\&.
.TP
\fB::pt::pe\fR \fBdigit\fR
This command constructs the atomic parsing expression for digit\&.
.TP
\fB::pt::pe\fR \fBgraph\fR
This command constructs the atomic parsing expression for graph\&.
.TP
\fB::pt::pe\fR \fBlower\fR
This command constructs the atomic parsing expression for lower\&.
.TP
\fB::pt::pe\fR \fBprint\fR
This command constructs the atomic parsing expression for print\&.
.TP
\fB::pt::pe\fR \fBpunct\fR
This command constructs the atomic parsing expression for punct\&.
.TP
\fB::pt::pe\fR \fBspace\fR
This command constructs the atomic parsing expression for space\&.
.TP
\fB::pt::pe\fR \fBupper\fR
This command constructs the atomic parsing expression for upper\&.
.TP
\fB::pt::pe\fR \fBwordchar\fR
This command constructs the atomic parsing expression for wordchar\&.
.TP
\fB::pt::pe\fR \fBxdigit\fR
This command constructs the atomic parsing expression for xdigit\&.
.TP
\fB::pt::pe\fR \fBddigit\fR
This command constructs the atomic parsing expression for ddigit\&.
.TP
\fB::pt::pe\fR \fBterminal\fR \fIt\fR
This command constructs the atomic parsing expression for the terminal
symbol \fIt\fR\&.
.TP
\fB::pt::pe\fR \fBrange\fR \fIta\fR \fItb\fR
This command constructs the atomic parsing expression for the range of
terminal symbols \fIta\fR \&.\&.\&. \fItb\fR\&.
.TP
\fB::pt::pe\fR \fBnonterminal\fR \fInt\fR
This command constructs the atomic parsing expression for the
nonterminal symbol \fInt\fR\&.
.TP
\fB::pt::pe\fR \fBchoice\fR \fIpe\fR\&.\&.\&.
This command constructs the parsing expression representing the
ordered or prioritized choice between the argument parsing
expressions\&. The first argument has the highest priority\&.
.TP
\fB::pt::pe\fR \fBsequence\fR \fIpe\fR\&.\&.\&.
This command constructs the parsing expression representing the
sequence of the argument parsing expression\&. The first argument is the
first element of the sequence\&.
.TP
\fB::pt::pe\fR \fBrepeat0\fR \fIpe\fR
This command constructs the parsing expression representing the zero
or more repetition of the argument parsing expression \fIpe\fR, also
known as the kleene closure\&.
.TP
\fB::pt::pe\fR \fBrepeat1\fR \fIpe\fR
This command constructs the parsing expression representing the one or
more repetition of the argument parsing expression \fIpe\fR, also
known as the positive kleene closure\&.
.TP
\fB::pt::pe\fR \fBoptional\fR \fIpe\fR
This command constructs the parsing expression representing the
optionality of the argument parsing expression \fIpe\fR\&.
.TP
\fB::pt::pe\fR \fBahead\fR \fIpe\fR
This command constructs the parsing expression representing the
positive lookahead of the argument parsing expression \fIpe\fR\&.
.TP
\fB::pt::pe\fR \fBnotahead\fR \fIpe\fR
This command constructs the parsing expression representing the
negative lookahead of the argument parsing expression \fIpe\fR\&.
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression\&. It matches
the empty string\&.
.IP [2]
The string \fBdot\fR is an atomic parsing expression\&. It matches
any character\&.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression\&. It matches
any Unicode alphabet or digit character\&. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression\&. It matches
any Unicode alphabet character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [5]
The string \fBascii\fR is an atomic parsing expression\&. It matches
any Unicode character below U0080\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression\&. It matches
any Unicode control character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression\&. It matches
any Unicode digit character\&. Note that this includes characters
outside of the [0\&.\&.9] range\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression\&. It matches
any Unicode printing character, except for space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [9]
The string \fBlower\fR is an atomic parsing expression\&. It matches
any Unicode lower-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [10]
The string \fBprint\fR is an atomic parsing expression\&. It matches
any Unicode printing character, including space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression\&. It matches
any Unicode punctuation character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [12]
The string \fBspace\fR is an atomic parsing expression\&. It matches
any Unicode space character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [13]
The string \fBupper\fR is an atomic parsing expression\&. It matches
any Unicode upper-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression\&. It
matches any Unicode word character\&. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e\&.g\&.
underscore)\&. This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR\&.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression\&. It matches
any hexadecimal digit character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression\&. It matches
any decimal digit character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR\&.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression\&. It matches the terminal string \fBx\fR\&.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression\&. It matches the nonterminal \fBA\fR\&.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list / \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR\&.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list x \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIsequence\fR\&.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well\&.
This is the \fIkleene closure\fR, describing zero or more
repetitions\&.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well\&.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions\&.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well\&.
This is the \fIand lookahead predicate\fR\&.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well\&.
This is the \fInot lookahead predicate\fR\&.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well\&.
This is the \fIoptional input\fR\&.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression\&.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list\&. I\&.e\&. it does not contain superfluous whitespace\&.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical)\&.
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.CS


    Expression <- Term (AddOp Term)*

.CE
.PP
then its canonical serialization (except for whitespace) is
.PP
.CS


    {x {n Term} {* {x {n AddOp} {n Term}}}}

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
