require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_LFS_LFS_H_)) {
    eval 'sub _UFS_LFS_LFS_H_ () {1;}' unless defined(&_UFS_LFS_LFS_H_);
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'stddef.ph';
    }
    require 'sys/rwlock.ph';
    require 'sys/mutex.ph';
    require 'sys/queue.ph';
    require 'sys/condvar.ph';
    require 'sys/mount.ph';
    require 'sys/pool.ph';
    eval 'sub LFS_IFIND_RETRIES () {16;}' unless defined(&LFS_IFIND_RETRIES);
    eval 'sub LFS_LOGLENGTH () {1024;}' unless defined(&LFS_LOGLENGTH);
    eval 'sub LFS_MAX_ACTIVE () {10;}' unless defined(&LFS_MAX_ACTIVE);
    eval 'sub LFS_LABELPAD () {8192;}' unless defined(&LFS_LABELPAD);
    eval 'sub LFS_SBPAD () {8192;}' unless defined(&LFS_SBPAD);
    eval 'sub LFS_UNUSED_INUM () {0;}' unless defined(&LFS_UNUSED_INUM);
    eval 'sub LFS_IFILE_INUM () {1;}' unless defined(&LFS_IFILE_INUM);
    eval 'sub LFS_LOSTFOUNDINO () {3;}' unless defined(&LFS_LOSTFOUNDINO);
    eval 'sub LFS_FIRST_INUM () {4;}' unless defined(&LFS_FIRST_INUM);
    eval 'sub ULFS_ROOTINO () {(( &ino_t)2);}' unless defined(&ULFS_ROOTINO);
    eval 'sub ULFS_WINO () {(( &ino_t)1);}' unless defined(&ULFS_WINO);
    eval 'sub LFS_V1_SUMMARY_SIZE () {512;}' unless defined(&LFS_V1_SUMMARY_SIZE);
    eval 'sub LFS_DFL_SUMMARY_SIZE () {512;}' unless defined(&LFS_DFL_SUMMARY_SIZE);
    eval 'sub LFS_MAXNAMLEN () {255;}' unless defined(&LFS_MAXNAMLEN);
    eval 'sub ULFS_NXADDR () {2;}' unless defined(&ULFS_NXADDR);
    eval 'sub ULFS_NDADDR () {12;}' unless defined(&ULFS_NDADDR);
    eval 'sub ULFS_NIADDR () {3;}' unless defined(&ULFS_NIADDR);
    unless(defined(&LFS_ATIME_IFILE)) {
	eval 'sub LFS_ATIME_IFILE () {0;}' unless defined(&LFS_ATIME_IFILE);
    }
    eval 'sub LFS_MARKV_MAXBLKCNT () {65536;}' unless defined(&LFS_MARKV_MAXBLKCNT);
    undef(&LFS_DIRBLKSIZ) if defined(&LFS_DIRBLKSIZ);
    eval 'sub LFS_DIRBLKSIZ () { &DEV_BSIZE;}' unless defined(&LFS_DIRBLKSIZ);
    eval 'sub LFS_IFTODT {
        my($mode) = @_;
	    eval q(((($mode) & 0170000) >> 12));
    }' unless defined(&LFS_IFTODT);
    eval 'sub LFS_DTTOIF {
        my($dirtype) = @_;
	    eval q((($dirtype) << 12));
    }' unless defined(&LFS_DTTOIF);
    eval 'sub doff_t () { &int32_t;}' unless defined(&doff_t);
    eval 'sub lfs_doff_t () { &int32_t;}' unless defined(&lfs_doff_t);
    eval 'sub LFS_MAXDIRSIZE () {(0x7fffffff);}' unless defined(&LFS_MAXDIRSIZE);
    eval 'sub LFS_DT_UNKNOWN () {0;}' unless defined(&LFS_DT_UNKNOWN);
    eval 'sub LFS_DT_FIFO () {1;}' unless defined(&LFS_DT_FIFO);
    eval 'sub LFS_DT_CHR () {2;}' unless defined(&LFS_DT_CHR);
    eval 'sub LFS_DT_DIR () {4;}' unless defined(&LFS_DT_DIR);
    eval 'sub LFS_DT_BLK () {6;}' unless defined(&LFS_DT_BLK);
    eval 'sub LFS_DT_REG () {8;}' unless defined(&LFS_DT_REG);
    eval 'sub LFS_DT_LNK () {10;}' unless defined(&LFS_DT_LNK);
    eval 'sub LFS_DT_SOCK () {12;}' unless defined(&LFS_DT_SOCK);
    eval 'sub LFS_DT_WHT () {14;}' unless defined(&LFS_DT_WHT);
    if(0) {
    }
    eval 'sub di_rdev () { $di_db[0];}' unless defined(&di_rdev);
    eval 'sub LFS_IFMT () {0170000;}' unless defined(&LFS_IFMT);
    eval 'sub LFS_IFIFO () {0010000;}' unless defined(&LFS_IFIFO);
    eval 'sub LFS_IFCHR () {0020000;}' unless defined(&LFS_IFCHR);
    eval 'sub LFS_IFDIR () {0040000;}' unless defined(&LFS_IFDIR);
    eval 'sub LFS_IFBLK () {0060000;}' unless defined(&LFS_IFBLK);
    eval 'sub LFS_IFREG () {0100000;}' unless defined(&LFS_IFREG);
    eval 'sub LFS_IFLNK () {0120000;}' unless defined(&LFS_IFLNK);
    eval 'sub LFS_IFSOCK () {0140000;}' unless defined(&LFS_IFSOCK);
    eval 'sub LFS_IFWHT () {0160000;}' unless defined(&LFS_IFWHT);
    eval 'sub UNASSIGNED () {-1;}' unless defined(&UNASSIGNED);
    eval 'sub UNWRITTEN () {-2;}' unless defined(&UNWRITTEN);
    eval 'sub LFS_UNUSED_LBN () {-1;}' unless defined(&LFS_UNUSED_LBN);
    eval 'sub SEGUSE_ACTIVE () {0x1;}' unless defined(&SEGUSE_ACTIVE);
    eval 'sub SEGUSE_DIRTY () {0x2;}' unless defined(&SEGUSE_DIRTY);
    eval 'sub SEGUSE_SUPERBLOCK () {0x4;}' unless defined(&SEGUSE_SUPERBLOCK);
    eval 'sub SEGUSE_ERROR () {0x8;}' unless defined(&SEGUSE_ERROR);
    eval 'sub SEGUSE_EMPTY () {0x10;}' unless defined(&SEGUSE_EMPTY);
    eval 'sub SEGUSE_INVAL () {0x20;}' unless defined(&SEGUSE_INVAL);
    eval 'sub LFS_UNUSED_DADDR () {0;}' unless defined(&LFS_UNUSED_DADDR);
    eval 'sub LFS_ORPHAN_NEXTFREE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? ~( &uint64_t)0: ~( &uint32_t)0));
    }' unless defined(&LFS_ORPHAN_NEXTFREE);
    if((defined(&LFS_ATIME_IFILE) ? &LFS_ATIME_IFILE : undef)) {
	die("this cannot work");
    }
    eval 'sub LFS_CLEANER_MUST_CLEAN () {0x1;}' unless defined(&LFS_CLEANER_MUST_CLEAN);
    eval 'sub SS_MAGIC () {0x61561;}' unless defined(&SS_MAGIC);
    eval 'sub SS_DIROP () {0x1;}' unless defined(&SS_DIROP);
    eval 'sub SS_CONT () {0x2;}' unless defined(&SS_CONT);
    eval 'sub SS_CLEAN () {0x4;}' unless defined(&SS_CLEAN);
    eval 'sub SS_RFW () {0x8;}' unless defined(&SS_RFW);
    eval 'sub SS_RECLAIM () {0x10;}' unless defined(&SS_RECLAIM);
    eval 'sub LFS_MAGIC () {0x70162;}' unless defined(&LFS_MAGIC);
    eval 'sub LFS_MAGIC_SWAPPED () {0x62010700;}' unless defined(&LFS_MAGIC_SWAPPED);
    eval 'sub LFS64_MAGIC () {(0x19620701 ^ 0xffffffff);}' unless defined(&LFS64_MAGIC);
    eval 'sub LFS64_MAGIC_SWAPPED () {(0x1076219 ^ 0xffffffff);}' unless defined(&LFS64_MAGIC_SWAPPED);
    eval 'sub LFS_VERSION () {2;}' unless defined(&LFS_VERSION);
    eval 'sub LFS_MIN_SBINTERVAL () {5;}' unless defined(&LFS_MIN_SBINTERVAL);
    eval 'sub LFS_MAXNUMSB () {10;}' unless defined(&LFS_MAXNUMSB);
    eval 'sub LFS_PF_CLEAN () {0x1;}' unless defined(&LFS_PF_CLEAN);
    eval 'sub LFS_44INODEFMT () {0;}' unless defined(&LFS_44INODEFMT);
    eval 'sub LFS_MAXINODEFMT () {0;}' unless defined(&LFS_MAXINODEFMT);
    eval 'sub LFS_NOTYET () {0x1;}' unless defined(&LFS_NOTYET);
    eval 'sub LFS_IFDIRTY () {0x2;}' unless defined(&LFS_IFDIRTY);
    eval 'sub LFS_WARNED () {0x4;}' unless defined(&LFS_WARNED);
    eval 'sub LFS_UNDIROP () {0x8;}' unless defined(&LFS_UNDIROP);
    eval 'sub LFS_RESHASH_WIDTH () {17;}' unless defined(&LFS_RESHASH_WIDTH);
    if(defined(&_KERNEL)) {
    }
    eval 'sub LFS_MAX_CLEANIND () {64;}' unless defined(&LFS_MAX_CLEANIND);
    if(defined(&_KERNEL)) {
    }
    eval 'sub SEGM_CKP () {0x1;}' unless defined(&SEGM_CKP);
    eval 'sub SEGM_CLEAN () {0x2;}' unless defined(&SEGM_CLEAN);
    eval 'sub SEGM_SYNC () {0x4;}' unless defined(&SEGM_SYNC);
    eval 'sub SEGM_PROT () {0x8;}' unless defined(&SEGM_PROT);
    eval 'sub SEGM_PAGEDAEMON () {0x10;}' unless defined(&SEGM_PAGEDAEMON);
    eval 'sub SEGM_WRITERD () {0x20;}' unless defined(&SEGM_WRITERD);
    eval 'sub SEGM_FORCE_CKP () {0x40;}' unless defined(&SEGM_FORCE_CKP);
    eval 'sub SEGM_RECLAIM () {0x80;}' unless defined(&SEGM_RECLAIM);
    eval 'sub SEGM_SINGLE () {0x100;}' unless defined(&SEGM_SINGLE);
    eval 'sub LFCNSEGWAITALL () { &_FCNR_FSPRIV(ord(\'L\'), 14, \'struct timeval\');}' unless defined(&LFCNSEGWAITALL);
    eval 'sub LFCNSEGWAIT () { &_FCNR_FSPRIV(ord(\'L\'), 15, \'struct timeval\');}' unless defined(&LFCNSEGWAIT);
    eval 'sub LFCNBMAPV () { &_FCNRW_FSPRIV(ord(\'L\'), 16, \'struct lfs_fcntl_markv\');}' unless defined(&LFCNBMAPV);
    eval 'sub LFCNMARKV () { &_FCNRW_FSPRIV(ord(\'L\'), 17, \'struct lfs_fcntl_markv\');}' unless defined(&LFCNMARKV);
    eval 'sub LFCNRECLAIM () { &_FCNO_FSPRIV(ord(\'L\'), 4);}' unless defined(&LFCNRECLAIM);
    eval 'sub LFCNREWIND () { &_FCNR_FSPRIV(ord(\'L\'), 6, \'int\');}' unless defined(&LFCNREWIND);
    eval 'sub LFCNINVAL () { &_FCNR_FSPRIV(ord(\'L\'), 7, \'int\');}' unless defined(&LFCNINVAL);
    eval 'sub LFCNRESIZE () { &_FCNR_FSPRIV(ord(\'L\'), 8, \'int\');}' unless defined(&LFCNRESIZE);
    eval 'sub LFCNWRAPSTOP () { &_FCNR_FSPRIV(ord(\'L\'), 9, \'int\');}' unless defined(&LFCNWRAPSTOP);
    eval 'sub LFCNWRAPGO () { &_FCNR_FSPRIV(ord(\'L\'), 10, \'int\');}' unless defined(&LFCNWRAPGO);
    eval 'sub LFCNIFILEFH () { &_FCNW_FSPRIV(ord(\'L\'), 11, \'struct lfs_fhandle\');}' unless defined(&LFCNIFILEFH);
    eval 'sub LFCNWRAPPASS () { &_FCNR_FSPRIV(ord(\'L\'), 12, \'int\');}' unless defined(&LFCNWRAPPASS);
    eval 'sub LFS_WRAP_GOING () {0x;}' unless defined(&LFS_WRAP_GOING);
    eval 'sub LFS_WRAP_WAITING () {0x1;}' unless defined(&LFS_WRAP_WAITING);
    eval 'sub LFCNWRAPSTATUS () { &_FCNW_FSPRIV(ord(\'L\'), 13, \'int\');}' unless defined(&LFCNWRAPSTATUS);
    if(defined(&notyet)) {
	eval 'sub ASSERT_SEGLOCK {
	    my($fs) = @_;
    	    eval q( &KASSERT( &LFS_SEGLOCK_HELD($fs)));
	}' unless defined(&ASSERT_SEGLOCK);
	eval 'sub ASSERT_NO_SEGLOCK {
	    my($fs) = @_;
    	    eval q( &KASSERT(! &LFS_SEGLOCK_HELD($fs)));
	}' unless defined(&ASSERT_NO_SEGLOCK);
	eval 'sub ASSERT_DUNNO_SEGLOCK {
	    my($fs) = @_;
    	    eval q();
	}' unless defined(&ASSERT_DUNNO_SEGLOCK);
	eval 'sub ASSERT_MAYBE_SEGLOCK {
	    my($fs) = @_;
    	    eval q();
	}' unless defined(&ASSERT_MAYBE_SEGLOCK);
    } else {
	eval 'sub ASSERT_DUNNO_SEGLOCK {
	    my($fs) = @_;
    	    eval q( &DLOG(( &DLOG_SEG, \\"lfs func %s seglock wrong (%d)\\\\n\\",  &__func__,  &LFS_SEGLOCK_HELD($fs))));
	}' unless defined(&ASSERT_DUNNO_SEGLOCK);
	eval 'sub ASSERT_SEGLOCK {
	    my($fs) = @_;
    	    eval q( &do {  &if (! &LFS_SEGLOCK_HELD($fs)) {  &DLOG(( &DLOG_SEG, \\"lfs func %s seglock wrong (0)\\\\n\\",  &__func__)); } }  &while(0));
	}' unless defined(&ASSERT_SEGLOCK);
	eval 'sub ASSERT_NO_SEGLOCK {
	    my($fs) = @_;
    	    eval q( &do {  &if ( &LFS_SEGLOCK_HELD($fs)) {  &DLOG(( &DLOG_SEG, \\"lfs func %s seglock wrong (1)\\\\n\\",  &__func__)); } }  &while(0));
	}' unless defined(&ASSERT_NO_SEGLOCK);
	eval 'sub ASSERT_MAYBE_SEGLOCK {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&ASSERT_MAYBE_SEGLOCK);
    }
}
1;
