package TDS::PIM::Todo;
# $Id: Todo.pm,v 1.17 2000/12/13 09:51:57 tom Exp $
################################################################

=head1 NAME

TDS::PIM::Todo - TODO list

=head1 SYNOPSIS

 use TDS::PIM::Todo;

 $t = new TDS::PIM::Todo;
 $t->Read;
 print $t->AsHTML;


=cut

################################################################

use strict;
use vars qw(@ISA
	    $MaxNum
	    $BeginTemplate $EndTemplate $ContentTemplate
	    $Delim
	    $NormalColor $EmphasisColor $StrongColor);

use FileHandle;

use Template;
use JConv;

use TDS::PIM::Base;

@ISA = qw(TDS::PIM::Base);

{
    # initialize static variables
    
    $ContentTemplate = qq(<li><span style="color: %color">%priority%delim%content</span></li>) unless defined $ContentTemplate;
    
    $Delim = ":" unless defined $Delim;
    
    $MaxNum = 8 unless defined $MaxNum;

    $NormalColor = "black" unless defined $NormalColor;
    $EmphasisColor = "red" unless defined $EmphasisColor;
    # orange is not allowed in CSS
    $StrongColor = "#090" unless defined $StrongColor;

    $BeginTemplate = "<ul>\n" unless defined $BeginTemplate;
    $EndTemplate = "</ul>\n" unless defined $EndTemplate;
}

attributes qw();

################################################################

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;
    
    $self->cache_basename("todo");

    $self->SUPER::initialize;
}
sub AddContentByLine($$)
{
    my ($self, $line) = @_;
    
    my ($priority, $comment) = $line =~ /^(\d+)\s(.*)$/;
    $self->AddContent({priority=>$priority,
		       comment=>$comment});
}

################################################################
sub AsContentHTML($)
{
    my $self = shift;

    my $cnt = 0;
    my $html;
    $html = $BeginTemplate;
    for (sort {$b->{priority} <=> $a->{priority}} @{$self->content}){
	my $params;
	my $pri = $_->{priority};
	$params->{priority} = $pri;
	$params->{color} = ($pri>=90) ? $EmphasisColor :
	    ($pri>=80) ? $StrongColor : $NormalColor;
	$params->{content} = $_->{comment};
	$params->{delim} = $Delim;
	$html .= Expand($ContentTemplate, $params);
	$cnt++;
	last if $cnt >= $MaxNum;
    }
    $html .= $EndTemplate;
    
    return $html;
}

1;
