/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int begin;
    private int end;
    private int index;

    public final char current() {
        return this.index < this.end ? this.text.charAt(this.index) : (char)-1;
    }

    public final char next() {
        if (this.index == this.end) {
            return (char)-1;
        }
        ++this.index;
        return this.current();
    }

    public final char previous() {
        if (this.index == this.begin) {
            return (char)-1;
        }
        --this.index;
        return this.current();
    }

    public final char first() {
        this.index = this.begin;
        return this.current();
    }

    public final char last() {
        if (this.end == this.begin) {
            return (char)-1;
        }
        this.index = this.end - 1;
        return this.current();
    }

    public final int getIndex() {
        return this.index;
    }

    public final char setIndex(int index) {
        if (index < this.begin || index > this.end) {
            throw new IllegalArgumentException("Bad index specified");
        }
        this.index = index;
        return this.current();
    }

    public final int getBeginIndex() {
        return this.begin;
    }

    public final int getEndIndex() {
        return this.end;
    }

    public final Object clone() {
        return new StringCharacterIterator(this.text, this.begin, this.end, this.index);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator sci = (StringCharacterIterator)obj;
        boolean bl = false;
        if (this.begin == sci.begin && this.end == sci.end && this.index == sci.index && this.text.equals(sci.text)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.begin ^ this.end ^ this.index ^ this.text.hashCode();
    }

    public final void setText(String text) {
        this.text = text;
        this.begin = 0;
        this.end = text.length();
        this.index = 0;
    }

    public StringCharacterIterator(String text) {
        this(text, 0, text.length(), 0);
    }

    public StringCharacterIterator(String text, int index) {
        this(text, 0, text.length(), index);
    }

    public StringCharacterIterator(String text, int begin, int end, int index) {
        int len = text.length();
        if (begin < 0 || begin > len) {
            throw new IllegalArgumentException("Bad begin position");
        }
        if (end < begin || end > len) {
            throw new IllegalArgumentException("Bad end position");
        }
        if (index < begin || index > end) {
            throw new IllegalArgumentException("Bad initial index position");
        }
        this.text = text;
        this.begin = begin;
        this.end = end;
        this.index = index;
    }

    StringCharacterIterator(StringCharacterIterator sci, int begin, int end) {
        this(sci.text, begin, end, begin);
    }
}

