require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARMREG_H)) {
    eval 'sub _ARM_ARMREG_H () {1;}' unless defined(&_ARM_ARMREG_H);
    require 'arm/cputypes.ph';
    if(defined(&__arm__)) {
	eval 'sub PSR_FLAGS () {0xf0000000;}' unless defined(&PSR_FLAGS);
	eval 'sub PSR_N_bit () {(1<< 31);}' unless defined(&PSR_N_bit);
	eval 'sub PSR_Z_bit () {(1<< 30);}' unless defined(&PSR_Z_bit);
	eval 'sub PSR_C_bit () {(1<< 29);}' unless defined(&PSR_C_bit);
	eval 'sub PSR_V_bit () {(1<< 28);}' unless defined(&PSR_V_bit);
	eval 'sub PSR_Q_bit () {(1<< 27);}' unless defined(&PSR_Q_bit);
	eval 'sub PSR_IT1_bit () {(1<< 26);}' unless defined(&PSR_IT1_bit);
	eval 'sub PSR_IT0_bit () {(1<< 25);}' unless defined(&PSR_IT0_bit);
	eval 'sub PSR_J_bit () {(1<< 24);}' unless defined(&PSR_J_bit);
	eval 'sub PSR_GE_bits () {(15<< 16);}' unless defined(&PSR_GE_bits);
	eval 'sub PSR_IT7_bit () {(1<< 15);}' unless defined(&PSR_IT7_bit);
	eval 'sub PSR_IT6_bit () {(1<< 14);}' unless defined(&PSR_IT6_bit);
	eval 'sub PSR_IT5_bit () {(1<< 13);}' unless defined(&PSR_IT5_bit);
	eval 'sub PSR_IT4_bit () {(1<< 12);}' unless defined(&PSR_IT4_bit);
	eval 'sub PSR_IT3_bit () {(1<< 11);}' unless defined(&PSR_IT3_bit);
	eval 'sub PSR_IT2_bit () {(1<< 10);}' unless defined(&PSR_IT2_bit);
	eval 'sub PSR_E_BIT () {(1<< 9);}' unless defined(&PSR_E_BIT);
	eval 'sub PSR_A_BIT () {(1<< 8);}' unless defined(&PSR_A_BIT);
	eval 'sub I32_bit () {(1<< 7);}' unless defined(&I32_bit);
	eval 'sub F32_bit () {(1<< 6);}' unless defined(&F32_bit);
	eval 'sub IF32_bits () {(3<< 6);}' unless defined(&IF32_bits);
	eval 'sub PSR_T_bit () {(1<< 5);}' unless defined(&PSR_T_bit);
	eval 'sub PSR_MODE () {0x1f;}' unless defined(&PSR_MODE);
	eval 'sub PSR_USR32_MODE () {0x10;}' unless defined(&PSR_USR32_MODE);
	eval 'sub PSR_FIQ32_MODE () {0x11;}' unless defined(&PSR_FIQ32_MODE);
	eval 'sub PSR_IRQ32_MODE () {0x12;}' unless defined(&PSR_IRQ32_MODE);
	eval 'sub PSR_SVC32_MODE () {0x13;}' unless defined(&PSR_SVC32_MODE);
	eval 'sub PSR_MON32_MODE () {0x16;}' unless defined(&PSR_MON32_MODE);
	eval 'sub PSR_ABT32_MODE () {0x17;}' unless defined(&PSR_ABT32_MODE);
	eval 'sub PSR_HYP32_MODE () {0x1a;}' unless defined(&PSR_HYP32_MODE);
	eval 'sub PSR_UND32_MODE () {0x1b;}' unless defined(&PSR_UND32_MODE);
	eval 'sub PSR_SYS32_MODE () {0x1f;}' unless defined(&PSR_SYS32_MODE);
	eval 'sub PSR_32_MODE () {0x10;}' unless defined(&PSR_32_MODE);
	eval 'sub R15_FLAGS () {0xf0000000;}' unless defined(&R15_FLAGS);
	eval 'sub R15_FLAG_N () {0x80000000;}' unless defined(&R15_FLAG_N);
	eval 'sub R15_FLAG_Z () {0x40000000;}' unless defined(&R15_FLAG_Z);
	eval 'sub R15_FLAG_C () {0x20000000;}' unless defined(&R15_FLAG_C);
	eval 'sub R15_FLAG_V () {0x10000000;}' unless defined(&R15_FLAG_V);
	eval 'sub ARM_CP15_CPU_ID () {0;}' unless defined(&ARM_CP15_CPU_ID);
	eval 'sub ARM_ISA3_SYNCHPRIM_MASK () {0xf000;}' unless defined(&ARM_ISA3_SYNCHPRIM_MASK);
	eval 'sub ARM_ISA4_SYNCHPRIM_MASK () {0xf00000;}' unless defined(&ARM_ISA4_SYNCHPRIM_MASK);
	eval 'sub ARM_ISA3_SYNCHPRIM_LDREX () {0x10;}' unless defined(&ARM_ISA3_SYNCHPRIM_LDREX);
	eval 'sub ARM_ISA3_SYNCHPRIM_LDREXPLUS () {0x13;}' unless defined(&ARM_ISA3_SYNCHPRIM_LDREXPLUS);
	eval 'sub ARM_ISA3_SYNCHPRIM_LDREXD () {0x20;}' unless defined(&ARM_ISA3_SYNCHPRIM_LDREXD);
	eval 'sub ARM_PFR0_THUMBEE_MASK () {0xf000;}' unless defined(&ARM_PFR0_THUMBEE_MASK);
	eval 'sub ARM_PFR1_GTIMER_MASK () {0xf0000;}' unless defined(&ARM_PFR1_GTIMER_MASK);
	eval 'sub ARM_PFR1_VIRT_MASK () {0xf000;}' unless defined(&ARM_PFR1_VIRT_MASK);
	eval 'sub ARM_PFR1_SEC_MASK () {0xf0;}' unless defined(&ARM_PFR1_SEC_MASK);
	eval 'sub ARM_MVFR0_ROUNDING_MASK () {0xf0000000;}' unless defined(&ARM_MVFR0_ROUNDING_MASK);
	eval 'sub ARM_MVFR0_SHORTVEC_MASK () {0xf000000;}' unless defined(&ARM_MVFR0_SHORTVEC_MASK);
	eval 'sub ARM_MVFR0_SQRT_MASK () {0xf00000;}' unless defined(&ARM_MVFR0_SQRT_MASK);
	eval 'sub ARM_MVFR0_DIVIDE_MASK () {0xf0000;}' unless defined(&ARM_MVFR0_DIVIDE_MASK);
	eval 'sub ARM_MVFR0_EXCEPT_MASK () {0xf000;}' unless defined(&ARM_MVFR0_EXCEPT_MASK);
	eval 'sub ARM_MVFR0_DFLOAT_MASK () {0xf00;}' unless defined(&ARM_MVFR0_DFLOAT_MASK);
	eval 'sub ARM_MVFR0_SFLOAT_MASK () {0xf0;}' unless defined(&ARM_MVFR0_SFLOAT_MASK);
	eval 'sub ARM_MVFR0_ASIMD_MASK () {0xf;}' unless defined(&ARM_MVFR0_ASIMD_MASK);
	eval 'sub ARM_MVFR1_ASIMD_FMACS_MASK () {0xf0000000;}' unless defined(&ARM_MVFR1_ASIMD_FMACS_MASK);
	eval 'sub ARM_MVFR1_VFP_HPFP_MASK () {0xf000000;}' unless defined(&ARM_MVFR1_VFP_HPFP_MASK);
	eval 'sub ARM_MVFR1_ASIMD_HPFP_MASK () {0xf00000;}' unless defined(&ARM_MVFR1_ASIMD_HPFP_MASK);
	eval 'sub ARM_MVFR1_ASIMD_SPFP_MASK () {0xf0000;}' unless defined(&ARM_MVFR1_ASIMD_SPFP_MASK);
	eval 'sub ARM_MVFR1_ASIMD_INT_MASK () {0xf000;}' unless defined(&ARM_MVFR1_ASIMD_INT_MASK);
	eval 'sub ARM_MVFR1_ASIMD_LDST_MASK () {0xf00;}' unless defined(&ARM_MVFR1_ASIMD_LDST_MASK);
	eval 'sub ARM_MVFR1_D_NAN_MASK () {0xf0;}' unless defined(&ARM_MVFR1_D_NAN_MASK);
	eval 'sub ARM_MVFR1_FTZ_MASK () {0xf;}' unless defined(&ARM_MVFR1_FTZ_MASK);
	eval 'sub ARM3_CP15_FLUSH () {1;}' unless defined(&ARM3_CP15_FLUSH);
	eval 'sub ARM3_CP15_CONTROL () {2;}' unless defined(&ARM3_CP15_CONTROL);
	eval 'sub ARM3_CP15_CACHEABLE () {3;}' unless defined(&ARM3_CP15_CACHEABLE);
	eval 'sub ARM3_CP15_UPDATEABLE () {4;}' unless defined(&ARM3_CP15_UPDATEABLE);
	eval 'sub ARM3_CP15_DISRUPTIVE () {5;}' unless defined(&ARM3_CP15_DISRUPTIVE);
	eval 'sub ARM3_CTL_CACHE_ON () {0x1;}' unless defined(&ARM3_CTL_CACHE_ON);
	eval 'sub ARM3_CTL_SHARED () {0x2;}' unless defined(&ARM3_CTL_SHARED);
	eval 'sub ARM3_CTL_MONITOR () {0x4;}' unless defined(&ARM3_CTL_MONITOR);
	eval 'sub CPU_CONTROL_MMU_ENABLE () {0x1;}' unless defined(&CPU_CONTROL_MMU_ENABLE);
	eval 'sub CPU_CONTROL_AFLT_ENABLE () {0x2;}' unless defined(&CPU_CONTROL_AFLT_ENABLE);
	eval 'sub CPU_CONTROL_DC_ENABLE () {0x4;}' unless defined(&CPU_CONTROL_DC_ENABLE);
	eval 'sub CPU_CONTROL_WBUF_ENABLE () {0x8;}' unless defined(&CPU_CONTROL_WBUF_ENABLE);
	eval 'sub CPU_CONTROL_32BP_ENABLE () {0x10;}' unless defined(&CPU_CONTROL_32BP_ENABLE);
	eval 'sub CPU_CONTROL_32BD_ENABLE () {0x20;}' unless defined(&CPU_CONTROL_32BD_ENABLE);
	eval 'sub CPU_CONTROL_LABT_ENABLE () {0x40;}' unless defined(&CPU_CONTROL_LABT_ENABLE);
	eval 'sub CPU_CONTROL_BEND_ENABLE () {0x80;}' unless defined(&CPU_CONTROL_BEND_ENABLE);
	eval 'sub CPU_CONTROL_SYST_ENABLE () {0x100;}' unless defined(&CPU_CONTROL_SYST_ENABLE);
	eval 'sub CPU_CONTROL_ROM_ENABLE () {0x200;}' unless defined(&CPU_CONTROL_ROM_ENABLE);
	eval 'sub CPU_CONTROL_CPCLK () {0x400;}' unless defined(&CPU_CONTROL_CPCLK);
	eval 'sub CPU_CONTROL_SWP_ENABLE () {0x400;}' unless defined(&CPU_CONTROL_SWP_ENABLE);
	eval 'sub CPU_CONTROL_BPRD_ENABLE () {0x800;}' unless defined(&CPU_CONTROL_BPRD_ENABLE);
	eval 'sub CPU_CONTROL_IC_ENABLE () {0x1000;}' unless defined(&CPU_CONTROL_IC_ENABLE);
	eval 'sub CPU_CONTROL_VECRELOC () {0x2000;}' unless defined(&CPU_CONTROL_VECRELOC);
	eval 'sub CPU_CONTROL_ROUNDROBIN () {0x4000;}' unless defined(&CPU_CONTROL_ROUNDROBIN);
	eval 'sub CPU_CONTROL_V4COMPAT () {0x8000;}' unless defined(&CPU_CONTROL_V4COMPAT);
	eval 'sub CPU_CONTROL_HA_ENABLE () {0x20000;}' unless defined(&CPU_CONTROL_HA_ENABLE);
	eval 'sub CPU_CONTROL_WXN_ENABLE () {0x80000;}' unless defined(&CPU_CONTROL_WXN_ENABLE);
	eval 'sub CPU_CONTROL_UWXN_ENABLE () {0x100000;}' unless defined(&CPU_CONTROL_UWXN_ENABLE);
	eval 'sub CPU_CONTROL_FI_ENABLE () {0x200000;}' unless defined(&CPU_CONTROL_FI_ENABLE);
	eval 'sub CPU_CONTROL_UNAL_ENABLE () {0x400000;}' unless defined(&CPU_CONTROL_UNAL_ENABLE);
	eval 'sub CPU_CONTROL_XP_ENABLE () {0x800000;}' unless defined(&CPU_CONTROL_XP_ENABLE);
	eval 'sub CPU_CONTROL_V_ENABLE () {0x1000000;}' unless defined(&CPU_CONTROL_V_ENABLE);
	eval 'sub CPU_CONTROL_EX_BEND () {0x2000000;}' unless defined(&CPU_CONTROL_EX_BEND);
	eval 'sub CPU_CONTROL_NMFI () {0x8000000;}' unless defined(&CPU_CONTROL_NMFI);
	eval 'sub CPU_CONTROL_TR_ENABLE () {0x10000000;}' unless defined(&CPU_CONTROL_TR_ENABLE);
	eval 'sub CPU_CONTROL_AF_ENABLE () {0x20000000;}' unless defined(&CPU_CONTROL_AF_ENABLE);
	eval 'sub CPU_CONTROL_TE_ENABLE () {0x40000000;}' unless defined(&CPU_CONTROL_TE_ENABLE);
	eval 'sub CPU_CONTROL_IDC_ENABLE () { &CPU_CONTROL_DC_ENABLE;}' unless defined(&CPU_CONTROL_IDC_ENABLE);
	eval 'sub CPACR_V7_ASEDIS () {0x80000000;}' unless defined(&CPACR_V7_ASEDIS);
	eval 'sub CPACR_V7_D32DIS () {0x40000000;}' unless defined(&CPACR_V7_D32DIS);
	eval 'sub CPACR_CPn {
	    my($n) = @_;
    	    eval q((3<< (2*$n)));
	}' unless defined(&CPACR_CPn);
	eval 'sub CPACR_NOACCESS () {0;}' unless defined(&CPACR_NOACCESS);
	eval 'sub CPACR_PRIVED () {1;}' unless defined(&CPACR_PRIVED);
	eval 'sub CPACR_RESERVED () {2;}' unless defined(&CPACR_RESERVED);
	eval 'sub CPACR_ALL () {3;}' unless defined(&CPACR_ALL);
	eval 'sub NSACR_SMP () {0x40000;}' unless defined(&NSACR_SMP);
	eval 'sub NSACR_L2ERR () {0x20000;}' unless defined(&NSACR_L2ERR);
	eval 'sub NSACR_ASEDIS () {0x8000;}' unless defined(&NSACR_ASEDIS);
	eval 'sub NSACR_D32DIS () {0x4000;}' unless defined(&NSACR_D32DIS);
	eval 'sub NSACR_CPn {
	    my($n) = @_;
    	    eval q((1<< ($n)));
	}' unless defined(&NSACR_CPn);
	eval 'sub ARM11X6_AUXCTL_RS () {0x1;}' unless defined(&ARM11X6_AUXCTL_RS);
	eval 'sub ARM11X6_AUXCTL_DB () {0x2;}' unless defined(&ARM11X6_AUXCTL_DB);
	eval 'sub ARM11X6_AUXCTL_SB () {0x4;}' unless defined(&ARM11X6_AUXCTL_SB);
	eval 'sub ARM11X6_AUXCTL_TR () {0x8;}' unless defined(&ARM11X6_AUXCTL_TR);
	eval 'sub ARM11X6_AUXCTL_EX () {0x10;}' unless defined(&ARM11X6_AUXCTL_EX);
	eval 'sub ARM11X6_AUXCTL_RA () {0x20;}' unless defined(&ARM11X6_AUXCTL_RA);
	eval 'sub ARM11X6_AUXCTL_RV () {0x40;}' unless defined(&ARM11X6_AUXCTL_RV);
	eval 'sub ARM11X6_AUXCTL_CZ () {0x80;}' unless defined(&ARM11X6_AUXCTL_CZ);
	eval 'sub ARM1136_AUXCTL_PFI () {0x80000000;}' unless defined(&ARM1136_AUXCTL_PFI);
	eval 'sub ARM1176_AUXCTL_PHD () {0x10000000;}' unless defined(&ARM1176_AUXCTL_PHD);
	eval 'sub ARM1176_AUXCTL_BFD () {0x20000000;}' unless defined(&ARM1176_AUXCTL_BFD);
	eval 'sub ARM1176_AUXCTL_FSD () {0x40000000;}' unless defined(&ARM1176_AUXCTL_FSD);
	eval 'sub ARM1176_AUXCTL_FIO () {0x80000000;}' unless defined(&ARM1176_AUXCTL_FIO);
	eval 'sub XSCALE_AUXCTL_K () {0x1;}' unless defined(&XSCALE_AUXCTL_K);
	eval 'sub XSCALE_AUXCTL_P () {0x2;}' unless defined(&XSCALE_AUXCTL_P);
	eval 'sub XSCALE_AUXCTL_MD_WB_RA () {0x;}' unless defined(&XSCALE_AUXCTL_MD_WB_RA);
	eval 'sub XSCALE_AUXCTL_MD_WB_RWA () {0x10;}' unless defined(&XSCALE_AUXCTL_MD_WB_RWA);
	eval 'sub XSCALE_AUXCTL_MD_WT () {0x20;}' unless defined(&XSCALE_AUXCTL_MD_WT);
	eval 'sub XSCALE_AUXCTL_MD_MASK () {0x30;}' unless defined(&XSCALE_AUXCTL_MD_MASK);
	eval 'sub MPCORE_AUXCTL_RS () {0x1;}' unless defined(&MPCORE_AUXCTL_RS);
	eval 'sub MPCORE_AUXCTL_DB () {0x2;}' unless defined(&MPCORE_AUXCTL_DB);
	eval 'sub MPCORE_AUXCTL_SB () {0x4;}' unless defined(&MPCORE_AUXCTL_SB);
	eval 'sub MPCORE_AUXCTL_F () {0x8;}' unless defined(&MPCORE_AUXCTL_F);
	eval 'sub MPCORE_AUXCTL_EX () {0x10;}' unless defined(&MPCORE_AUXCTL_EX);
	eval 'sub MPCORE_AUXCTL_SA () {0x20;}' unless defined(&MPCORE_AUXCTL_SA);
	eval 'sub PJ4B_AUXCTL_FW () { &__BIT(0);}' unless defined(&PJ4B_AUXCTL_FW);
	eval 'sub PJ4B_AUXCTL_SMPNAMP () { &__BIT(6);}' unless defined(&PJ4B_AUXCTL_SMPNAMP);
	eval 'sub PJ4B_AUXCTL_L1PARITY () { &__BIT(9);}' unless defined(&PJ4B_AUXCTL_L1PARITY);
	eval 'sub PJ4B_AUXFMC0_L2EN () { &__BIT(0);}' unless defined(&PJ4B_AUXFMC0_L2EN);
	eval 'sub PJ4B_AUXFMC0_SMPNAMP () { &__BIT(1);}' unless defined(&PJ4B_AUXFMC0_SMPNAMP);
	eval 'sub PJ4B_AUXFMC0_L1PARITY () { &__BIT(2);}' unless defined(&PJ4B_AUXFMC0_L1PARITY);
	eval 'sub PJ4B_AUXFMC0_DCSLFD () { &__BIT(2);}' unless defined(&PJ4B_AUXFMC0_DCSLFD);
	eval 'sub PJ4B_AUXFMC0_FW () { &__BIT(8);}' unless defined(&PJ4B_AUXFMC0_FW);
	eval 'sub CORTEXA5_ACTLR_FW () { &__BIT(0);}' unless defined(&CORTEXA5_ACTLR_FW);
	eval 'sub CORTEXA5_ACTLR_SMP () { &__BIT(6);}' unless defined(&CORTEXA5_ACTLR_SMP);
	eval 'sub CORTEXA5_ACTLR_EXCL () { &__BIT(7);}' unless defined(&CORTEXA5_ACTLR_EXCL);
	eval 'sub CORTEXA7_ACTLR_L1ALIAS () { &__BIT(0);}' unless defined(&CORTEXA7_ACTLR_L1ALIAS);
	eval 'sub CORTEXA7_ACTLR_L2EN () { &__BIT(1);}' unless defined(&CORTEXA7_ACTLR_L2EN);
	eval 'sub CORTEXA7_ACTLR_SMP () { &__BIT(6);}' unless defined(&CORTEXA7_ACTLR_SMP);
	eval 'sub CORTEXA8_ACTLR_L1ALIAS () { &__BIT(0);}' unless defined(&CORTEXA8_ACTLR_L1ALIAS);
	eval 'sub CORTEXA8_ACTLR_L2EN () { &__BIT(1);}' unless defined(&CORTEXA8_ACTLR_L2EN);
	eval 'sub CORTEXA9_AUXCTL_FW () {0x1;}' unless defined(&CORTEXA9_AUXCTL_FW);
	eval 'sub CORTEXA9_AUXCTL_L2PE () {0x2;}' unless defined(&CORTEXA9_AUXCTL_L2PE);
	eval 'sub CORTEXA9_AUXCTL_L1PE () {0x4;}' unless defined(&CORTEXA9_AUXCTL_L1PE);
	eval 'sub CORTEXA9_AUXCTL_WR_ZERO () {0x8;}' unless defined(&CORTEXA9_AUXCTL_WR_ZERO);
	eval 'sub CORTEXA9_AUXCTL_SMP () {0x40;}' unless defined(&CORTEXA9_AUXCTL_SMP);
	eval 'sub CORTEXA9_AUXCTL_EXCL () {0x80;}' unless defined(&CORTEXA9_AUXCTL_EXCL);
	eval 'sub CORTEXA9_AUXCTL_ONEWAY () {0x100;}' unless defined(&CORTEXA9_AUXCTL_ONEWAY);
	eval 'sub CORTEXA9_AUXCTL_PARITY () {0x200;}' unless defined(&CORTEXA9_AUXCTL_PARITY);
	eval 'sub CORTEXA15_ACTLR_BTB () { &__BIT(0);}' unless defined(&CORTEXA15_ACTLR_BTB);
	eval 'sub CORTEXA15_ACTLR_SMP () { &__BIT(6);}' unless defined(&CORTEXA15_ACTLR_SMP);
	eval 'sub CORTEXA15_ACTLR_IOBEU () { &__BIT(15);}' unless defined(&CORTEXA15_ACTLR_IOBEU);
	eval 'sub CORTEXA15_ACTLR_SDEH () { &__BIT(31);}' unless defined(&CORTEXA15_ACTLR_SDEH);
	eval 'sub CORTEXA17_ACTLR_SMP () { &__BIT(6);}' unless defined(&CORTEXA17_ACTLR_SMP);
	eval 'sub CORTEXA17_ACTLR_ASSE () { &__BIT(3);}' unless defined(&CORTEXA17_ACTLR_ASSE);
	eval 'sub CORTEXA17_ACTLR_L2PF () { &__BIT(2);}' unless defined(&CORTEXA17_ACTLR_L2PF);
	eval 'sub CORTEXA17_ACTLR_L1PF () { &__BIT(1);}' unless defined(&CORTEXA17_ACTLR_L1PF);
	eval 'sub FC_DCACHE_REPL_LOCK () {0x80000000;}' unless defined(&FC_DCACHE_REPL_LOCK);
	eval 'sub FC_DCACHE_STREAM_EN () {0x20000000;}' unless defined(&FC_DCACHE_STREAM_EN);
	eval 'sub FC_WR_ALLOC_EN () {0x10000000;}' unless defined(&FC_WR_ALLOC_EN);
	eval 'sub FC_L2_PREF_DIS () {0x1000000;}' unless defined(&FC_L2_PREF_DIS);
	eval 'sub FC_L2_INV_EVICT_LINE () {0x800000;}' unless defined(&FC_L2_INV_EVICT_LINE);
	eval 'sub FC_L2CACHE_EN () {0x400000;}' unless defined(&FC_L2CACHE_EN);
	eval 'sub FC_ICACHE_REPL_LOCK () {0x80000;}' unless defined(&FC_ICACHE_REPL_LOCK);
	eval 'sub FC_GLOB_HIST_REG_EN () {0x40000;}' unless defined(&FC_GLOB_HIST_REG_EN);
	eval 'sub FC_BRANCH_TARG_BUF_DIS () {0x20000;}' unless defined(&FC_BRANCH_TARG_BUF_DIS);
	eval 'sub FC_L1_PAR_ERR_EN () {0x10000;}' unless defined(&FC_L1_PAR_ERR_EN);
	eval 'sub CPU_CT_FORMAT {
	    my($x) = @_;
    	    eval q(((($x) >> 29) & 0x7));
	}' unless defined(&CPU_CT_FORMAT);
	eval 'sub CPU_CT_ISIZE {
	    my($x) = @_;
    	    eval q((($x) & 0xfff));
	}' unless defined(&CPU_CT_ISIZE);
	eval 'sub CPU_CT_DSIZE {
	    my($x) = @_;
    	    eval q(((($x) >> 12) & 0xfff));
	}' unless defined(&CPU_CT_DSIZE);
	eval 'sub CPU_CT_S () {(1 << 24);}' unless defined(&CPU_CT_S);
	eval 'sub CPU_CT_CTYPE {
	    my($x) = @_;
    	    eval q(((($x) >> 25) & 0xf));
	}' unless defined(&CPU_CT_CTYPE);
	eval 'sub CPU_CT_CTYPE_WT () {0;}' unless defined(&CPU_CT_CTYPE_WT);
	eval 'sub CPU_CT_CTYPE_WB1 () {1;}' unless defined(&CPU_CT_CTYPE_WB1);
	eval 'sub CPU_CT_CTYPE_WB2 () {2;}' unless defined(&CPU_CT_CTYPE_WB2);
	eval 'sub CPU_CT_CTYPE_WB6 () {6;}' unless defined(&CPU_CT_CTYPE_WB6);
	eval 'sub CPU_CT_CTYPE_WB7 () {7;}' unless defined(&CPU_CT_CTYPE_WB7);
	eval 'sub CPU_CT_CTYPE_WB14 () {14;}' unless defined(&CPU_CT_CTYPE_WB14);
	eval 'sub CPU_CT_xSIZE_LEN {
	    my($x) = @_;
    	    eval q((($x) & 0x3));
	}' unless defined(&CPU_CT_xSIZE_LEN);
	eval 'sub CPU_CT_xSIZE_M () {(1 << 2);}' unless defined(&CPU_CT_xSIZE_M);
	eval 'sub CPU_CT_xSIZE_ASSOC {
	    my($x) = @_;
    	    eval q(((($x) >> 3) & 0x7));
	}' unless defined(&CPU_CT_xSIZE_ASSOC);
	eval 'sub CPU_CT_xSIZE_SIZE {
	    my($x) = @_;
    	    eval q(((($x) >> 6) & 0x7));
	}' unless defined(&CPU_CT_xSIZE_SIZE);
	eval 'sub CPU_CT_xSIZE_P () {(1 << 11);}' unless defined(&CPU_CT_xSIZE_P);
	eval 'sub CPU_CT4_ILINE {
	    my($x) = @_;
    	    eval q((($x) & 0xf));
	}' unless defined(&CPU_CT4_ILINE);
	eval 'sub CPU_CT4_DLINE {
	    my($x) = @_;
    	    eval q(((($x) >> 16) & 0xf));
	}' unless defined(&CPU_CT4_DLINE);
	eval 'sub CPU_CT4_L1IPOLICY {
	    my($x) = @_;
    	    eval q(((($x) >> 14) & 0x3));
	}' unless defined(&CPU_CT4_L1IPOLICY);
	eval 'sub CPU_CT4_L1_AIVIVT () {1;}' unless defined(&CPU_CT4_L1_AIVIVT);
	eval 'sub CPU_CT4_L1_VIPT () {2;}' unless defined(&CPU_CT4_L1_VIPT);
	eval 'sub CPU_CT4_L1_PIPT () {3;}' unless defined(&CPU_CT4_L1_PIPT);
	eval 'sub CPU_CT4_ERG {
	    my($x) = @_;
    	    eval q(((($x) >> 20) & 0xf));
	}' unless defined(&CPU_CT4_ERG);
	eval 'sub CPU_CT4_CWG {
	    my($x) = @_;
    	    eval q(((($x) >> 24) & 0xf));
	}' unless defined(&CPU_CT4_CWG);
	eval 'sub CPU_CSID_CTYPE_WT () {0x80000000;}' unless defined(&CPU_CSID_CTYPE_WT);
	eval 'sub CPU_CSID_CTYPE_WB () {0x40000000;}' unless defined(&CPU_CSID_CTYPE_WB);
	eval 'sub CPU_CSID_CTYPE_RA () {0x20000000;}' unless defined(&CPU_CSID_CTYPE_RA);
	eval 'sub CPU_CSID_CTYPE_WA () {0x10000000;}' unless defined(&CPU_CSID_CTYPE_WA);
	eval 'sub CPU_CSID_NUMSETS {
	    my($x) = @_;
    	    eval q(((($x) >> 13) & 0x7fff));
	}' unless defined(&CPU_CSID_NUMSETS);
	eval 'sub CPU_CSID_ASSOC {
	    my($x) = @_;
    	    eval q(((($x) >> 3) & 0x1ff));
	}' unless defined(&CPU_CSID_ASSOC);
	eval 'sub CPU_CSID_LEN {
	    my($x) = @_;
    	    eval q((($x) & 0x7));
	}' unless defined(&CPU_CSID_LEN);
	eval 'sub CPU_CSSR_L2 () {0x2;}' unless defined(&CPU_CSSR_L2);
	eval 'sub CPU_CSSR_L1 () {0x;}' unless defined(&CPU_CSSR_L1);
	eval 'sub CPU_CSSR_InD () {0x1;}' unless defined(&CPU_CSSR_InD);
	eval 'sub FAULT_TYPE_MASK () {0xf;}' unless defined(&FAULT_TYPE_MASK);
	eval 'sub FAULT_USER () {0x10;}' unless defined(&FAULT_USER);
	eval 'sub FAULT_WRTBUF_0 () {0x;}' unless defined(&FAULT_WRTBUF_0);
	eval 'sub FAULT_WRTBUF_1 () {0x2;}' unless defined(&FAULT_WRTBUF_1);
	eval 'sub FAULT_BUSERR_0 () {0x4;}' unless defined(&FAULT_BUSERR_0);
	eval 'sub FAULT_BUSERR_1 () {0x6;}' unless defined(&FAULT_BUSERR_1);
	eval 'sub FAULT_BUSERR_2 () {0x8;}' unless defined(&FAULT_BUSERR_2);
	eval 'sub FAULT_BUSERR_3 () {0xa;}' unless defined(&FAULT_BUSERR_3);
	eval 'sub FAULT_BUSTRNL1 () {0xc;}' unless defined(&FAULT_BUSTRNL1);
	eval 'sub FAULT_BUSTRNL2 () {0xe;}' unless defined(&FAULT_BUSTRNL2);
	eval 'sub FAULT_ALIGN_0 () {0x1;}' unless defined(&FAULT_ALIGN_0);
	eval 'sub FAULT_ALIGN_1 () {0x3;}' unless defined(&FAULT_ALIGN_1);
	eval 'sub FAULT_TRANS_S () {0x5;}' unless defined(&FAULT_TRANS_S);
	eval 'sub FAULT_TRANS_P () {0x7;}' unless defined(&FAULT_TRANS_P);
	eval 'sub FAULT_DOMAIN_S () {0x9;}' unless defined(&FAULT_DOMAIN_S);
	eval 'sub FAULT_DOMAIN_P () {0xb;}' unless defined(&FAULT_DOMAIN_P);
	eval 'sub FAULT_PERM_S () {0xd;}' unless defined(&FAULT_PERM_S);
	eval 'sub FAULT_PERM_P () {0xf;}' unless defined(&FAULT_PERM_P);
	eval 'sub FAULT_LPAE () {0x200;}' unless defined(&FAULT_LPAE);
	eval 'sub FAULT_IMPRECISE () {0x400;}' unless defined(&FAULT_IMPRECISE);
	eval 'sub FAULT_WRITE () {0x800;}' unless defined(&FAULT_WRITE);
	eval 'sub FAULT_EXT () {0x1000;}' unless defined(&FAULT_EXT);
	eval 'sub FAULT_CM () {0x2000;}' unless defined(&FAULT_CM);
	eval 'sub ARM_VECTORS_LOW () {0x;}' unless defined(&ARM_VECTORS_LOW);
	eval 'sub ARM_VECTORS_HIGH () {0xffff0000;}' unless defined(&ARM_VECTORS_HIGH);
	eval 'sub INSN_SIZE () {4;}' unless defined(&INSN_SIZE);
	eval 'sub INSN_COND_MASK () {0xf0000000;}' unless defined(&INSN_COND_MASK);
	eval 'sub INSN_COND_EQ () {0;}' unless defined(&INSN_COND_EQ);
	eval 'sub INSN_COND_NE () {1;}' unless defined(&INSN_COND_NE);
	eval 'sub INSN_COND_CS () {2;}' unless defined(&INSN_COND_CS);
	eval 'sub INSN_COND_CC () {3;}' unless defined(&INSN_COND_CC);
	eval 'sub INSN_COND_MI () {4;}' unless defined(&INSN_COND_MI);
	eval 'sub INSN_COND_PL () {5;}' unless defined(&INSN_COND_PL);
	eval 'sub INSN_COND_VS () {6;}' unless defined(&INSN_COND_VS);
	eval 'sub INSN_COND_VC () {7;}' unless defined(&INSN_COND_VC);
	eval 'sub INSN_COND_HI () {8;}' unless defined(&INSN_COND_HI);
	eval 'sub INSN_COND_LS () {9;}' unless defined(&INSN_COND_LS);
	eval 'sub INSN_COND_GE () {10;}' unless defined(&INSN_COND_GE);
	eval 'sub INSN_COND_LT () {11;}' unless defined(&INSN_COND_LT);
	eval 'sub INSN_COND_GT () {12;}' unless defined(&INSN_COND_GT);
	eval 'sub INSN_COND_LE () {13;}' unless defined(&INSN_COND_LE);
	eval 'sub INSN_COND_AL () {14;}' unless defined(&INSN_COND_AL);
	eval 'sub THUMB_INSN_SIZE () {2;}' unless defined(&THUMB_INSN_SIZE);
	eval 'sub ARM11_PMCCTL_E () { &__BIT(0);}' unless defined(&ARM11_PMCCTL_E);
	eval 'sub ARM11_PMCCTL_P () { &__BIT(1);}' unless defined(&ARM11_PMCCTL_P);
	eval 'sub ARM11_PMCCTL_C () { &__BIT(2);}' unless defined(&ARM11_PMCCTL_C);
	eval 'sub ARM11_PMCCTL_D () { &__BIT(3);}' unless defined(&ARM11_PMCCTL_D);
	eval 'sub ARM11_PMCCTL_EC0 () { &__BIT(4);}' unless defined(&ARM11_PMCCTL_EC0);
	eval 'sub ARM11_PMCCTL_EC1 () { &__BIT(5);}' unless defined(&ARM11_PMCCTL_EC1);
	eval 'sub ARM11_PMCCTL_ECC () { &__BIT(6);}' unless defined(&ARM11_PMCCTL_ECC);
	eval 'sub ARM11_PMCCTL_SBZa () { &__BIT(7);}' unless defined(&ARM11_PMCCTL_SBZa);
	eval 'sub ARM11_PMCCTL_CR0 () { &__BIT(8);}' unless defined(&ARM11_PMCCTL_CR0);
	eval 'sub ARM11_PMCCTL_CR1 () { &__BIT(9);}' unless defined(&ARM11_PMCCTL_CR1);
	eval 'sub ARM11_PMCCTL_CCR () { &__BIT(10);}' unless defined(&ARM11_PMCCTL_CCR);
	eval 'sub ARM11_PMCCTL_X () { &__BIT(11);}' unless defined(&ARM11_PMCCTL_X);
	eval 'sub ARM11_PMCCTL_EVT1 () { &__BITS(19,12);}' unless defined(&ARM11_PMCCTL_EVT1);
	eval 'sub ARM11_PMCCTL_EVT0 () { &__BITS(27,20);}' unless defined(&ARM11_PMCCTL_EVT0);
	eval 'sub ARM11_PMCCTL_SBZb () { &__BITS(31,28);}' unless defined(&ARM11_PMCCTL_SBZb);
	eval 'sub ARM11_PMCCTL_SBZ () {( &ARM11_PMCCTL_SBZa |  &ARM11_PMCCTL_SBZb);}' unless defined(&ARM11_PMCCTL_SBZ);
	eval 'sub ARM11_PMCEVT_ICACHE_MISS () {0;}' unless defined(&ARM11_PMCEVT_ICACHE_MISS);
	eval 'sub ARM11_PMCEVT_ISTREAM_STALL () {1;}' unless defined(&ARM11_PMCEVT_ISTREAM_STALL);
	eval 'sub ARM11_PMCEVT_IUTLB_MISS () {2;}' unless defined(&ARM11_PMCEVT_IUTLB_MISS);
	eval 'sub ARM11_PMCEVT_DUTLB_MISS () {3;}' unless defined(&ARM11_PMCEVT_DUTLB_MISS);
	eval 'sub ARM11_PMCEVT_BRANCH () {4;}' unless defined(&ARM11_PMCEVT_BRANCH);
	eval 'sub ARM11_PMCEVT_BRANCH_MISS () {6;}' unless defined(&ARM11_PMCEVT_BRANCH_MISS);
	eval 'sub ARM11_PMCEVT_INST_EXEC () {7;}' unless defined(&ARM11_PMCEVT_INST_EXEC);
	eval 'sub ARM11_PMCEVT_DCACHE_ACCESS0 () {9;}' unless defined(&ARM11_PMCEVT_DCACHE_ACCESS0);
	eval 'sub ARM11_PMCEVT_DCACHE_ACCESS1 () {10;}' unless defined(&ARM11_PMCEVT_DCACHE_ACCESS1);
	eval 'sub ARM11_PMCEVT_DCACHE_MISS () {11;}' unless defined(&ARM11_PMCEVT_DCACHE_MISS);
	eval 'sub ARM11_PMCEVT_DCACHE_WRITEBACK () {12;}' unless defined(&ARM11_PMCEVT_DCACHE_WRITEBACK);
	eval 'sub ARM11_PMCEVT_PC_CHANGE () {13;}' unless defined(&ARM11_PMCEVT_PC_CHANGE);
	eval 'sub ARM11_PMCEVT_TLB_MISS () {15;}' unless defined(&ARM11_PMCEVT_TLB_MISS);
	eval 'sub ARM11_PMCEVT_DATA_ACCESS () {16;}' unless defined(&ARM11_PMCEVT_DATA_ACCESS);
	eval 'sub ARM11_PMCEVT_LSU_STALL () {17;}' unless defined(&ARM11_PMCEVT_LSU_STALL);
	eval 'sub ARM11_PMCEVT_WBUF_DRAIN () {18;}' unless defined(&ARM11_PMCEVT_WBUF_DRAIN);
	eval 'sub ARM11_PMCEVT_ETMEXTOUT0 () {32;}' unless defined(&ARM11_PMCEVT_ETMEXTOUT0);
	eval 'sub ARM11_PMCEVT_ETMEXTOUT1 () {33;}' unless defined(&ARM11_PMCEVT_ETMEXTOUT1);
	eval 'sub ARM11_PMCEVT_ETMEXTOUT () {34;}' unless defined(&ARM11_PMCEVT_ETMEXTOUT);
	eval 'sub ARM11_PMCEVT_CALL_EXEC () {35;}' unless defined(&ARM11_PMCEVT_CALL_EXEC);
	eval 'sub ARM11_PMCEVT_RETURN_EXEC () {36;}' unless defined(&ARM11_PMCEVT_RETURN_EXEC);
	eval 'sub ARM11_PMCEVT_RETURN_HIT () {37;}' unless defined(&ARM11_PMCEVT_RETURN_HIT);
	eval 'sub ARM11_PMCEVT_RETURN_MISS () {38;}' unless defined(&ARM11_PMCEVT_RETURN_MISS);
	eval 'sub ARM11_PMCEVT_CYCLE () {255;}' unless defined(&ARM11_PMCEVT_CYCLE);
	eval 'sub PMCR_N () { &__BITS(15,11);}' unless defined(&PMCR_N);
	eval 'sub PMCR_D () { &__BIT(3);}' unless defined(&PMCR_D);
	eval 'sub PMCR_E () { &__BIT(0);}' unless defined(&PMCR_E);
	eval 'sub PMINTEN_C () { &__BIT(31);}' unless defined(&PMINTEN_C);
	eval 'sub PMINTEN_P () { &__BITS(30,0);}' unless defined(&PMINTEN_P);
	eval 'sub PMCNTEN_C () { &__BIT(31);}' unless defined(&PMCNTEN_C);
	eval 'sub PMCNTEN_P () { &__BITS(30,0);}' unless defined(&PMCNTEN_P);
	eval 'sub PMOVS_C () { &__BIT(31);}' unless defined(&PMOVS_C);
	eval 'sub PMOVS_P () { &__BITS(30,0);}' unless defined(&PMOVS_P);
	eval 'sub PMEVTYPER_P () { &__BIT(31);}' unless defined(&PMEVTYPER_P);
	eval 'sub PMEVTYPER_U () { &__BIT(30);}' unless defined(&PMEVTYPER_U);
	eval 'sub PMEVTYPER_EVTCOUNT () { &__BITS(7,0);}' unless defined(&PMEVTYPER_EVTCOUNT);
	eval 'sub CORTEX_CNTENS_C () { &__BIT(31);}' unless defined(&CORTEX_CNTENS_C);
	eval 'sub CORTEX_CNTENC_C () { &__BIT(31);}' unless defined(&CORTEX_CNTENC_C);
	eval 'sub CORTEX_CNTOFL_C () { &__BIT(31);}' unless defined(&CORTEX_CNTOFL_C);
	eval 'sub L2CTRL_NUMCPU () { &__BITS(25,24);}' unless defined(&L2CTRL_NUMCPU);
	eval 'sub L2CTRL_ICPRES () { &__BIT(23);}' unless defined(&L2CTRL_ICPRES);
	eval 'sub TTBR_C () { &__BIT(0);}' unless defined(&TTBR_C);
	eval 'sub TTBR_S () { &__BIT(1);}' unless defined(&TTBR_S);
	eval 'sub TTBR_IMP () { &__BIT(2);}' unless defined(&TTBR_IMP);
	eval 'sub TTBR_RGN_MASK () { &__BITS(4,3);}' unless defined(&TTBR_RGN_MASK);
	eval 'sub TTBR_RGN_NC () { &__SHIFTIN(0,  &TTBR_RGN_MASK);}' unless defined(&TTBR_RGN_NC);
	eval 'sub TTBR_RGN_WBWA () { &__SHIFTIN(1,  &TTBR_RGN_MASK);}' unless defined(&TTBR_RGN_WBWA);
	eval 'sub TTBR_RGN_WT () { &__SHIFTIN(2,  &TTBR_RGN_MASK);}' unless defined(&TTBR_RGN_WT);
	eval 'sub TTBR_RGN_WBNWA () { &__SHIFTIN(3,  &TTBR_RGN_MASK);}' unless defined(&TTBR_RGN_WBNWA);
	eval 'sub TTBR_NOS () { &__BIT(5);}' unless defined(&TTBR_NOS);
	eval 'sub TTBR_IRGN_MASK () {( &__BIT(6) |  &__BIT(0));}' unless defined(&TTBR_IRGN_MASK);
	eval 'sub TTBR_IRGN_NC () {0;}' unless defined(&TTBR_IRGN_NC);
	eval 'sub TTBR_IRGN_WBWA () { &__BIT(6);}' unless defined(&TTBR_IRGN_WBWA);
	eval 'sub TTBR_IRGN_WT () { &__BIT(0);}' unless defined(&TTBR_IRGN_WT);
	eval 'sub TTBR_IRGN_WBNWA () {( &__BIT(0) |  &__BIT(6));}' unless defined(&TTBR_IRGN_WBNWA);
	eval 'sub TTBCR_S_EAE () { &__BIT(31);}' unless defined(&TTBCR_S_EAE);
	eval 'sub TTBCR_S_PD1 () { &__BIT(5);}' unless defined(&TTBCR_S_PD1);
	eval 'sub TTBCR_S_PD0 () { &__BIT(4);}' unless defined(&TTBCR_S_PD0);
	eval 'sub TTBCR_S_N () { &__BITS(2,0);}' unless defined(&TTBCR_S_N);
	eval 'sub TTBCR_L_EAE () { &__BIT(31);}' unless defined(&TTBCR_L_EAE);
	eval 'sub TTBCR_L_SH1 () { &__BITS(29,28);}' unless defined(&TTBCR_L_SH1);
	eval 'sub TTBCR_L_ORGN1 () { &__BITS(27,26);}' unless defined(&TTBCR_L_ORGN1);
	eval 'sub TTBCR_L_IRGN1 () { &__BITS(25,24);}' unless defined(&TTBCR_L_IRGN1);
	eval 'sub TTBCR_L_EPD1 () { &__BIT(23);}' unless defined(&TTBCR_L_EPD1);
	eval 'sub TTBCR_L_A1 () { &__BIT(22);}' unless defined(&TTBCR_L_A1);
	eval 'sub TTBCR_L_T1SZ () { &__BITS(18,16);}' unless defined(&TTBCR_L_T1SZ);
	eval 'sub TTBCR_L_SH0 () { &__BITS(13,12);}' unless defined(&TTBCR_L_SH0);
	eval 'sub TTBCR_L_ORGN0 () { &__BITS(11,10);}' unless defined(&TTBCR_L_ORGN0);
	eval 'sub TTBCR_L_IRGN0 () { &__BITS(9,8);}' unless defined(&TTBCR_L_IRGN0);
	eval 'sub TTBCR_L_EPD0 () { &__BIT(7);}' unless defined(&TTBCR_L_EPD0);
	eval 'sub TTBCR_L_T0SZ () { &__BITS(2,0);}' unless defined(&TTBCR_L_T0SZ);
	eval 'sub NMRR_ORn {
	    my($n) = @_;
    	    eval q( &__BITS(17+2*($n),16+2*($n)));
	}' unless defined(&NMRR_ORn);
	eval 'sub NMRR_IRn {
	    my($n) = @_;
    	    eval q( &__BITS(1+2*($n),0+2*($n)));
	}' unless defined(&NMRR_IRn);
	eval 'sub NMRR_NC () {0;}' unless defined(&NMRR_NC);
	eval 'sub NMRR_WBWA () {1;}' unless defined(&NMRR_WBWA);
	eval 'sub NMRR_WT () {2;}' unless defined(&NMRR_WT);
	eval 'sub NMRR_WB () {3;}' unless defined(&NMRR_WB);
	eval 'sub PRRR_NOSn {
	    my($n) = @_;
    	    eval q( &__BITS(24+($n)));
	}' unless defined(&PRRR_NOSn);
	eval 'sub PRRR_NS1 () { &__BIT(19);}' unless defined(&PRRR_NS1);
	eval 'sub PRRR_NS0 () { &__BIT(18);}' unless defined(&PRRR_NS0);
	eval 'sub PRRR_DS1 () { &__BIT(17);}' unless defined(&PRRR_DS1);
	eval 'sub PRRR_DS0 () { &__BIT(16);}' unless defined(&PRRR_DS0);
	eval 'sub PRRR_TRn {
	    my($n) = @_;
    	    eval q( &__BITS(1+2*($n),0+2*($n)));
	}' unless defined(&PRRR_TRn);
	eval 'sub PRRR_TR_STRONG () {0;}' unless defined(&PRRR_TR_STRONG);
	eval 'sub PRRR_TR_DEVICE () {1;}' unless defined(&PRRR_TR_DEVICE);
	eval 'sub PRRR_TR_NORMAL () {2;}' unless defined(&PRRR_TR_NORMAL);
	eval 'sub MPIDR_MP () { &__BIT(31);}' unless defined(&MPIDR_MP);
	eval 'sub MPIDR_U () { &__BIT(30);}' unless defined(&MPIDR_U);
	eval 'sub MPIDR_MT () { &__BIT(24);}' unless defined(&MPIDR_MT);
	eval 'sub MPIDR_AFF2 () { &__BITS(23,16);}' unless defined(&MPIDR_AFF2);
	eval 'sub MPIDR_AFF1 () { &__BITS(15,8);}' unless defined(&MPIDR_AFF1);
	eval 'sub MPIDR_AFF0 () { &__BITS(7,0);}' unless defined(&MPIDR_AFF0);
	eval 'sub CORTEXA9_MPIDR_MP () { &MPIDR_MP;}' unless defined(&CORTEXA9_MPIDR_MP);
	eval 'sub CORTEXA9_MPIDR_U () { &MPIDR_U;}' unless defined(&CORTEXA9_MPIDR_U);
	eval 'sub CORTEXA9_MPIDR_CLID () { &__BITS(11,8);}' unless defined(&CORTEXA9_MPIDR_CLID);
	eval 'sub CORTEXA9_MPIDR_CPUID () { &__BITS(0,1);}' unless defined(&CORTEXA9_MPIDR_CPUID);
	eval 'sub PJ4B_MPIDR_MP () { &MPIDR_MP;}' unless defined(&PJ4B_MPIDR_MP);
	eval 'sub PJ4B_MPIDR_U () { &MPIDR_U;}' unless defined(&PJ4B_MPIDR_U);
	eval 'sub PJ4B_MPIDR_MT () { &MPIDR_MT;}' unless defined(&PJ4B_MPIDR_MT);
	eval 'sub PJ4B_MPIDR_CLID () { &__BITS(11,8);}' unless defined(&PJ4B_MPIDR_CLID);
	eval 'sub PJ4B_MPIDR_CPUID () { &__BITS(0,3);}' unless defined(&PJ4B_MPIDR_CPUID);
	eval 'sub CNTCTL_ISTATUS () { &__BIT(2);}' unless defined(&CNTCTL_ISTATUS);
	eval 'sub CNTCTL_IMASK () { &__BIT(1);}' unless defined(&CNTCTL_IMASK);
	eval 'sub CNTCTL_ENABLE () { &__BIT(0);}' unless defined(&CNTCTL_ENABLE);
	eval 'sub CNTKCTL_PL0PTEN () { &__BIT(9);}' unless defined(&CNTKCTL_PL0PTEN);
	eval 'sub CNTKCTL_PL0VTEN () { &__BIT(8);}' unless defined(&CNTKCTL_PL0VTEN);
	eval 'sub CNTKCTL_EVNTI () { &__BITS(7,4);}' unless defined(&CNTKCTL_EVNTI);
	eval 'sub CNTKCTL_EVNTDIR () { &__BIT(3);}' unless defined(&CNTKCTL_EVNTDIR);
	eval 'sub CNTKCTL_EVNTEN () { &__BIT(2);}' unless defined(&CNTKCTL_EVNTEN);
	eval 'sub CNTKCTL_PL0VCTEN () { &__BIT(1);}' unless defined(&CNTKCTL_PL0VCTEN);
	eval 'sub CNTKCTL_PL0PCTEN () { &__BIT(0);}' unless defined(&CNTKCTL_PL0PCTEN);
	eval 'sub CNTHCTL_EVNTI () { &__BITS(7,4);}' unless defined(&CNTHCTL_EVNTI);
	eval 'sub CNTHCTL_EVNTDIR () { &__BIT(3);}' unless defined(&CNTHCTL_EVNTDIR);
	eval 'sub CNTHCTL_EVNTEN () { &__BIT(2);}' unless defined(&CNTHCTL_EVNTEN);
	eval 'sub CNTHCTL_PL1PCEN () { &__BIT(1);}' unless defined(&CNTHCTL_PL1PCEN);
	eval 'sub CNTHCTL_PL1PCTEN () { &__BIT(0);}' unless defined(&CNTHCTL_PL1PCTEN);
	eval 'sub ARM_A5_TLBDATA_DOM () { &__BITS(62,59);}' unless defined(&ARM_A5_TLBDATA_DOM);
	eval 'sub ARM_A5_TLBDATA_AP () { &__BITS(58,56);}' unless defined(&ARM_A5_TLBDATA_AP);
	eval 'sub ARM_A5_TLBDATA_NS_WALK () { &__BIT(55);}' unless defined(&ARM_A5_TLBDATA_NS_WALK);
	eval 'sub ARM_A5_TLBDATA_NS_PAGE () { &__BIT(54);}' unless defined(&ARM_A5_TLBDATA_NS_PAGE);
	eval 'sub ARM_A5_TLBDATA_XN () { &__BIT(53);}' unless defined(&ARM_A5_TLBDATA_XN);
	eval 'sub ARM_A5_TLBDATA_TEX () { &__BITS(52,50);}' unless defined(&ARM_A5_TLBDATA_TEX);
	eval 'sub ARM_A5_TLBDATA_B () { &__BIT(49);}' unless defined(&ARM_A5_TLBDATA_B);
	eval 'sub ARM_A5_TLBDATA_C () { &__BIT(48);}' unless defined(&ARM_A5_TLBDATA_C);
	eval 'sub ARM_A5_TLBDATA_S () { &__BIT(47);}' unless defined(&ARM_A5_TLBDATA_S);
	eval 'sub ARM_A5_TLBDATA_ASID () { &__BITS(46,39);}' unless defined(&ARM_A5_TLBDATA_ASID);
	eval 'sub ARM_A5_TLBDATA_SIZE () { &__BITS(38,37);}' unless defined(&ARM_A5_TLBDATA_SIZE);
	eval 'sub ARM_A5_TLBDATA_SIZE_4KB () {0;}' unless defined(&ARM_A5_TLBDATA_SIZE_4KB);
	eval 'sub ARM_A5_TLBDATA_SIZE_16KB () {1;}' unless defined(&ARM_A5_TLBDATA_SIZE_16KB);
	eval 'sub ARM_A5_TLBDATA_SIZE_1MB () {2;}' unless defined(&ARM_A5_TLBDATA_SIZE_1MB);
	eval 'sub ARM_A5_TLBDATA_SIZE_16MB () {3;}' unless defined(&ARM_A5_TLBDATA_SIZE_16MB);
	eval 'sub ARM_A5_TLBDATA_VA () { &__BITS(36,22);}' unless defined(&ARM_A5_TLBDATA_VA);
	eval 'sub ARM_A5_TLBDATA_PA () { &__BITS(21,2);}' unless defined(&ARM_A5_TLBDATA_PA);
	eval 'sub ARM_A5_TLBDATA_nG () { &__BIT(1);}' unless defined(&ARM_A5_TLBDATA_nG);
	eval 'sub ARM_A5_TLBDATA_VALID () { &__BIT(0);}' unless defined(&ARM_A5_TLBDATA_VALID);
	eval 'sub ARM_A7_TLBDATA2_S2_LEVEL () { &__BITS(85-64,84-64);}' unless defined(&ARM_A7_TLBDATA2_S2_LEVEL);
	eval 'sub ARM_A7_TLBDATA2_S1_SIZE () { &__BITS(83-64,82-64);}' unless defined(&ARM_A7_TLBDATA2_S1_SIZE);
	eval 'sub ARM_A7_TLBDATA2_S1_SIZE_4KB () {0;}' unless defined(&ARM_A7_TLBDATA2_S1_SIZE_4KB);
	eval 'sub ARM_A7_TLBDATA2_S1_SIZE_64KB () {1;}' unless defined(&ARM_A7_TLBDATA2_S1_SIZE_64KB);
	eval 'sub ARM_A7_TLBDATA2_S1_SIZE_1MB () {2;}' unless defined(&ARM_A7_TLBDATA2_S1_SIZE_1MB);
	eval 'sub ARM_A7_TLBDATA2_S1_SIZE_16MB () {3;}' unless defined(&ARM_A7_TLBDATA2_S1_SIZE_16MB);
	eval 'sub ARM_A7_TLBDATA2_DOM () { &__BITS(81-64,78-64);}' unless defined(&ARM_A7_TLBDATA2_DOM);
	eval 'sub ARM_A7_TLBDATA2_IS () { &__BITS(77-64,76-64);}' unless defined(&ARM_A7_TLBDATA2_IS);
	eval 'sub ARM_A7_TLBDATA2_IS_NC () {0;}' unless defined(&ARM_A7_TLBDATA2_IS_NC);
	eval 'sub ARM_A7_TLBDATA2_IS_WB_WA () {1;}' unless defined(&ARM_A7_TLBDATA2_IS_WB_WA);
	eval 'sub ARM_A7_TLBDATA2_IS_WT () {2;}' unless defined(&ARM_A7_TLBDATA2_IS_WT);
	eval 'sub ARM_A7_TLBDATA2_IS_DSO () {3;}' unless defined(&ARM_A7_TLBDATA2_IS_DSO);
	eval 'sub ARM_A7_TLBDATA2_S2OVR () { &__BIT(75-64);}' unless defined(&ARM_A7_TLBDATA2_S2OVR);
	eval 'sub ARM_A7_TLBDATA2_SDO_MT () { &__BITS(74-64,72-64);}' unless defined(&ARM_A7_TLBDATA2_SDO_MT);
	eval 'sub ARM_A7_TLBDATA2_SDO_MT_D () {2;}' unless defined(&ARM_A7_TLBDATA2_SDO_MT_D);
	eval 'sub ARM_A7_TLBDATA2_SDO_MT_SO () {6;}' unless defined(&ARM_A7_TLBDATA2_SDO_MT_SO);
	eval 'sub ARM_A7_TLBDATA2_OS () { &__BITS(75-64,74-64);}' unless defined(&ARM_A7_TLBDATA2_OS);
	eval 'sub ARM_A7_TLBDATA2_OS_NC () {0;}' unless defined(&ARM_A7_TLBDATA2_OS_NC);
	eval 'sub ARM_A7_TLBDATA2_OS_WB_WA () {1;}' unless defined(&ARM_A7_TLBDATA2_OS_WB_WA);
	eval 'sub ARM_A7_TLBDATA2_OS_WT () {2;}' unless defined(&ARM_A7_TLBDATA2_OS_WT);
	eval 'sub ARM_A7_TLBDATA2_OS_WB () {3;}' unless defined(&ARM_A7_TLBDATA2_OS_WB);
	eval 'sub ARM_A7_TLBDATA2_SH () { &__BITS(73-64,72-64);}' unless defined(&ARM_A7_TLBDATA2_SH);
	eval 'sub ARM_A7_TLBDATA2_SH_NONE () {0;}' unless defined(&ARM_A7_TLBDATA2_SH_NONE);
	eval 'sub ARM_A7_TLBDATA2_SH_UNUSED () {1;}' unless defined(&ARM_A7_TLBDATA2_SH_UNUSED);
	eval 'sub ARM_A7_TLBDATA2_SH_OS () {2;}' unless defined(&ARM_A7_TLBDATA2_SH_OS);
	eval 'sub ARM_A7_TLBDATA2_SH_IS () {3;}' unless defined(&ARM_A7_TLBDATA2_SH_IS);
	eval 'sub ARM_A7_TLBDATA2_XN2 () { &__BIT(71-64);}' unless defined(&ARM_A7_TLBDATA2_XN2);
	eval 'sub ARM_A7_TLBDATA2_XN1 () { &__BIT(70-64);}' unless defined(&ARM_A7_TLBDATA2_XN1);
	eval 'sub ARM_A7_TLBDATA2_PXN () { &__BIT(69-64);}' unless defined(&ARM_A7_TLBDATA2_PXN);
	eval 'sub ARM_A7_TLBDATA12_PA () { &__BITS(68-32,41-32);}' unless defined(&ARM_A7_TLBDATA12_PA);
	eval 'sub ARM_A7_TLBDATA1_NS () { &__BIT(40-32);}' unless defined(&ARM_A7_TLBDATA1_NS);
	eval 'sub ARM_A7_TLBDATA1_HAP () { &__BITS(39-32,38-32);}' unless defined(&ARM_A7_TLBDATA1_HAP);
	eval 'sub ARM_A7_TLBDATA1_AP () { &__BITS(37-32,35-32);}' unless defined(&ARM_A7_TLBDATA1_AP);
	eval 'sub ARM_A7_TLBDATA1_nG () { &__BIT(34-32);}' unless defined(&ARM_A7_TLBDATA1_nG);
	eval 'sub ARM_A7_TLBDATA01_ASID () { &__BITS(33,26);}' unless defined(&ARM_A7_TLBDATA01_ASID);
	eval 'sub ARM_A7_TLBDATA0_VMID () { &__BITS(25,18);}' unless defined(&ARM_A7_TLBDATA0_VMID);
	eval 'sub ARM_A7_TLBDATA0_VA () { &__BITS(17,5);}' unless defined(&ARM_A7_TLBDATA0_VA);
	eval 'sub ARM_A7_TLBDATA0_NS_WALK () { &__BIT(4);}' unless defined(&ARM_A7_TLBDATA0_NS_WALK);
	eval 'sub ARM_A7_TLBDATA0_SIZE () { &__BITS(3,1);}' unless defined(&ARM_A7_TLBDATA0_SIZE);
	eval 'sub ARM_A7_TLBDATA0_SIZE_V7_4KB () {0;}' unless defined(&ARM_A7_TLBDATA0_SIZE_V7_4KB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_LPAE_4KB () {1;}' unless defined(&ARM_A7_TLBDATA0_SIZE_LPAE_4KB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_V7_64KB () {2;}' unless defined(&ARM_A7_TLBDATA0_SIZE_V7_64KB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_LPAE_64KB () {3;}' unless defined(&ARM_A7_TLBDATA0_SIZE_LPAE_64KB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_V7_1MB () {4;}' unless defined(&ARM_A7_TLBDATA0_SIZE_V7_1MB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_LPAE_2MB () {5;}' unless defined(&ARM_A7_TLBDATA0_SIZE_LPAE_2MB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_V7_16MB () {6;}' unless defined(&ARM_A7_TLBDATA0_SIZE_V7_16MB);
	eval 'sub ARM_A7_TLBDATA0_SIZE_LPAE_1GB () {7;}' unless defined(&ARM_A7_TLBDATA0_SIZE_LPAE_1GB);
	eval 'sub ARM_TLBDATA_VALID () { &__BIT(0);}' unless defined(&ARM_TLBDATA_VALID);
	eval 'sub ARM_TLBDATAOP_WAY () { &__BIT(31);}' unless defined(&ARM_TLBDATAOP_WAY);
	eval 'sub ARM_A5_TLBDATAOP_INDEX () { &__BITS(5,0);}' unless defined(&ARM_A5_TLBDATAOP_INDEX);
	eval 'sub ARM_A7_TLBDATAOP_INDEX () { &__BITS(6,0);}' unless defined(&ARM_A7_TLBDATAOP_INDEX);
	if(!defined(&__ASSEMBLER__)  && defined(&_KERNEL)) {
	    eval 'sub arm_cond_ok_p {
	        my($insn,$psr) = @_;
    		eval q({  &const  &uint32_t  &__cond =  &__SHIFTOUT($insn,  &INSN_COND_MASK);  &bool  &__ok;  &const  &bool  &__z = ($psr &  &PSR_Z_bit);  &const  &bool  &__n = ($psr &  &PSR_N_bit);  &const  &bool  &__c = ($psr &  &PSR_C_bit);  &const  &bool  &__v = ($psr &  &PSR_V_bit);  &switch ( &__cond & ~1) {  &case  &INSN_COND_EQ:  &__ok =  &__z;  &break;  &case  &INSN_COND_CS:  &__ok =  &__c;  &break;  &case  &INSN_COND_MI:  &__ok =  &__n;  &break;  &case  &INSN_COND_VS:  &__ok =  &__v;  &break;  &case  &INSN_COND_HI:  &__ok =  &__c  && ! &__z;  &break;  &case  &INSN_COND_GE:  &__ok =  &__n ==  &__v;  &break;  &case  &INSN_COND_GT:  &__ok =  &__n ==  &__v  && ! &__z;  &break;  &default:  &true; } ( &__cond & 1) ? ! &__ok :  &__ok; });
	    }' unless defined(&arm_cond_ok_p);
	}
	if(!defined(&__ASSEMBLER__)  && !defined(&_RUMPKERNEL)) {
	    eval 'sub ARMREG_READ_INLINE {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &uint32_t  &armreg_$name &_read( &void) {  &uint32_t  &__rv;  &__asm  &__volatile(\\"mrc \\" $__insnstring : \\"=r\\"( &__rv));  &return  &__rv; });
	    }' unless defined(&ARMREG_READ_INLINE);
	    eval 'sub ARMREG_WRITE_INLINE {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &void  &armreg_$name &_write( &uint32_t  &__val) {  &__asm  &__volatile(\\"mcr \\" $__insnstring :: \\"r\\"( &__val)); });
	    }' unless defined(&ARMREG_WRITE_INLINE);
	    eval 'sub ARMREG_READ_INLINE2 {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &uint32_t  &armreg_$name &_read( &void) {  &uint32_t  &__rv;  &__asm  &__volatile(\\".fpu vfp\\");  &__asm  &__volatile($__insnstring : \\"=r\\"( &__rv));  &return  &__rv; });
	    }' unless defined(&ARMREG_READ_INLINE2);
	    eval 'sub ARMREG_WRITE_INLINE2 {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &void  &armreg_$name &_write( &uint32_t  &__val) {  &__asm  &__volatile(\\".fpu vfp\\");  &__asm  &__volatile($__insnstring :: \\"r\\"( &__val)); });
	    }' unless defined(&ARMREG_WRITE_INLINE2);
	    eval 'sub ARMREG_READ64_INLINE {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &uint64_t  &armreg_$name &_read( &void) {  &uint64_t  &__rv;  &__asm  &__volatile(\\"mrrc \\" $__insnstring : \\"=r\\"( &__rv));  &return  &__rv; });
	    }' unless defined(&ARMREG_READ64_INLINE);
	    eval 'sub ARMREG_WRITE64_INLINE {
	        my($name, $__insnstring) = @_;
    		eval q( &static  &inline  &void  &armreg_$name &_write( &uint64_t  &__val) {  &__asm  &__volatile(\\"mcrr \\" $__insnstring :: \\"r\\"( &__val)); });
	    }' unless defined(&ARMREG_WRITE64_INLINE);
	    if(defined(&_KERNEL)) {
		eval 'sub cpu_mpidr_aff_read {
		    my($void) = @_;
    		    eval q({  &armreg_mpidr_read() & ( &MPIDR_AFF2| &MPIDR_AFF1| &MPIDR_AFF0); });
		}' unless defined(&cpu_mpidr_aff_read);
		eval 'sub gtmr_cntk_ctl_read {
		    my($void) = @_;
    		    eval q({  &armreg_cntk_ctl_read(); });
		}' unless defined(&gtmr_cntk_ctl_read);
		eval 'sub gtmr_cntk_ctl_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntk_ctl_write($val); });
		}' unless defined(&gtmr_cntk_ctl_write);
		eval 'sub gtmr_cntpct_read {
		    my($void) = @_;
    		    eval q({  &armreg_cntp_ct_read(); });
		}' unless defined(&gtmr_cntpct_read);
		eval 'sub gtmr_cntv_ctl_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntv_ctl_write($val); });
		}' unless defined(&gtmr_cntv_ctl_write);
		eval 'sub gtmr_cntp_ctl_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntp_ctl_write($val); });
		}' unless defined(&gtmr_cntp_ctl_write);
		eval 'sub gtmr_cntp_tval_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntp_tval_write($val); });
		}' unless defined(&gtmr_cntp_tval_write);
		eval 'sub gtmr_cntv_tval_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntv_tval_write($val); });
		}' unless defined(&gtmr_cntv_tval_write);
		eval 'sub gtmr_cntp_cval_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntp_cval_write($val); });
		}' unless defined(&gtmr_cntp_cval_write);
		eval 'sub gtmr_cntv_cval_write {
		    my($val) = @_;
    		    eval q({  &armreg_cntv_cval_write($val); });
		}' unless defined(&gtmr_cntv_cval_write);
	    }
	}
    }
 elsif(defined(&__aarch64__)) {
	require 'aarch64/armreg.ph';
    }
}
1;
