/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UIDefaults
extends Hashtable {
    private static final long serialVersionUID = 7341222528856548117L;
    private LinkedList bundles = new LinkedList();
    private Locale defaultLocale = Locale.getDefault();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$javax$swing$JComponent;

    public Object get(Object key) {
        return this.get(key, this.getDefaultLocale());
    }

    public Object get(Object key, Locale loc) {
        Object obj = null;
        if (super.containsKey(key)) {
            obj = super.get(key);
        } else if (key instanceof String) {
            String keyString = (String)key;
            ListIterator i = this.bundles.listIterator(0);
            while (i.hasNext()) {
                String bundle_name = (String)i.next();
                ResourceBundle res = ResourceBundle.getBundle(bundle_name, loc);
                if (res == null) continue;
                try {
                    obj = res.getObject(keyString);
                    break;
                }
                catch (MissingResourceException me) {
                    // empty catch block
                }
            }
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof LazyValue) {
            Object resolved = ((LazyValue)obj).createValue(this);
            super.remove(key);
            super.put(key, resolved);
            return resolved;
        }
        if (obj instanceof ActiveValue) {
            return ((ActiveValue)obj).createValue(this);
        }
        return obj;
    }

    public Object put(Object key, Object value) {
        Object old = this.checkAndPut(key, value);
        if (key instanceof String && old != value) {
            this.firePropertyChange((String)key, old, value);
        }
        return old;
    }

    public void putDefaults(Object[] entries) {
        int i = 0;
        while (2 * i + 1 < entries.length) {
            this.checkAndPut(entries[2 * i], entries[2 * i + 1]);
            ++i;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    private final Object checkAndPut(Object key, Object value) {
        Object old = value != null ? super.put(key, value) : super.remove(key);
        return old;
    }

    public Font getFont(Object key) {
        Object o = this.get(key);
        return o instanceof Font ? (Font)o : null;
    }

    public Font getFont(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Font ? (Font)o : null;
    }

    public Color getColor(Object key) {
        Object o = this.get(key);
        return o instanceof Color ? (Color)o : null;
    }

    public Color getColor(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Color ? (Color)o : null;
    }

    public Icon getIcon(Object key) {
        Object o = this.get(key);
        return o instanceof Icon ? (Icon)o : null;
    }

    public Icon getIcon(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Icon ? (Icon)o : null;
    }

    public Border getBorder(Object key) {
        Object o = this.get(key);
        return o instanceof Border ? (Border)o : null;
    }

    public Border getBorder(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Border ? (Border)o : null;
    }

    public String getString(Object key) {
        Object o = this.get(key);
        return o instanceof String ? (String)o : null;
    }

    public String getString(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof String ? (String)o : null;
    }

    public int getInt(Object key) {
        Object o = this.get(key);
        int n = 0;
        if (o instanceof Integer) {
            n = (Integer)o;
        }
        return n;
    }

    public int getInt(Object key, Locale locale) {
        Object o = this.get(key, locale);
        int n = 0;
        if (o instanceof Integer) {
            n = (Integer)o;
        }
        return n;
    }

    public boolean getBoolean(Object key) {
        return Boolean.TRUE.equals(this.get(key));
    }

    public boolean getBoolean(Object key, Locale locale) {
        return Boolean.TRUE.equals(this.get(key, locale));
    }

    public Insets getInsets(Object key) {
        Object o = this.get(key);
        return o instanceof Insets ? (Insets)o : null;
    }

    public Insets getInsets(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Insets ? (Insets)o : null;
    }

    public Dimension getDimension(Object key) {
        Object o = this.get(key);
        return o instanceof Dimension ? (Dimension)o : null;
    }

    public Dimension getDimension(Object key, Locale locale) {
        Object o = this.get(key, locale);
        return o instanceof Dimension ? (Dimension)o : null;
    }

    public Class getUIClass(String id, ClassLoader loader) {
        String className = (String)this.get(id);
        if (className == null) {
            return null;
        }
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            return loader.loadClass(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class getUIClass(String id) {
        return this.getUIClass(id, null);
    }

    protected void getUIError(String msg) {
        System.err.println("UIDefaults.getUIError: " + msg);
    }

    public ComponentUI getUI(JComponent target) {
        Method factory;
        String classId = target.getUIClassID();
        Class cls = this.getUIClass(classId);
        if (cls == null) {
            this.getUIError("failed to locate UI class:" + classId);
            return null;
        }
        try {
            Class[] classArray = new Class[1];
            Class clazz = class$javax$swing$JComponent;
            if (clazz == null) {
                clazz = class$javax$swing$JComponent = UIDefaults.class("[Ljavax.swing.JComponent;", false);
            }
            classArray[0] = clazz;
            factory = cls.getMethod("createUI", classArray);
        }
        catch (NoSuchMethodException nme) {
            this.getUIError("failed to locate createUI method on " + cls.toString());
            return null;
        }
        try {
            return (ComponentUI)factory.invoke(null, new Object[]{target});
        }
        catch (InvocationTargetException ite) {
            this.getUIError("InvocationTargetException (" + ite.getTargetException() + ") calling createUI(...) on " + cls.toString());
            return null;
        }
        catch (Exception e) {
            this.getUIError("exception calling createUI(...) on " + cls.toString());
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    public void addResourceBundle(String name) {
        this.bundles.addFirst(name);
    }

    public void removeResourceBundle(String name) {
        this.bundles.remove(name);
    }

    public void setDefaultLocale(Locale loc) {
        this.defaultLocale = loc;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public UIDefaults() {
    }

    public UIDefaults(Object[] entries) {
        this();
        int i = 0;
        while (2 * i + 1 < entries.length) {
            this.put(entries[2 * i], entries[2 * i + 1]);
            ++i;
        }
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }

    public static class ProxyLazyValue
    implements LazyValue {
        LazyValue inner;

        public Object createValue(UIDefaults table) {
            return this.inner.createValue(table);
        }

        public ProxyLazyValue(String s) {
            final String className = s;
            this.inner = new LazyValue(){

                public final Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, String m) {
            final String className = c;
            final String methodName = m;
            this.inner = new LazyValue(){

                public final Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, Object[] os) {
            final String className = c;
            final Object[] objs = os;
            final Class[] clss = new Class[objs.length];
            int i = 0;
            while (i < objs.length) {
                clss[i] = objs[i].getClass();
                ++i;
            }
            this.inner = new LazyValue(){

                public final Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(className).getConstructor(clss).newInstance(objs);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, String m, Object[] os) {
            final String className = c;
            final String methodName = m;
            final Object[] objs = os;
            final Class[] clss = new Class[objs.length];
            int i = 0;
            while (i < objs.length) {
                clss[i] = objs[i].getClass();
                ++i;
            }
            this.inner = new LazyValue(){

                public final Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(className).getMethod(methodName, clss).invoke(null, objs);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
    }

    public static class LazyInputMap
    implements LazyValue {
        Object[] bind;

        public Object createValue(UIDefaults table) {
            InputMap im = new InputMap();
            int i = 0;
            while (2 * i + 1 < this.bind.length) {
                im.put(KeyStroke.getKeyStroke((String)this.bind[2 * i]), this.bind[2 * i + 1]);
                ++i;
            }
            return im;
        }

        public LazyInputMap(Object[] bindings) {
            this.bind = bindings;
        }
    }
}

