/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactory {
    private static final String TRUST_MANAGER_FACTORY = "TrustManagerFactory";
    private static final String DEFAULT_ALGORITHM = "JessieX509";
    private final TrustManagerFactorySpi tmfSpi;
    private final Provider provider;
    private final String algorithm;

    public static final TrustManagerFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        int i = 0;
        while (i < provs.length) {
            try {
                return TrustManagerFactory.getInstance(algorithm, provs[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final TrustManagerFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return TrustManagerFactory.getInstance(algorithm, p);
    }

    public static final TrustManagerFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new TrustManagerFactory((TrustManagerFactorySpi)Engine.getInstance(TRUST_MANAGER_FACTORY, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public static final String getDefaultAlgorithm() {
        String alg = null;
        try {
            alg = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (alg == null) {
            alg = DEFAULT_ALGORITHM;
        }
        return alg;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final TrustManager[] getTrustManagers() {
        return this.tmfSpi.engineGetTrustManagers();
    }

    public final void init(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        this.tmfSpi.engineInit(params);
    }

    public final void init(KeyStore store) throws KeyStoreException {
        this.tmfSpi.engineInit(store);
    }

    protected TrustManagerFactory(TrustManagerFactorySpi tmfSpi, Provider provider, String algorithm) {
        this.tmfSpi = tmfSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

