/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class CompoundName
implements Name,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3513100557083972036L;
    private static final int RIGHT_TO_LEFT = -1;
    private static final int LEFT_TO_RIGHT = 1;
    private static final int FLAT = 0;
    protected transient Properties mySyntax;
    private transient Vector elts = new Vector();
    private transient int direction;
    private transient String separator;
    private transient boolean ignoreCase;
    private transient String escape;
    private transient String beginQuote;
    private transient String endQuote;
    private transient String beginQuote2;
    private transient String endQuote2;
    private transient boolean trimBlanks;

    public Name add(int posn, String comp) throws InvalidNameException {
        this.elts.add(posn, comp);
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        this.elts.add(comp);
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        Enumeration e = n.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(posn, e.nextElement());
                ++posn;
            }
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        Enumeration e = suffix.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(e.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    public Object clone() {
        return new CompoundName(this.elts.elements(), this.mySyntax);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof CompoundName)) {
            throw new ClassCastException("CompoundName.compareTo() expected CompoundName");
        }
        CompoundName cn = (CompoundName)obj;
        int last = Math.min(cn.elts.size(), this.elts.size());
        int i = 0;
        while (i < last) {
            String f = this.canonicalize((String)this.elts.get(i));
            int comp = f.compareTo(this.canonicalize((String)cn.elts.get(i)));
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return this.elts.size() - cn.elts.size();
    }

    public boolean endsWith(Name n) {
        if (!(n instanceof CompoundName)) {
            return false;
        }
        CompoundName cn = (CompoundName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        int delta = this.elts.size() - cn.elts.size();
        int i = 0;
        while (i < cn.elts.size()) {
            String f = this.canonicalize((String)this.elts.get(delta + i));
            if (!f.equals(this.canonicalize((String)cn.elts.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundName)) {
            return false;
        }
        boolean bl = false;
        if (this.compareTo(obj) == 0) {
            bl = true;
        }
        return bl;
    }

    public String get(int posn) {
        return (String)this.elts.get(posn);
    }

    public Enumeration getAll() {
        return this.elts.elements();
    }

    public Name getPrefix(int posn) {
        CompoundName cn = new CompoundName(this.mySyntax);
        int i = 0;
        while (i < posn) {
            cn.elts.add(this.elts.get(i));
            ++i;
        }
        return cn;
    }

    public Name getSuffix(int posn) {
        if (posn > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        CompoundName cn = new CompoundName(this.mySyntax);
        int i = posn;
        while (i < this.elts.size()) {
            cn.elts.add(this.elts.get(i));
            ++i;
        }
        return cn;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.elts.size()) {
            h += this.canonicalize((String)this.elts.get(i)).hashCode();
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    public Object remove(int posn) throws InvalidNameException {
        return this.elts.remove(posn);
    }

    public int size() {
        return this.elts.size();
    }

    public boolean startsWith(Name n) {
        if (!(n instanceof CompoundName)) {
            return false;
        }
        CompoundName cn = (CompoundName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        int i = 0;
        while (i < cn.elts.size()) {
            String f = this.canonicalize((String)this.elts.get(i));
            if (!f.equals(this.canonicalize((String)cn.elts.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final String isSpecial(String element, int offset) {
        String special = null;
        if (this.separator != null && element.startsWith(this.separator, offset)) {
            special = this.separator;
        } else if (this.escape != null && element.startsWith(this.escape, offset)) {
            special = this.escape;
        } else if (this.beginQuote != null && element.startsWith(this.beginQuote, offset)) {
            special = this.beginQuote;
        } else if (this.endQuote != null && element.startsWith(this.endQuote, offset)) {
            special = this.endQuote;
        } else if (this.beginQuote2 != null && element.startsWith(this.beginQuote2, offset)) {
            special = this.beginQuote2;
        } else if (this.endQuote2 != null && element.startsWith(this.endQuote2, offset)) {
            special = this.endQuote2;
        }
        return special;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int size = this.elts.size();
        int i = 0;
        while (i < size) {
            int offset = this.direction == -1 ? size - i - 1 : i;
            String element = (String)this.elts.get(offset);
            if (i > 0 || i == size - 1 && element.equals("")) {
                result.append(this.separator);
            }
            int k = 0;
            while (k < element.length()) {
                String special = this.isSpecial(element, k);
                if (special != null) {
                    result.append(this.escape);
                    result.append(special);
                    k += special.length();
                    continue;
                }
                result.append(element.charAt(k));
                ++k;
            }
            ++i;
        }
        return result.toString();
    }

    private final String canonicalize(String element) {
        String ret = element;
        if (this.ignoreCase) {
            ret = ret.toLowerCase();
        }
        if (this.trimBlanks) {
            int first = 0;
            while (first < ret.length() && Character.isWhitespace(ret.charAt(first))) {
                ++first;
            }
            int last = ret.length() - 1;
            while (last >= first && Character.isWhitespace(ret.charAt(last))) {
                --last;
            }
            ret = ret.substring(first, last);
        }
        return ret;
    }

    private final void initializeSyntax() {
        String t = this.mySyntax.getProperty("jndi.syntax.direction", "flat");
        this.direction = t.equals("right_to_left") ? -1 : (t.equals("left_to_right") ? 1 : 0);
        this.separator = this.mySyntax.getProperty("jndi.syntax.separator", "");
        this.ignoreCase = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.ignorecase", "false"));
        this.escape = this.mySyntax.getProperty("jndi.syntax.escape", null);
        this.beginQuote = this.mySyntax.getProperty("jndi.syntax.beginquote", null);
        this.endQuote = this.mySyntax.getProperty("jndi.syntax.endquote", this.beginQuote);
        this.beginQuote2 = this.mySyntax.getProperty("jndi.syntax.beginquote2", null);
        this.endQuote2 = this.mySyntax.getProperty("jndi.syntax.endquote2", this.beginQuote2);
        this.trimBlanks = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.trimblanks", "false"));
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mySyntax = (Properties)s.readObject();
        int count = s.readInt();
        this.elts = new Vector(count);
        int i = 0;
        while (i < count) {
            this.elts.addElement((String)s.readObject());
            ++i;
        }
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mySyntax);
        s.writeInt(this.elts.size());
        int i = 0;
        while (i < this.elts.size()) {
            s.writeObject(this.elts.elementAt(i));
            ++i;
        }
    }

    private CompoundName(Properties syntax) {
        this.mySyntax = syntax;
        this.initializeSyntax();
    }

    protected CompoundName(Enumeration comps, Properties syntax) {
        this.mySyntax = syntax;
        this.initializeSyntax();
        try {
            while (comps.hasMoreElements()) {
                this.elts.add(comps.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public CompoundName(String n, Properties syntax) throws InvalidNameException {
        this.mySyntax = syntax;
        this.initializeSyntax();
        StringBuffer new_element = new StringBuffer();
        int i = 0;
        String quote = null;
        while (i < n.length()) {
            block16: {
                String special = this.isSpecial(n, i);
                if (special == this.escape && this.escape != null) {
                    if (n.length() == i + special.length()) {
                        new_element.append(special);
                        i += special.length();
                        break block16;
                    } else {
                        String eSpecial = this.isSpecial(n, i + special.length());
                        if (eSpecial != null) {
                            new_element.append(eSpecial);
                            i += special.length() + eSpecial.length();
                            continue;
                        }
                        new_element.append(special);
                        i += special.length();
                        continue;
                    }
                }
                if (quote != null) {
                    if (quote == special) {
                        if (i + quote.length() < n.length() && !n.startsWith(this.separator, i + quote.length())) {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        i += quote.length();
                        quote = null;
                        continue;
                    }
                } else {
                    if (new_element.length() == 0 && special == this.beginQuote && this.beginQuote != null) {
                        quote = this.endQuote;
                        i += special.length();
                        continue;
                    }
                    if (new_element.length() == 0 && special == this.beginQuote2 && this.beginQuote2 != null) {
                        quote = this.endQuote2;
                        i += special.length();
                        continue;
                    }
                    if (this.direction != 0 && special == this.separator) {
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        i += special.length();
                        continue;
                    }
                }
            }
            new_element.append(n.charAt(i));
            ++i;
        }
        if (new_element.length() != 0) {
            this.elts.add(new_element.toString());
        }
        if (this.direction == -1) {
            int len = this.elts.size();
            i = 0;
            while (i < len / 2) {
                Object t = this.elts.set(i, this.elts.get(len - i - 1));
                this.elts.set(len - i - 1, t);
                ++i;
            }
        }
        if (quote != null) {
            throw new InvalidNameException("unterminated quote");
        }
    }
}

