/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private static transient Properties properties;
    private static transient Map countryMap;
    private static transient Map cache;
    private String currencyCode;
    private transient int fractionDigits;
    static /* synthetic */ Class class$java$util$Currency;

    public final String getCurrencyCode() {
        return this.currencyCode;
    }

    public final int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    public static final Currency getInstance(Locale locale) {
        Currency newCurrency;
        String country = locale.getCountry();
        if (locale == null || country == null) {
            throw new NullPointerException("The locale or its country is null.");
        }
        String code = (String)countryMap.get(country);
        if (code == null) {
            newCurrency = new Currency(locale);
            code = newCurrency.getCurrencyCode();
            if (code == null) {
                return null;
            }
            countryMap.put(country, code);
            cache.put(code, newCurrency);
        } else {
            newCurrency = (Currency)cache.get(code);
        }
        return newCurrency;
    }

    public static final Currency getInstance(String currencyCode) {
        if (currencyCode == null) {
            throw new NullPointerException("The supplied currency code is null.");
        }
        if (currencyCode.equals("XXX")) {
            return new Currency("XXX");
        }
        Currency newCurrency = (Currency)cache.get(currencyCode);
        if (newCurrency == null) {
            Locale[] allLocales = Locale.getAvailableLocales();
            int i = 0;
            while (i < allLocales.length) {
                try {
                    Currency testCurrency = Currency.getInstance(allLocales[i]);
                    if (testCurrency != null && testCurrency.getCurrencyCode().equals(currencyCode)) {
                        return testCurrency;
                    }
                }
                catch (IllegalArgumentException exception) {
                    // empty catch block
                }
                ++i;
            }
            throw new IllegalArgumentException("The currency code, " + currencyCode + ", is not supported.");
        }
        return newCurrency;
    }

    public final String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public final String getSymbol(Locale locale) {
        return LocaleHelper.getLocalizedString(locale, this.currencyCode, "currenciesSymbol", false, true);
    }

    public final String toString() {
        return this.getCurrencyCode();
    }

    private final Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Currency() {
    }

    private Currency(Locale loc) {
        String countryCode = loc.getCountry();
        if (countryCode.equals("")) {
            throw new IllegalArgumentException("Invalid (empty) country code for locale:" + loc);
        }
        String currencyKey = countryCode + ".currency";
        String fractionDigitsKey = countryCode + ".fractionDigits";
        this.currencyCode = properties.getProperty(currencyKey);
        if (this.currencyCode == null) {
            return;
        }
        int commaPosition = this.currencyCode.indexOf(",");
        if (commaPosition != -1) {
            this.currencyCode = this.currencyCode.substring(0, commaPosition);
        }
        this.fractionDigits = Integer.parseInt(properties.getProperty(fractionDigitsKey));
    }

    private Currency(String code) {
        this.currencyCode = code;
        this.fractionDigits = -1;
    }

    static {
        countryMap = new HashMap();
        cache = new HashMap();
        properties = new Properties();
        try {
            Class clazz = class$java$util$Currency;
            if (clazz == null) {
                clazz = class$java$util$Currency = Currency.class("[Ljava.util.Currency;", false);
            }
            properties.load(clazz.getResourceAsStream("iso4217.properties"));
        }
        catch (IOException exception) {
            System.out.println("Failed to load currency resource: " + exception);
        }
    }
}

