/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKzYeugAZ";
    private transient ArrayList tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCentury;
    private String pattern;
    private int serialVersionOnStream;

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.computeCenturyStart();
            this.serialVersionOnStream = 1;
        } else {
            this.set2DigitYearStart(this.defaultCenturyStart);
        }
        this.tokens = new ArrayList();
        try {
            this.compileFormat(this.pattern);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException("The stream pattern was invalid.");
        }
    }

    private final void compileFormat(String pattern2) {
        CompiledField current = null;
        int i = 0;
        while (i < pattern2.length()) {
            char thisChar = pattern2.charAt(i);
            int field = standardChars.indexOf(thisChar);
            if (field == -1) {
                current = null;
                if (thisChar >= 'A' && thisChar <= 'Z' || thisChar >= 'a' && thisChar <= 'z') {
                    throw new IllegalArgumentException("Invalid letter " + thisChar + "encountered at character " + i + '.');
                }
                if (thisChar == '\'') {
                    int pos = pattern2.indexOf(39, i + 1);
                    if (pos == i + 1) {
                        this.tokens.add("'");
                    } else {
                        StringBuffer buf = new StringBuffer();
                        int oldPos = i + 1;
                        while (true) {
                            if (pos == -1) {
                                throw new IllegalArgumentException("Quotes starting at character " + i + " not closed.");
                            }
                            buf.append(pattern2.substring(oldPos, pos));
                            if (pos + 1 >= pattern2.length() || pattern2.charAt(pos + 1) != '\'') break;
                            buf.append('\'');
                            oldPos = pos + 2;
                            pos = pattern2.indexOf(39, pos + 2);
                        }
                        this.tokens.add(buf.toString());
                    }
                    i = pos;
                } else {
                    this.tokens.add(new Character(thisChar));
                }
            } else if (current != null && field == current.field) {
                ++current.size;
            } else {
                current = new CompiledField(field, 1, thisChar);
                this.tokens.add(current);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer(this.getClass().getName());
        output.append("[tokens=");
        output.append(this.tokens);
        output.append(", formatData=");
        output.append(this.formatData);
        output.append(", defaultCenturyStart=");
        output.append(this.defaultCenturyStart);
        output.append(", defaultCentury=");
        output.append(this.defaultCentury);
        output.append(", pattern=");
        output.append(this.pattern);
        output.append(", serialVersionOnStream=");
        output.append(this.serialVersionOnStream);
        output.append(", standardChars=");
        output.append(standardChars);
        output.append("]");
        return output.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String localChars = this.formatData.getLocalPatternChars();
        return this.translateLocalizedPattern(this.pattern, standardChars, localChars);
    }

    public void applyPattern(String pattern2) {
        this.tokens = new ArrayList();
        this.compileFormat(pattern2);
        this.pattern = pattern2;
    }

    public void applyLocalizedPattern(String pattern2) {
        String localChars = this.formatData.getLocalPatternChars();
        pattern2 = this.translateLocalizedPattern(pattern2, localChars, standardChars);
        this.applyPattern(pattern2);
    }

    private final String translateLocalizedPattern(String pattern2, String oldChars, String newChars) {
        int len = pattern2.length();
        StringBuffer buf = new StringBuffer(len);
        boolean quoted = false;
        int i = 0;
        while (i < len) {
            int j;
            char ch = pattern2.charAt(i);
            if (ch == '\'') {
                quoted ^= true;
            }
            if (!quoted && (j = oldChars.indexOf(ch)) >= 0) {
                ch = newChars.charAt(j);
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.clear();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        this.defaultCentury = year - year % 100;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols formatData) {
        if (formatData == null) {
            throw new NullPointerException("The supplied format data was null.");
        }
        this.formatData = formatData;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)o;
        if (this.defaultCentury != sdf.defaultCentury) {
            return false;
        }
        if (!this.toPattern().equals(sdf.toPattern())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(sdf.getDateFormatSymbols());
    }

    public int hashCode() {
        return super.hashCode() ^ this.toPattern().hashCode() ^ this.defaultCentury ^ this.getDateFormatSymbols().hashCode();
    }

    private final void formatWithAttribute(Date date, FormatBuffer buffer, FieldPosition pos) {
        this.calendar.setTime(date);
        Iterator iter = this.tokens.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof CompiledField) {
                CompiledField cf = (CompiledField)o;
                int beginIndex = buffer.length();
                switch (cf.getField()) {
                    case 0: {
                        buffer.append(this.formatData.eras[this.calendar.get(0)], (AttributedCharacterIterator.Attribute)DateFormat.Field.ERA);
                        break;
                    }
                    case 1: {
                        buffer.setDefaultAttribute(DateFormat.Field.YEAR);
                        if (cf.getSize() == 2) {
                            String temp = "00" + String.valueOf(this.calendar.get(1));
                            buffer.append(temp.substring(temp.length() - 2));
                            break;
                        }
                        this.withLeadingZeros(this.calendar.get(1), cf.getSize(), buffer);
                        break;
                    }
                    case 2: {
                        buffer.setDefaultAttribute(DateFormat.Field.MONTH);
                        if (cf.getSize() < 3) {
                            this.withLeadingZeros(this.calendar.get(2) + 1, cf.getSize(), buffer);
                            break;
                        }
                        if (cf.getSize() < 4) {
                            buffer.append(this.formatData.shortMonths[this.calendar.get(2)]);
                            break;
                        }
                        buffer.append(this.formatData.months[this.calendar.get(2)]);
                        break;
                    }
                    case 3: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(5), cf.getSize(), buffer);
                        break;
                    }
                    case 4: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY1);
                        this.withLeadingZeros((this.calendar.get(11) + 23) % 24 + 1, cf.getSize(), buffer);
                        break;
                    }
                    case 5: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY0);
                        this.withLeadingZeros(this.calendar.get(11), cf.getSize(), buffer);
                        break;
                    }
                    case 6: {
                        buffer.setDefaultAttribute(DateFormat.Field.MINUTE);
                        this.withLeadingZeros(this.calendar.get(12), cf.getSize(), buffer);
                        break;
                    }
                    case 7: {
                        buffer.setDefaultAttribute(DateFormat.Field.SECOND);
                        this.withLeadingZeros(this.calendar.get(13), cf.getSize(), buffer);
                        break;
                    }
                    case 8: {
                        buffer.setDefaultAttribute(DateFormat.Field.MILLISECOND);
                        this.withLeadingZeros(this.calendar.get(14), cf.getSize(), buffer);
                        break;
                    }
                    case 9: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK);
                        if (cf.getSize() < 4) {
                            buffer.append(this.formatData.shortWeekdays[this.calendar.get(7)]);
                            break;
                        }
                        buffer.append(this.formatData.weekdays[this.calendar.get(7)]);
                        break;
                    }
                    case 10: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(6), cf.getSize(), buffer);
                        break;
                    }
                    case 11: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
                        this.withLeadingZeros(this.calendar.get(8), cf.getSize(), buffer);
                        break;
                    }
                    case 12: {
                        buffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(3), cf.getSize(), buffer);
                        break;
                    }
                    case 13: {
                        buffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(4), cf.getSize(), buffer);
                        break;
                    }
                    case 14: {
                        buffer.setDefaultAttribute(DateFormat.Field.AM_PM);
                        buffer.append(this.formatData.ampms[this.calendar.get(9)]);
                        break;
                    }
                    case 15: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR1);
                        this.withLeadingZeros((this.calendar.get(10) + 11) % 12 + 1, cf.getSize(), buffer);
                        break;
                    }
                    case 16: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR0);
                        this.withLeadingZeros(this.calendar.get(10), cf.getSize(), buffer);
                        break;
                    }
                    case 17: {
                        buffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        TimeZone zone = this.calendar.getTimeZone();
                        boolean bl = false;
                        if (this.calendar.get(16) != 0) {
                            bl = true;
                        }
                        boolean isDST = bl;
                        int n = 0;
                        if (cf.getSize() > 3) {
                            n = 1;
                        }
                        String zoneID = zone.getDisplayName(isDST, n);
                        buffer.append(zoneID);
                        break;
                    }
                    case 23: {
                        buffer.setDefaultAttribute(DateFormat.Field.RFC822_TIME_ZONE);
                        int pureMinutes = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
                        String sign = pureMinutes < 0 ? "-" : "+";
                        int hours = pureMinutes / 60;
                        int minutes = pureMinutes % 60;
                        buffer.append(sign);
                        this.withLeadingZeros(hours, 2, buffer);
                        this.withLeadingZeros(minutes, 2, buffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character " + cf.getCharacter());
                    }
                }
                if (pos == null || buffer.getDefaultAttribute() != pos.getFieldAttribute() && cf.getField() != pos.getField()) continue;
                pos.setBeginIndex(beginIndex);
                pos.setEndIndex(buffer.length());
                continue;
            }
            buffer.append(o.toString(), null);
        }
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition pos) {
        this.formatWithAttribute(date, new StringFormatBuffer(buffer), pos);
        return buffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object date) throws IllegalArgumentException {
        if (date == null) {
            throw new NullPointerException("null argument");
        }
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException("argument should be an instance of java.util.Date");
        }
        AttributedFormatBuffer buf = new AttributedFormatBuffer();
        this.formatWithAttribute((Date)date, buf, null);
        buf.sync();
        return new FormatCharacterIterator(buf.getBuffer().toString(), buf.getRanges(), buf.getAttributes());
    }

    private final void withLeadingZeros(int value, int length, FormatBuffer buffer) {
        String valStr = String.valueOf(value);
        length -= valStr.length();
        while (length > 0) {
            buffer.append('0');
            --length;
        }
        buffer.append(valStr);
    }

    private final boolean expect(String source, ParsePosition pos, char ch) {
        boolean r;
        int x = pos.getIndex();
        boolean bl = false;
        if (x < source.length() && source.charAt(x) == ch) {
            bl = true;
        }
        if (r = bl) {
            pos.setIndex(x + 1);
        } else {
            pos.setErrorIndex(x);
        }
        return r;
    }

    /*
     * Exception decompiling
     */
    public Date parse(String dateStr, ParsePosition pos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Integer computeOffset(String zoneString, ParsePosition pos) {
        Pattern pattern2 = Pattern.compile("(GMT)?([+-])([012])?([0-9]):?([0-9]{2})");
        Matcher matcher = pattern2.matcher(zoneString);
        boolean hasAll = matcher.lookingAt();
        try {
            matcher.group(2);
            matcher.group(4);
            matcher.group(5);
        }
        catch (IllegalStateException ise) {
            hasAll = false;
        }
        if (hasAll) {
            int sign = matcher.group(2).equals("+") ? 1 : -1;
            int hour = Integer.parseInt(matcher.group(4));
            if (!matcher.group(3).equals("")) {
                hour += Integer.parseInt(matcher.group(3)) * 10;
            }
            int minutes = Integer.parseInt(matcher.group(5));
            if (hour > 23) {
                return null;
            }
            int offset = sign * (hour * 60 + minutes) * 60000;
            pos.setIndex(pos.getIndex() + matcher.end());
            return new Integer(offset);
        }
        if (zoneString.startsWith("GMT")) {
            pos.setIndex(pos.getIndex() + 3);
            return new Integer(0);
        }
        return null;
    }

    private final void computeCenturyStart() {
        int year = this.calendar.get(1);
        this.calendar.set(1, year - 80);
        this.set2DigitYearStart(this.calendar.getTime());
    }

    public Object clone() {
        SimpleDateFormat clone = (SimpleDateFormat)super.clone();
        clone.setDateFormatSymbols((DateFormatSymbols)this.formatData.clone());
        clone.set2DigitYearStart((Date)this.defaultCenturyStart.clone());
        return clone;
    }

    private final /* synthetic */ void this() {
        this.serialVersionOnStream = 1;
    }

    public SimpleDateFormat() {
        this.this();
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = this.formatData.dateFormats[2] + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String pattern2) {
        this(pattern2, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern2, Locale locale) {
        this.this();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(pattern2);
        this.pattern = pattern2;
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String pattern2, DateFormatSymbols formatData) {
        this.this();
        this.calendar = new GregorianCalendar();
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        if (formatData == null) {
            throw new NullPointerException("formatData");
        }
        this.formatData = formatData;
        this.compileFormat(pattern2);
        this.pattern = pattern2;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CompiledField {
        int field;
        int size;
        private char character;

        public int getField() {
            return this.field;
        }

        public int getSize() {
            return this.size;
        }

        public char getCharacter() {
            return this.character;
        }

        public String toString() {
            StringBuffer builder = new StringBuffer(this.getClass().getName());
            builder.append("[field=");
            builder.append(this.field);
            builder.append(", size=");
            builder.append(this.size);
            builder.append(", character=");
            builder.append(this.character);
            builder.append("]");
            return builder.toString();
        }

        public CompiledField(int f, int s, char c) {
            this.field = f;
            this.size = s;
            this.character = c;
        }
    }
}

