/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.VMStackWalker;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.IntersectingDomainCombiner;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class VMAccessController {
    private static final ThreadLocal contexts = new ThreadLocal();
    private static final ThreadLocal inGetContext = new ThreadLocal();
    private static final AccessControlContext DEFAULT_CONTEXT;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$java$security$AccessController;

    private static final void debug(String msg) {
        System.err.print(">>> VMAccessController: ");
        System.err.println(msg);
    }

    static final void pushContext(AccessControlContext acc) {
        LinkedList stack = (LinkedList)contexts.get();
        if (stack == null) {
            stack = new LinkedList();
            contexts.set(stack);
        }
        stack.addFirst(acc);
    }

    static final void popContext() {
        LinkedList stack = (LinkedList)contexts.get();
        if (stack != null) {
            stack.removeFirst();
            if (stack.isEmpty()) {
                contexts.set(null);
            }
        }
    }

    static final AccessControlContext getContext() {
        DomainCombiner dc;
        Boolean inCall = (Boolean)inGetContext.get();
        if (inCall != null && inCall.booleanValue()) {
            return DEFAULT_CONTEXT;
        }
        inGetContext.set(Boolean.TRUE);
        Object[][] stack = VMAccessController.getStack();
        Class[] classes = (Class[])stack[0];
        String[] methods = (String[])stack[1];
        HashSet domains = new HashSet();
        HashSet seenDomains = new HashSet();
        AccessControlContext context = null;
        int privileged = 0;
        int i = 3;
        while (i < classes.length && privileged < 2) {
            ProtectionDomain domain;
            Class clazz;
            Class clazz2 = classes[i];
            String method = methods[i];
            if (privileged == 1) {
                privileged = 2;
            }
            if ((clazz = class$java$security$AccessController) == null) {
                clazz = VMAccessController.class("[Ljava.security.AccessController;", false);
            }
            if (clazz2.equals(clazz) && method.equals("doPrivileged")) {
                LinkedList l = (LinkedList)contexts.get();
                if (l != null) {
                    context = (AccessControlContext)l.getFirst();
                }
                privileged = 1;
            }
            if ((domain = clazz2.getProtectionDomain()) != null && !seenDomains.contains(domain)) {
                seenDomains.add(domain);
                domains.add(new ProtectionDomain(domain.getCodeSource(), domain.getPermissions()));
            }
            ++i;
        }
        ProtectionDomain[] result = (ProtectionDomain[])domains.toArray(new ProtectionDomain[domains.size()]);
        context = context != null ? ((dc = context.getDomainCombiner()) == null ? new AccessControlContext(IntersectingDomainCombiner.SINGLETON.combine(result, context.getProtectionDomains())) : new AccessControlContext(result, context, dc)) : new AccessControlContext(result);
        inGetContext.set(Boolean.FALSE);
        return context;
    }

    private static final Object[][] getStack() {
        return VMStackWalker.getStack();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private VMAccessController() {
    }

    static {
        CodeSource source = new CodeSource(null, null);
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        ProtectionDomain[] domain = new ProtectionDomain[]{new ProtectionDomain(source, permissions)};
        DEFAULT_CONTEXT = new AccessControlContext(domain);
    }
}

