/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ShortBufferImpl;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    short[] backing_buffer;

    public static ShortBuffer allocate(int capacity) {
        return new ShortBufferImpl(capacity);
    }

    public static final ShortBuffer wrap(short[] array, int offset, int length) {
        return new ShortBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final ShortBuffer wrap(short[] array) {
        return ShortBuffer.wrap(array, 0, array.length);
    }

    public ShortBuffer get(short[] dst, int offset, int length) {
        ShortBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public ShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ShortBuffer put(ShortBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            short[] toPut = new short[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public ShortBuffer put(short[] src, int offset, int length) {
        ShortBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final ShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final short[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = this.get(this.position()) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortBuffer) {
            boolean bl = false;
            if (this.compareTo(obj) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object obj) {
        ShortBuffer other = (ShortBuffer)obj;
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            short b;
            short a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();

    ShortBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }
}

