/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Throwable
implements Serializable {
    private final String detailMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private StackTraceElement stackTraceList;
    private transient VMThrowable vmState;

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public Throwable initCause(Throwable cause) {
        if (cause == this) {
            throw new IllegalArgumentException();
        }
        if (this.cause != this) {
            throw new IllegalStateException();
        }
        this.cause = cause;
        return this;
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        return this.getClass().getName() + (msg == null ? "" : ": " + msg);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        s.print(this.stackTraceString());
    }

    public void printStackTrace(PrintWriter pw) {
        pw.print(this.stackTraceString());
    }

    private final String stackTraceString() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stack = this.getStackTrace();
        Throwable.stackTraceStringBuffer(sb, this.toString(), stack, 0);
        Throwable cause = this.getCause();
        while (cause != null) {
            sb.append("Caused by: ");
            StackTraceElement[] parentStack = stack;
            stack = cause.getStackTrace();
            if (parentStack == null || parentStack.length == 0) {
                Throwable.stackTraceStringBuffer(sb, cause.toString(), stack, 0);
            } else {
                int equal = 0;
                int frame = stack.length - 1;
                int parentFrame = parentStack.length - 1;
                while (frame > 0 && parentFrame > 0) {
                    if (!stack[frame].equals(parentStack[parentFrame])) break;
                    ++equal;
                    --frame;
                    --parentFrame;
                }
                Throwable.stackTraceStringBuffer(sb, cause.toString(), stack, equal);
            }
            cause = cause.getCause();
        }
        return sb.toString();
    }

    private static final void stackTraceStringBuffer(StringBuffer sb, String name, StackTraceElement[] stack, int equal) {
        String nl = StaticData.nl;
        sb.append(name);
        sb.append(nl);
        if (stack == null || stack.length == 0) {
            sb.append("   <<No stacktrace available>>");
            sb.append(nl);
        } else {
            int i = 0;
            while (i < stack.length - equal) {
                sb.append("   at ");
                sb.append(stack[i] == null ? "<<Unknown>>" : stack[i].toString());
                sb.append(nl);
                ++i;
            }
            if (equal > 0) {
                sb.append("   ...");
                sb.append(equal);
                sb.append(" more");
                sb.append(nl);
            }
        }
    }

    public Throwable fillInStackTrace() {
        this.stackTraceList = this.nativeGetStackTraceList();
        return this;
    }

    private final native StackTraceElement nativeGetStackTraceList();

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            int n = 0;
            if (this.stackTraceList != null) {
                n = this.stackTraceList.length;
            }
            this.stackTrace = new StackTraceElement[n];
            int i = 0;
            while (this.stackTraceList != null) {
                this.stackTrace[i++] = this.stackTraceList;
                this.stackTraceList = this.stackTraceList.next;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        int i = stackTrace.length;
        StackTraceElement[] st = new StackTraceElement[i];
        while (--i >= 0) {
            st[i] = stackTrace[i];
            if (st[i] != null) continue;
            throw new NullPointerException("Element " + i + " null");
        }
        this.stackTrace = st;
    }

    private final /* synthetic */ void this() {
        this.cause = this;
    }

    public Throwable() {
        this((String)null);
    }

    public Throwable(String message) {
        this.this();
        this.fillInStackTrace();
        this.detailMessage = message;
    }

    public Throwable(String message, Throwable cause) {
        this(message);
        this.cause = cause;
    }

    public Throwable(Throwable cause) {
        this(cause == null ? null : cause.toString(), cause);
    }

    private static class StaticData {
        static final String nl = SystemProperties.getProperty("line.separator");

        private StaticData() {
        }
    }
}

